/* Copyright (c) 1988 Carrick Sean Casey. All rights reserved. */

/* send a packet along a socket file descriptor */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <errno.h>

int	sendpacket (int s, char *pkt);

int
sendpacket (int s, char *pkt)
{
	int ret;
	int totlength;

	/* set up a sample packet for testing purposes */
	totlength = (unsigned char)*pkt + 1;

	if ((ret = send(s, pkt, totlength, 0)) < 0) {
		if ((errno == EWOULDBLOCK) || (errno == EAGAIN))
			return(0);
		else if (errno == EPIPE)
			return(-2);
		else {
			/* DEBUG temorary fix */
			return(-2);
		}
	}
	if (ret != totlength)
		return(-1);
	return(1);
}
