/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "icb.h"
#include "externs.h"

char	*findspace (char *s);
void	quoteify (char *a, char *b);
char	*catargs (char **argv);
void	mbreakprint (int per, char *from, char *s);
int	wordcmp (char *s1, char *s2);
char	*getword (char *s);
int	split (char *s);
static void	mprint (int per, char *from, char *s);

#define OKGROUPCHARS	"-.!'$+,/?_"
#define OKNICKCHARS	"-.!'$+,/?_"

#define UC(x) ((x >= 'a' && x <= 'z') ? x & ~040 : x)

char *
findspace (char *s)
{
	/* find EOS or whitespace */
	while (*s != '\0' && *s != ' ' && *s != '\t') s++;

	if (*s == '\0')
		/* oops found no whitespace */
		return(0);
	else {
		/* point to char *after* whitespace */
		*s = '\0';
		return(++s);
	}
}

/* put a string in quotes */
/* puts backslashes before all special chars appearing in the string */
/* doesn't interfere with already backslashed chars */

char *special = "{}[]\";$\\";

void
quoteify (char *a, char *b)
{
	while (*a != '\0') {
		if (index(special, *a)) {
			*b++ = '\\';
			*b++ = *a;
		} else
			*b++ = *a;
		a++;
	}
	*b = '\0';
}


static char *catargsbuf = NULL;

char *
catargs (char **argv)
{
	char *s, **ap, *p;
	int len = 0;

	for (ap = argv; *ap; ++ap)
	{
		len+=strlen(*ap)+1;
	}
	
	if (catargsbuf)
		free(catargsbuf);

	if ((catargsbuf=(char *)malloc(len+1))==NULL)
	{
		fprintf(stderr,"Out of memory in catargs().\n");
		icbexit(0);
	}

	p = catargsbuf;
	while (*argv != NULL) {
		s = *argv;
		while (*s) *p++ = *s++;
		if (*(argv+1) != NULL)
			*p++ = ' ';
		argv++;
	}
	*p = '\0';
	return catargsbuf;
}

/* this is a bad hack! */

void
mbreakprint (int per, char *from, char *s)
{
	int count = 0;
	int max = MAX_TEXTLEN - 1;
	char *p, *lastw;
	char tmp1, tmp2;

	if (gv.printtime)
		max-=8;

	/* traverse s and try to break on a word */
	p = s;
	lastw = p;
	while (*p != '\0') {
		if (*p == '\n') {
			*p++ = '\0';
			mprint(per, from, s);
			count = 0;
			lastw = p;
			s = p;
			continue;
		}
		if (*p == ' ')
			/* remember location of last word break */
			lastw = p;

		/* break line if we are at max length */
		if (count == (MAX_TEXTLEN - 1)) {
			if ((p - lastw) > 40) {
				/* have to break in the middle of a word */
				tmp1 = *(p - 1);
				tmp2 = *p;
				*(p - 1) = '-';
				*p = '\0';
				mprint(per, from, s);
				*(p - 1) = tmp1;
				*p = tmp2;
				p--;
				s = p;
			} else {
				/* break at last space char */
				tmp1 = *lastw;
				*lastw = '\0';
				mprint(per, from, s);
				*lastw = tmp1;
				p = lastw + 1;
				s = p;
			}
			lastw = p;
			count = 0;
		} else {
			count++;
			p++;
		}
	}
	if (count > 0)
		mprint(per, from, s);
}

void
mprint (int per, char *from, char *s)
{
	if (per)
		sprintf(mbuf, "<*%s*> %s", from, s);
	else
		sprintf(mbuf, "<%s> %s", from, s);
	putl(mbuf, PL_ALL);
}

int
wordcmp (char *s1, char *s2)
{
	while(*s1 == *s2++)
		if (*s1 == '\0' || *s1 == ' ' || *s1++ == '\t')
			return(0);
	if (*s1 == ' ' && *(s2-1) == '\0')
		return(0);
	return(*s1 - *--s2);
}

char *
getword (char *s)
{
	static char word[64];
	char *w = word;
	while (*s != ' ' && *s != '\t' && *s != '\0' && ((w - word) < 64))
		*w++ = *s++;
	*w = '\0';
	return(word);
}

/* Read a line containing zero or more colons. Split the string into */
/* an array of strings, and return the number of fields found. */

char *fields[MAX_FIELDS];

int
split (char *s)
{
	char *p = s;
	int i = 0;

	fields[i] = s;
	for(;;) {

		i++;

		/* find delim or EOS */
		while(*p != '\001' && *p != '\0') p++;

		if (*p == '\001') {
			/* got delim */	
			*p = '\0';
			fields[i] = ++p;
		} else
			return(i);
	}
}
