/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* TCL interface */

#include "icb.h"
#include "externs.h"
#include <sys/dir.h>
#include <sys/file.h>
#include <stdlib.h>
#include <unistd.h>

void	tclinit (void);
void	tclreadicbrc (void);
static char	*getrcname (void);

Tcl_Interp *interp;

/* initialize TCL */
void
tclinit (void)
{
	extern char *defprocs[];
	int x;

	/* initialize the interpreter */
	interp = Tcl_CreateInterp();

	if (gv.restricted)
		Tcl_MakeSafe(interp);

	/* add the client primitives */
	Tcl_CreateCommand(interp, "oset", oset, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "ounset", ounset, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_log", c_log, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_hclear", c_hclear, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_hdel", c_hdel, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_help", c_help, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_hush", c_hush, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_quit", c_quit, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_rand", c_rand, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_replay", c_replay, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_shell", c_shell, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_time", c_time, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_usage", c_usage, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "c_version", c_version, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_admin", s_admin, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_beep", s_beep, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_bump", s_bump, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_chpw", s_chpw, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_motd", s_motd, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_group", s_group, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_open", s_open, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_personal", s_personal, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_register", s_register, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_send", s_send, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_user", s_user, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_version", s_version, (ClientData) 0, NULL);
	Tcl_CreateCommand(interp, "s_who", s_who, (ClientData) 0, NULL);

	/* set up the default bindings */
	for (x = 0; defprocs[x] != 0; x++)
		if (Tcl_Eval(interp, defprocs[x]) != TCL_OK) {
			printf("Default binding failed: %s\r\n", defprocs[x]);
			if (*Tcl_GetStringResult(interp) != 0)
				puts(Tcl_GetStringResult(interp));
		}

}

void
tclreadicbrc (void)
{
	char *path;
	char cmd[MAXNAMLEN+10];
	
	if (!(path = getrcname())) return;

	sprintf(cmd, "source %s", path);
	if (Tcl_Eval(interp, cmd) != TCL_OK) {
		printf("Error in rc file \"%s\".\r\n", path);
		if (*Tcl_GetStringResult(interp) != 0)
			puts(Tcl_GetStringResult(interp));
	}
}


/* find the pathname of the rc file to read */
/* ICBRC or FNRC optionally contains the pathname of the rc file */
/* if the file exists, then an error will be printed if it can't be read */

static char *
getrcname (void)
{
	static char *names[] = { ".icbrc", ".fnrc", ".tclrc" , (char *)NULL };
	char *rcfile, *homedir, **p;
	static char rcpath[MAXNAMLEN+1];	/* path of startup file */

	/* get name of file to use */
	if (((rcfile = getenv("ICBRC")) != NULL)
	 || ((rcfile = getenv("FNRC")) != NULL))
	{
		if (*rcfile != '/') {
			/* relative to HOME */
			if ((homedir = getenv("HOME")) == NULL) {
			      printf("icb: $HOME not set - can't read \"%s\"\r\n.",
				rcfile);
			      return(NULL);
			}
			sprintf(rcpath, "%s/%s", homedir, rcfile);
			rcfile = rcpath;
		}

		/* make sure the file is there */
		if (access(rcfile, (F_OK | R_OK)) < 0) {
			printf("icb: can't read rc file \"%s\".\r\n", rcfile);
			return(NULL);
		}

		return rcfile;
	} 

	if ((homedir = getenv("HOME")) == NULL) {
		printf("icb: warning - $HOME not set.\r\n");
		return(0);
	}

	for (p=names; p && *p; ++p)
	{
		sprintf(rcpath, "%s/%s", homedir, *p);
		rcfile = rcpath;
		if (access(rcfile, R_OK)==0)
			break;
	}
	if (p)
		return rcfile;

	return(0);
}
