/* Copyright (c) 1988 Carrick Sean Casey. All rights reserved. */
/* $Id$ */

/* main program loop */
/* active clients, new connections, and perform asynch dungeon action */

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "externs.h"

fd_set fdr, efdr;
int timeisup;

fd_set held_fdset;

void	serverserve (void);
#ifdef USE_ALARM
static void	gotalarm (int);
#endif
static void	sdoinput (void);

void
serverserve(void)
{
	int ret, i;
	long loopcount = 0; /* used to break loop for periodic didpoll */

	FD_ZERO (&held_fdset);	/* initialize it to empty */

	/* look at fd where new clients connect */
	if (restart) 
		for (i = 0; i < MAX_USERS+1; i++)
			cbufs[i].new = 1;

#ifdef USE_ALARM
	signal(SIGALRM, gotalarm);
#endif
	timeisup = 0;

	for (;;) {
#ifdef USE_ALARM
		if (polldelay) {
			if (setitimer(ITIMER_REAL, polldelay, 0) < 0) {
				perror("server: setitimer failed");
				icbexit(0);
			}
			timeisup = 0;
		}
#endif

		memmove(&fdr, &fdset, sizeof(fdset));
		memmove(&efdr, &fdset, sizeof(fdset));

		/* wait for input */
		/* NULL should be changed to a time value that reflects */
		/* how much activity is going on */

		setpolltimeout(10000);

		if ((ret = select(highestfd+1, &fdr, 0, &efdr, polltimeout)) < 1) {
			if (ret == 0 || errno == EINTR) {
				s_didpoll(0);
				timeisup = 0;
			} else {
				error("select: %s", strerror(errno));
			}
		}

		if (ret > 0)
			sdoinput();
		if (timeisup || !(++loopcount % 10))
		{
		    /* for all users, check held state */
		    for (i = 0; i < MAX_USERS+1; i++)
		    {
			/* if it's currently being held */
			if (FD_ISSET(i, &held_fdset) > 0)
			{
			    /* add it to fdset and remove it from held */
			    FD_SET (i, &fdset);
			    FD_CLR (i, &held_fdset);
			}
		    }
		    s_didpoll(0);
		}
	}
}

#ifdef USE_ALARM
static void
gotalarm(int n)
{
	timeisup++;
	signal(n, gotalarm);
}
#endif

static void
sdoinput(void)
{
	int n, x, fcarg;

	for (x = 1; x <= highestfd; x++)
		if (FD_ISSET(x, &efdr) > 0) {
			disconnectuser(x);
			}

	/* examine set of file descriptors */
	for (x = 1; x <= highestfd; x++) {
		int closed = 0;

		if (FD_ISSET(x, &fdr) > 0) {
			if (FD_ISSET(x,&serversocks)) {
				/* new connect on advertised socket */
				if ((n = newconnect(x)) > 0)
					/* let server init the user */
					s_new_user(n);
			} else {
				/* fd is client input */

				/* make the socket non-blocking */
				if (((fcarg = fcntl(x, F_GETFL, 0)) < 0 ||
				    fcntl(x, F_SETFL, fcarg | O_NONBLOCK)
				    < 0)) {
					perror("sdoinput:fcntl");
                			disconnectuser(x);
					continue;
				}

				switch(readpacket(x, &cbufs[x]))
				{
				case  1:
					/* complete packet */
					s_packet(x, cbufs[x].buf);
					break;
				case  0:
					/* incomplete packet */
					break;
				case -1:
					/* error */
					break;
				case -2:
					/* close connection */
					disconnectuser(x);
					closed = 1;
					break;
				}

				if (!closed) {
					if(fcntl(x, F_SETFL, 
					    fcarg & ~O_NONBLOCK) < 0) {
						perror("sdoinput: fcntl");
						disconnectuser(x);
					}
				}

			}
		}
	}
}
