/* Copyright (c) 1991 by John Atwood deVries II. */
/* $Id$ */
/* For copying and distribution information, see the file COPYING. */

/* signal handling routines */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"

/* The signal stuff is not portable, and should be in unix.c. */

void	trapsignals (void);
void	icbdump (int);
void	icbload (int);

void
trapsignals(void)
{
	/* exit on a hangup or terminate signal */
	signal(SIGHUP, cycle_logs);
	signal(SIGTERM, icbexit);
	signal(SIGINT, icbexit);
	signal(SIGUSR1, icbdump);
	signal(SIGUSR2, icbload);
}

/*ARGSUSED*/
void
icbdump (int sig)
{
    FILE *dump;
    int i, j, k;

    if ((dump = fopen("icbd.dump", "w")) == NULL) {
	error("icbd.dump open: %s", strerror(errno));
	return /* -1 */;
    }

#if defined(__DragonFly__)
    for (i = 0; i < 8; i++)
	fprintf (dump, "%lu\n", fdset.fds_bits[i]);
    for (i = 0; i < 8; i++)
	fprintf (dump, "%lu\n", serversocks.fds_bits[i]);
#else
    for (i = 0; i < 8; i++)
        fprintf (dump, "%d\n", fdset.fds_bits[i]);
    for (i = 0; i < 8; i++)
        fprintf (dump, "%d\n", serversocks.fds_bits[i]);
#endif

    fprintf (dump, "%d\n", highestfd);

    for (i = 0; i <= MAX_REAL_USERS; i++)
	fprintf (dump, "%d\n", S_kill[i]);

    for (i = 0; i < MAX_USERS; i++)
    {
	fprintf(dump, "%sX\n", u_tab[i].loginid);
	fprintf(dump, "%sX\n", u_tab[i].nodeid);
	fprintf(dump, "%sX\n", u_tab[i].nickname);
	fprintf(dump, "%sX\n", u_tab[i].password);
	fprintf(dump, "%sX\n", u_tab[i].realname);
	fprintf(dump, "%sX\n", u_tab[i].group);
	fprintf(dump, "%d\n", u_tab[i].login);
	fprintf(dump, "%d\n", u_tab[i].echoback);
	fprintf(dump, "%d\n", u_tab[i].nobeep);
	fprintf(dump, "%d\n", u_tab[i].t_notify);
	fprintf(dump, "%ld\n", u_tab[i].t_on);
	fprintf(dump, "%ld\n", u_tab[i].t_sent);
	fprintf(dump, "%ld\n", u_tab[i].t_recv);
	fprintf(dump, "%ld\n", u_tab[i].t_group);
	k = nlcount(*u_tab[i].pri_n_hushed);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(u_tab[i].pri_n_hushed));
	k = nlcount(*u_tab[i].pub_n_hushed);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(u_tab[i].pub_n_hushed));
	k = nlcount(*u_tab[i].pri_s_hushed);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(u_tab[i].pri_s_hushed));
	k = nlcount(*u_tab[i].pub_s_hushed);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(u_tab[i].pub_s_hushed));
	k = nlcount(*u_tab[i].n_notifies);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(u_tab[i].n_notifies));
	k = nlcount(*u_tab[i].s_notifies);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(u_tab[i].s_notifies));
    }

    for (i = 0; i < MAX_GROUPS; i++)
    {
	fprintf(dump, "%sX\n", g_tab[i].name);
	fprintf(dump, "%sX\n", g_tab[i].topic);
	fprintf(dump, "%d\n", g_tab[i].visibility);
	fprintf(dump, "%d\n", g_tab[i].control);
	fprintf(dump, "%d\n", g_tab[i].mod);
	fprintf(dump, "%ld\n", g_tab[i].modtimeout);
	fprintf(dump, "%sX\n", g_tab[i].missingmod);
	fprintf(dump, "%d\n", g_tab[i].volume);
	k = nlcount(*g_tab[i].n_invites);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].n_invites));
	k = nlcount(*g_tab[i].nr_invites);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].nr_invites));
	k = nlcount(*g_tab[i].s_invites);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].s_invites));
	k = nlcount(*g_tab[i].sr_invites);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].sr_invites));
	k = nlcount(*g_tab[i].n_bars);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].n_bars));
	k = nlcount(*g_tab[i].n_nr_bars);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].n_nr_bars));
	k = nlcount(*g_tab[i].s_bars);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].s_bars));
	k = nlcount(*g_tab[i].s_nr_bars);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].s_nr_bars));

	k = nlcount(*g_tab[i].n_talk);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].n_talk));
	k = nlcount(*g_tab[i].nr_talk);
	fprintf(dump, "%d\n", k);
	if (k > 0)
		for (j = 0; j < k; j++)
			fprintf(dump, "%sX\n", nlget(g_tab[i].nr_talk));
    }

    fclose(dump);
}

/*ARGSUSED*/
void
icbload (int sig)
{
    FILE *dump;
    int i,j;
    long k;
    char name[80], name2[80];

    if ((dump = fopen("icbd.dump", "r")) == NULL) {
	error("icbd.dump open: %s", strerror(errno));
	return;
    }

    init_groups();
    clear_users();

    for (i = 0; i < 8; i++) {
	fscanf (dump, "%ld\n", &k);
	fdset.fds_bits[i] = k;
    }
    for (i = 0; i < 8; i++) {
	fscanf (dump, "%ld\n", &k);
	serversocks.fds_bits[i] = k;
    }

    fscanf (dump, "%d\n", &highestfd);
    for (i = 0; i <= MAX_REAL_USERS; i++) {
	fscanf (dump, "%ld\n", &k);
	S_kill[i] = (int)k;
    }

    for (i = 0; i < MAX_USERS; i++)
    {
	fgets(name, 80, dump);
	strlcpy(u_tab[i].loginid, name, MAX_IDLEN+1);
	u_tab[i].loginid[strlen(name)-2] = '\0';
	fgets(name, 80, dump);
	strlcpy(u_tab[i].nodeid, name, MAX_NODELEN+1);
	u_tab[i].nodeid[strlen(name)-2] = '\0';
	fgets(name, 80, dump);
	strlcpy(u_tab[i].nickname, name, MAX_NICKLEN+1);
	u_tab[i].nickname[strlen(name)-2] = '\0';
	fgets(name, 80, dump);
	strlcpy(u_tab[i].password, name, MAX_PASSWDLEN+1);
	u_tab[i].password[strlen(name)-2] = '\0';
	fgets(name, 80, dump);
	strlcpy(u_tab[i].realname, name, MAX_REALLEN+1);
	u_tab[i].realname[strlen(name)-2] = '\0';
	fgets(name, 80, dump);
	strlcpy(u_tab[i].group, name, MAX_GROUPLEN+1);
	u_tab[i].group[strlen(name)-2] = '\0';
	fscanf(dump, "%d\n", &j);
	u_tab[i].login = j;
	fscanf(dump, "%d\n", &j);
	u_tab[i].echoback = j;
	fscanf(dump, "%d\n", &j);
	u_tab[i].nobeep = j;
	fscanf(dump, "%d\n", &j);
	u_tab[i].t_notify = j;
	fscanf(dump, "%ld\n", &k);
	u_tab[i].t_on = k;
	fscanf(dump, "%ld\n", &k);
	u_tab[i].t_sent = k;
	fscanf(dump, "%ld\n", &k);
	u_tab[i].t_recv = k;
	fscanf(dump, "%ld\n", &k);
	u_tab[i].t_group = k;
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
	fscanf(dump, "%d\n", &j);
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(u_tab[i].pri_n_hushed, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
	fscanf(dump, "%d\n", &j);
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(u_tab[i].pub_n_hushed, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
	fscanf(dump, "%d\n", &j);
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(u_tab[i].pri_s_hushed, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
	fscanf(dump, "%d\n", &j);
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(u_tab[i].pub_s_hushed, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
	fscanf(dump, "%d\n", &j);
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(u_tab[i].n_notifies, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(u_tab[i].s_notifies, name2);
		}
    }

    for (i = 0; i < MAX_GROUPS; i++)
    {
	fgets(name, 80, dump);
	strlcpy(g_tab[i].name, name, MAX_GROUPLEN+1);
	g_tab[i].name[strlen(name)-2] = '\0';
	fgets(name, 80, dump);
	strlcpy(g_tab[i].topic, name, MAX_TOPICLEN+1);
	g_tab[i].topic[strlen(name)-2] = '\0';
	fscanf(dump, "%d\n", &j);
	g_tab[i].visibility = j;
	fscanf(dump, "%d\n", &j);
	g_tab[i].control = j;
	fscanf(dump, "%d\n", &j);
	g_tab[i].mod = j;
	fscanf(dump, "%ld\n", &k);
	g_tab[i].modtimeout = k;
	fgets(name, 80, dump);
	strlcpy(g_tab[i].missingmod, name, MAX_NICKLEN+1);
	g_tab[i].missingmod[strlen(name)-2] = '\0';
	fscanf(dump, "%d\n", &j);
	g_tab[i].volume = j;
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].n_invites, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].nr_invites, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].s_invites, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].sr_invites, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].n_bars, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].n_nr_bars, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].s_bars, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--) {
		fgets(name, 80, dump);
		strlcpy(name2, name, 80);
		nlput(g_tab[i].s_nr_bars, name2);
		}
	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--)
	{
	    fgets(name, 80, dump);
	    strlcpy(name2, name, 80);
	    nlput(g_tab[i].n_talk, name2);
	}

	fscanf(dump, "%d\n", &j);
	for (; j > 0; j--)
	{
	    fgets(name, 80, dump);
	    strlcpy(name2, name, 80);
	    nlput(g_tab[i].nr_talk, name2);
	}
    }

    fclose(dump);
}
