/* Copyright (c) 1991 by John Atwood deVries II. */
/* $Id: users.c,v 1.14 2001/10/26 21:56:36 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* user table manipulation */

#include <stdlib.h>
#include <string.h>
#include "externs.h"

void	clear_user_item (int);
void	fill_user_entry (int, char *, char *, char *, char *, char *, int, int, int);
void	clear_users (void);
int	count_users_in_group (char *);
int	find_user (const char *);

/* clear a particular user entry */
void
clear_user_item(int n)
{
	if (u_tab[n].login > 0)
		nickwritetime(n, 1);

	u_tab[n].loginid[0] = '\0';
	u_tab[n].nodeid[0] = '\0';
	u_tab[n].nickname[0] = '\0';
	u_tab[n].password[0] = '\0';
	u_tab[n].realname[0] = '\0';
	u_tab[n].group[0] = '\0';

	u_tab[n].login = 0;
	u_tab[n].echoback = 0;
	u_tab[n].nobeep = 0;
	u_tab[n].t_on = (long) 0;
	u_tab[n].t_sent= (long) 0;
	u_tab[n].t_recv = (long) 0;
	u_tab[n].t_group = (long) 0;

	nlclear(u_tab[n].pri_n_hushed);
	nlclear(u_tab[n].pub_n_hushed);
	nlclear(u_tab[n].pri_s_hushed);
	nlclear(u_tab[n].pub_s_hushed);
	nlclear(u_tab[n].n_notifies);
	nlclear(u_tab[n].s_notifies);
	S_kill[n] = 0;
}

/* fill a particular user entry */
void
fill_user_entry(int n, char *loginid, char *nodeid, char *nickname, char *password, char *group,
		int mylogin, int echoback, int nobeep)
{
	strlcpy(u_tab[n].loginid, loginid, MAX_IDLEN+1);
	strlcpy(u_tab[n].nodeid, nodeid, MAX_NODELEN+1);
	strlcpy(u_tab[n].nickname, nickname, MAX_NICKLEN+1);
	strlcpy(u_tab[n].password, password, MAX_PASSWDLEN+1);

	strlcpy(u_tab[n].group, group, MAX_GROUPLEN+1);
	u_tab[n].login = mylogin;
	u_tab[n].echoback = echoback;
	u_tab[n].t_notify = 0;
	u_tab[n].nobeep = nobeep;
}


/* clear the entire user table */
void
clear_users(void)
{
	int i;

	for (i=0; i<MAX_USERS; i++ ) {
		u_tab[i].pri_n_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
		nlinit(u_tab[i].pri_n_hushed, MAX_HUSHED);
		u_tab[i].pub_n_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
		nlinit(u_tab[i].pub_n_hushed, MAX_HUSHED);
		u_tab[i].pri_s_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
		nlinit(u_tab[i].pri_s_hushed, MAX_HUSHED);
		u_tab[i].pub_s_hushed = (NAMLIST *) malloc(sizeof(NAMLIST));
		nlinit(u_tab[i].pub_s_hushed, MAX_HUSHED);
		u_tab[i].n_notifies = (NAMLIST *) malloc(sizeof(NAMLIST));
		nlinit(u_tab[i].n_notifies, MAX_HUSHED);
		u_tab[i].s_notifies = (NAMLIST *) malloc(sizeof(NAMLIST));
		nlinit(u_tab[i].s_notifies, MAX_HUSHED);
		clear_user_item(i);
	}
}

/* check the user table to see how many of them belong to a particular group */
int
count_users_in_group(char *group)
{
	int result = 0;
	int i;

        /* don't attempt to find if null */
        if (strlen(group) == 0)
                return result;
	
	for (i=0; i<MAX_USERS; i++) {
		if (strcasecmp(u_tab[i].group,group) == 0) {
			result++;
		}
	}
	return result;
}

/* find a slot in the user table with a particular name */
/* return that index if found, -1 otherwise */
/* case insensitive */

int
find_user (const char *name)
{
        int result = -1;
        int i;

        /* don't attempt to find if null */
        if (strlen(name) == 0)
                return result;

	/* search through table */
        for (i=0; i<MAX_USERS; i++) {
                if ( strcasecmp(u_tab[i].nickname, name) == 0) {
                        result = i;
                        break;
                }
        }
        return result;
}
