"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectedTraceIndex = getSelectedTraceIndex;
exports.getFilteredTopTraces = getFilteredTopTraces;
exports.getAllTraces = getAllTraces;
exports.getTraceChildren = getTraceChildren;
exports.getTraceParents = getTraceParents;
exports.getTraceFrames = getTraceFrames;
exports.getAllMutationTraces = getAllMutationTraces;
exports.getAllTraceCount = getAllTraceCount;
exports.getRuntimeVersions = getRuntimeVersions;
exports.getTracerEventNames = getTracerEventNames;
exports.getTraceDomEvent = getTraceDomEvent;
exports.getTraceHighlightedDomEvents = getTraceHighlightedDomEvents;

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at <http://mozilla.org/MPL/2.0/>. */
function getSelectedTraceIndex(state) {
  return state.tracerFrames?.selectedTraceIndex;
}

function getFilteredTopTraces(state) {
  return state.tracerFrames?.mutableFilteredTopTraces || [];
}

function getAllTraces(state) {
  return state.tracerFrames?.mutableTraces || [];
}

function getTraceChildren(state) {
  return state.tracerFrames?.mutableChildren || [];
}

function getTraceParents(state) {
  return state.tracerFrames?.mutableParents || [];
}

function getTraceFrames(state) {
  return state.tracerFrames?.mutableFrames || [];
}

function getAllMutationTraces(state) {
  return state.tracerFrames?.mutableMutationTraces || [];
}

function getAllTraceCount(state) {
  return state.tracerFrames?.mutableTraces.length || 0;
}

function getRuntimeVersions(state) {
  return {
    localPlatformVersion: state.tracerFrames?.localPlatformVersion,
    remotePlatformVersion: state.tracerFrames?.remotePlatformVersion
  };
}

function getTracerEventNames(state) {
  return state.tracerFrames?.mutableEventNames;
}

function getTraceDomEvent(state) {
  return state.tracerFrames?.domEvents || new Set();
}

function getTraceHighlightedDomEvents(state) {
  return state.tracerFrames?.highlightedDomEvents || [];
}