/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	LIBPICOPB_PB_PROP_H
#define	LIBPICOPB_PB_PROP_H

#include <pb.h>

struct pb_prop_field {
	const struct pb_msgdesc	*pbpf_msgdesc;
	size_t			pbpf_fieldno;
	union {
		const struct pb_prop_enumeration	*enumeration;
		const struct pb_prop_msgdesc		*message;
	}			pbpf_u;
};

struct pb_prop_enumerand {
	const char	*pbped_string;
	int32_t		pbped_number;
};

struct pb_prop_enumeration {
	const struct pb_prop_enumerand	*pbpen_by_string;
	const struct pb_prop_enumerand	*pbpen_by_number;
	size_t				pbpen_nenumerands;
};

struct pb_prop_array {
	const struct pb_msgdesc		*pbpa_msgdesc;
	const struct pb_prop_field	*pbpa_field;
};

struct pb_prop_record {
	const struct pb_prop_record_field	*pbpr_fields;
	size_t					pbpr_nfields;
};

struct pb_prop_record_field {
	struct pb_prop_field	pbprf_field;
	const char		*pbprf_key;
};

struct pb_prop_splice {
	const struct pb_prop_msgdesc	*pbps_msgdesc;
};

struct pb_prop_msgdesc {
	const struct pb_msgdesc	*pbpm_msgdesc;
	union {
		struct pb_prop_array	array;
		struct pb_prop_record	record;
		struct pb_prop_splice	splice;
	}			pbpm_u;
	enum {
		PB_PROP_MSG_ARRAY,
		PB_PROP_MSG_RECORD,
		PB_PROP_MSG_SPLICE,
	}			pbpm_t;
};

#endif	/* LIBPICOPB_PB_PROP_H */
