/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <err.h>
#include <errno.h>
#include <inttypes.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pb.h>
#include <pb_prop.h>
#include <pb_prop_encode.h>
#include <pb_prop_decode.h>
#include <prop/proplib.h>

#include "hdaudio.pb.h"

static const struct pb_prop_enumerand hdaudio_fgrp_type__propenum_by_number[] = {
	{
		.pbped_string = "unknown",
		.pbped_number = 0,
	},
	{
		.pbped_string = "afg",
		.pbped_number = 1,
	},
	{
		.pbped_string = "vsmfg",
		.pbped_number = 2,
	},
};

static const struct pb_prop_enumerand hdaudio_fgrp_type__propenum_by_string[] = {
	{
		.pbped_string = "afg",
		.pbped_number = 1,
	},
	{
		.pbped_string = "unknown",
		.pbped_number = 0,
	},
	{
		.pbped_string = "vsmfg",
		.pbped_number = 2,
	},
};

static const struct pb_prop_enumeration hdaudio_fgrp_type__propenum = {
	.pbpen_by_number = hdaudio_fgrp_type__propenum_by_number,
	.pbpen_by_string = hdaudio_fgrp_type__propenum_by_string,
	.pbpen_nenumerands = 3,
};

static const struct pb_prop_record_field hdaudio_fgrp_info__fgrp__proprecord_fields[] = {
	{
		.pbprf_key = "type",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 0,
			.pbpf_u = { .enumeration = &hdaudio_fgrp_type__propenum, },
		},
	},
	{
		.pbprf_key = "nid",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 1,
		},
	},
	{
		.pbprf_key = "codecid",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 2,
		},
	},
	{
		.pbprf_key = "vendor-id",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 3,
		},
	},
	{
		.pbprf_key = "product-id",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 4,
		},
	},
	{
		.pbprf_key = "subsystem-id",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 5,
		},
	},
	{
		.pbprf_key = "device",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
			.pbpf_fieldno = 6,
		},
	},
};

static const struct pb_prop_msgdesc hdaudio_fgrp_info__fgrp__prop = {
	.pbpm_msgdesc = &hdaudio_fgrp_info__fgrp__msgdesc,
	.pbpm_t = PB_PROP_MSG_RECORD,
	.pbpm_u = { .record = {
		.pbpr_fields = hdaudio_fgrp_info__fgrp__proprecord_fields,
		.pbpr_nfields = sizeof(hdaudio_fgrp_info__fgrp__proprecord_fields) /
		    sizeof(hdaudio_fgrp_info__fgrp__proprecord_fields[0]),
	} },
};

static const struct pb_prop_record_field hdaudio_fgrp_info__proprecord_fields[] = {
	{
		.pbprf_key = "function-group-info",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_info__msgdesc,
			.pbpf_fieldno = 0,
			.pbpf_u = { .message = &hdaudio_fgrp_info__fgrp__prop },
		},
	},
};

static const struct pb_prop_msgdesc hdaudio_fgrp_info__prop = {
	.pbpm_msgdesc = &hdaudio_fgrp_info__msgdesc,
	.pbpm_t = PB_PROP_MSG_RECORD,
	.pbpm_u = { .record = {
		.pbpr_fields = hdaudio_fgrp_info__proprecord_fields,
		.pbpr_nfields = sizeof(hdaudio_fgrp_info__proprecord_fields) /
		    sizeof(hdaudio_fgrp_info__proprecord_fields[0]),
	} },
};

static const struct pb_prop_record_field hdaudio_fgrp_pin_config__pin__proprecord_fields[] = {
	{
		.pbprf_key = "nid",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_pin_config__pin__msgdesc,
			.pbpf_fieldno = 0,
		},
	},
	{
		.pbprf_key = "config",
		.pbprf_field = {
			.pbpf_msgdesc = &hdaudio_fgrp_pin_config__pin__msgdesc,
			.pbpf_fieldno = 1,
		},
	},
};

static const struct pb_prop_msgdesc hdaudio_fgrp_pin_config__pin__prop = {
	.pbpm_msgdesc = &hdaudio_fgrp_pin_config__pin__msgdesc,
	.pbpm_t = PB_PROP_MSG_RECORD,
	.pbpm_u = { .record = {
		.pbpr_fields = hdaudio_fgrp_pin_config__pin__proprecord_fields,
		.pbpr_nfields = sizeof(hdaudio_fgrp_pin_config__pin__proprecord_fields) /
		    sizeof(hdaudio_fgrp_pin_config__pin__proprecord_fields[0]),
	} },
};

static const struct pb_prop_field hdaudio_fgrp_pin_config__proparray_field = {
	.pbpf_msgdesc = &hdaudio_fgrp_pin_config__msgdesc,
	.pbpf_fieldno = 0,
	.pbpf_u = { .message = &hdaudio_fgrp_pin_config__pin__prop },
};

static const struct pb_prop_msgdesc hdaudio_fgrp_pin_config__prop = {
	.pbpm_msgdesc = &hdaudio_fgrp_pin_config__msgdesc,
	.pbpm_t = PB_PROP_MSG_ARRAY,
	.pbpm_u = { .array = {
		.pbpa_msgdesc = &hdaudio_fgrp_pin_config__msgdesc,
		.pbpa_field = &hdaudio_fgrp_pin_config__proparray_field,
	} },
};

int
main(int argc, char **argv)
{
	prop_array_t arr;
	prop_object_t obj;
	struct hdaudio_fgrp_pin_config pin_config;
	char *plist;
	int error;

	if (argc != 3 || strcmp(argv[1], "-d") != 0)
		errx(1, "Usage: %s -d <prop>\n", getprogname());

	arr = prop_array_internalize_from_file(argv[2]);
	if (arr == NULL)
		errx(1, "failed to read prop arr");

	pb_init(hdaudio_fgrp_pin_config(&pin_config));
	error = pb_prop_decode(hdaudio_fgrp_pin_config(&pin_config),
	    &hdaudio_fgrp_pin_config__prop, arr);
	if (error) {
		errno = error;
		err(1, "decode prop arr");
	}

	prop_object_release(arr);
	arr = NULL;

	error = pb_prop_encode(hdaudio_fgrp_pin_config(&pin_config),
	    &hdaudio_fgrp_pin_config__prop, &obj);
	if (error) {
		errno = error;
		err(1, "encode prop arr");
	}
	assert(prop_object_type(obj) == PROP_TYPE_ARRAY);
	arr = obj;
	plist = prop_array_externalize(arr);
	if (plist == NULL)
		errx(1, "failed to encode prop arr");
	(void)printf("%s", plist);
	free(plist);

	prop_object_release(arr);
	pb_destroy(hdaudio_fgrp_pin_config(&pin_config));

	return 0;
}
