/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	SCC_H
#define	SCC_H

#include <stdbool.h>
#include <stddef.h>

struct scc_vertex {
	struct scc_vertex	*sv_cycle;
	struct scc_vertex	*sv_scc_next;
	struct scc_edge		*sv_dfs_edge;
	size_t			sv_index;
	size_t			sv_lowlink;
	bool			sv_scc_stuck;
};

/* Opaque, caller-supplied.  */
struct scc_edge;

void	strongly_connected_components(void *,
	    struct scc_vertex *(*)(void *, struct scc_vertex *),
	    struct scc_edge *(*)(void *, struct scc_vertex *,
		struct scc_edge *),
	    struct scc_vertex *(*)(void *, struct scc_edge *),
	    struct scc_vertex *(*)(void *, struct scc_edge *),
	    void (*)(void *, struct scc_vertex *));

/* Returns the next vertex in the component.  Equal to V if no cycle.  */
static inline struct scc_vertex *
scc_vertex_next(struct scc_vertex *V)
{

	return V->sv_cycle;
}

#endif	/* SCC_H */
