 /*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	PICOPBC_STRUNG_H
#define	PICOPBC_STRUNG_H

#include <stddef.h>
#include <stdint.h>

struct string {
	char		*s_ptr;
	size_t		s_len;
};

static const struct string string_null;

#define	STRING_NULL	{ .s_ptr = NULL, .s_len = 0 }

static inline struct string
string(char *ptr, size_t len)
{
	struct string s;

	s.s_ptr = ptr;
	s.s_len = len;

	return s;
}

#define	STRING_CONST(s)	string((char *)(uintptr_t)(s ""), strlen(s ""))

static inline char *
string_ptr(struct string s)
{
	return s.s_ptr;
}

static inline size_t
string_len(struct string s)
{
	return s.s_len;
}

static inline struct string
substring(struct string s, size_t start, size_t end)
{
	struct string ss;

	ss.s_ptr = s.s_ptr + start;
	ss.s_len = end - start;

	return ss;
}

static inline struct string
string_prefix(struct string s, size_t end)
{
	struct string sp;

	sp.s_ptr = s.s_ptr;
	sp.s_len = s.s_len - end;

	return sp;
}

static inline struct string
string_suffix(struct string s, size_t start)
{
	struct string su;

	su.s_ptr = s.s_ptr + start;
	su.s_len = s.s_len - start;

	return su;
}

void		string_free(struct string);

struct string	string_emalloc(size_t);
struct string	string_erealloc(struct string, size_t);
struct string	string_ecopy(struct string);

struct string	string_adoptz(char *, size_t);
struct string	string_edupz(const char *, size_t);

struct string	string_econcat(struct string, struct string);
struct string	string_econcatn(const struct string *, ...);
struct string	string_econcat_into(struct string, struct string);
struct string	string_econcatn_into(const struct string *, ...);

int		string_order(struct string, struct string);

char *		string_evisciiz(struct string);

#endif	/* PICOPBC_STRUNG_H */
