# Copyright (c) 2009, 2010 Nhat Minh Lê
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
# COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
# OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

atf_test_case descendant
descendant_head()
{
	atf_set "descr" "Checks correct evaluation of descendant predicates"
}
descendant_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_descendant.out"	\
	    xmlgrep '{a//z}' "$(atf_get_srcdir)/d_descendant.in"
}

atf_test_case longest
longest_head()
{
	atf_set "descr" "Checks correct selection of longest match"
}
longest_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_longest.out"	\
	    xmlgrep 'a|{a%b%c}|{a%b%c%d}|{a%b}'				\
	    "$(atf_get_srcdir)/d_longest.in"
}

atf_test_case anchor_start
anchor_start_head()
{
	atf_set "descr" "Checks correct anchoring at first sibling"
}
anchor_start_body()
{
	atf_check -s eq:0 -o ignore				\
	    xmlgrep '<a%b%c%d'					\
	    "$(atf_get_srcdir)/d_longest.in"
	atf_check -s eq:0 -o ignore				\
	    xmlgrep '<a%b%c'					\
	    "$(atf_get_srcdir)/d_longest.in"
	atf_check -s eq:1 -o ignore				\
	    xmlgrep '<b%c'					\
	    "$(atf_get_srcdir)/d_longest.in"
}

atf_test_case anchor_end
anchor_end_head()
{
	atf_set "descr" "Checks correct anchoring at last sibling"
}
anchor_end_body()
{
	atf_check -s eq:0 -o ignore				\
	    xmlgrep 'a%b%c%d>'					\
	    "$(atf_get_srcdir)/d_longest.in"
	atf_check -s eq:1 -o ignore				\
	    xmlgrep 'a%b>'					\
	    "$(atf_get_srcdir)/d_longest.in"
	atf_check -s eq:0 -o ignore				\
	    xmlgrep 'b%c%d>'					\
	    "$(atf_get_srcdir)/d_longest.in"
}

atf_test_case anchor_both
anchor_both_head()
{
	atf_set "descr" "Checks correct double anchoring"
}
anchor_both_body()
{
	atf_check -s eq:0 -o ignore				\
	    xmlgrep '<a%b%c%d>'					\
	    "$(atf_get_srcdir)/d_longest.in"
	atf_check -s eq:1 -o ignore				\
	    xmlgrep '<a%b%c>'					\
	    "$(atf_get_srcdir)/d_longest.in"
	atf_check -s eq:0 -o ignore				\
	    xmlgrep 'a%b%c'					\
	    "$(atf_get_srcdir)/d_longest.in"
}

atf_test_case nullable
nullable_head()
{
	atf_set "descr" "Checks correct handling of nullable patterns"
}
nullable_body()
{
	atf_check -s eq:0						\
	    -o file:"$(atf_get_srcdir)/d_nullable.out"			\
	    xmlgrep '{a%t?%b}' "$(atf_get_srcdir)/d_nullable.in"
	atf_check -s eq:0						\
	    -o file:"$(atf_get_srcdir)/d_nullable_nocapture.out"	\
	    xmlgrep -d x 'a%t?' "$(atf_get_srcdir)/d_nullable.in"
	atf_check -s eq:0						\
	    -o file:"$(atf_get_srcdir)/d_nullable_capture.out"		\
	    xmlgrep -d x '{a%t?}' "$(atf_get_srcdir)/d_nullable.in"
}

atf_test_case plist_value
plist_value_head()
{
	atf_set "descr" "Checks plist dict value selection by key"
}
plist_value_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_plist_value.out"	\
	    xmlgrep '(key/text()=E)%*' "$(atf_get_srcdir)/d_plist_a.in"
}

atf_test_case plist_key
plist_key_head()
{
	atf_set "descr" "Checks plist dict key selection by value"
}
plist_key_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_plist_key.out"	\
	    xmlgrep '*[key%string/text()=Bar]'				\
	    "$(atf_get_srcdir)/d_plist_a.in"
}

atf_test_case plist_key_value_key
plist_key_value_key_head()
{
	atf_set "descr" "Checks plist dict key and value selection by key"
}
plist_key_value_key_body()
{
	atf_check -s eq:0						\
	    -o file:"$(atf_get_srcdir)/d_plist_key_value_key.out"	\
	    xmlgrep '{(key/text()=EB)%*}'				\
	    "$(atf_get_srcdir)/d_plist_a.in"
}

atf_test_case plist_key_value_value
plist_key_value_value_head()
{
	atf_set "descr" "Checks key and value selection by value"
}
plist_key_value_value_body()
{
	atf_check -s eq:0						\
	    -o file:"$(atf_get_srcdir)/d_plist_key_value_value.out"	\
	    xmlgrep '{key%true}' "$(atf_get_srcdir)/d_plist_a.in"
}

atf_test_case plist_key_value_complex
plist_key_value_complex_head()
{
	atf_set "descr" "Checks key and value selection with a complex path"
}
plist_key_value_complex_body()
{
	atf_check -s eq:0						\
	    -o file:"$(atf_get_srcdir)/d_plist_key_value_complex.out"	\
	    xmlgrep '{(key/text()=E)%dict/key/text()=EB}'		\
	    "$(atf_get_srcdir)/d_plist_a.in"
}

atf_test_case entities_unknown
entities_unknown_head()
{
	atf_set "descr" "Checks proper handling of unknown entities"
}
entities_unknown_body()
{
	atf_check -s eq:0					\
	    -o file:"$(atf_get_srcdir)/d_entities_unknown.out"	\
	    xmlgrep -E 'text()="&a;&b;&c;"'			\
	    "$(atf_get_srcdir)/d_entities.in"
}

atf_test_case entities_builtin
entities_builtin_head()
{
	atf_set "descr" "Checks proper handling of builtin entities"
}
entities_builtin_body()
{
	atf_check -s eq:0					\
	    -o file:"$(atf_get_srcdir)/d_entities_builtin.out"	\
	    xmlgrep -E 'text()="&quot;&amp;"'			\
	    "$(atf_get_srcdir)/d_entities.in"
}

atf_test_case entities_fail
entities_fail_head()
{
	atf_set "descr" "Checks that xmlgrep -E fails on unknown entities"
}
entities_fail_body()
{
	atf_check -s eq:2 -e ignore		\
	    xmlgrep 'text()="&quot;&amp;"'	\
	    "$(atf_get_srcdir)/d_entities.in"
}

atf_test_case context
context_head()
{
	atf_set "descr"							  \
	    "Checks that xmlgrep -C does not mangle or duplicate context"
}
context_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_context.out"	\
	    xmlgrep -C 'z' "$(atf_get_srcdir)/d_context.in"
}

atf_test_case reverse
reverse_head()
{
	atf_set "descr"							\
	    "Checks that xmlgrep -v properly deletes matched elements"
}
reverse_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_reverse.out"	\
	    xmlgrep -v 'z' "$(atf_get_srcdir)/d_context.in"
}

atf_test_case scope
scope_head()
{
	atf_set "descr" "Checks correct scoping"
}
scope_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_scope.out"	\
	    xmlgrep -s foo 'x' "$(atf_get_srcdir)/d_scope.in"
}

atf_test_case scope_context
scope_context_head()
{
	atf_set "descr" "Checks correct scoping with context printing"
}
scope_context_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_scope_context.out" \
	    xmlgrep -Cs foo 'x' "$(atf_get_srcdir)/d_scope.in"
}

atf_test_case scope_pipe_lhs
scope_pipe_lhs_head()
{
	atf_set "descr" "Checks scope passing in a pipe (lhs)"
}
scope_pipe_lhs_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_scope_pipe_lhs.out" \
	    xmlgrep -Cd foo '{z}|{b}' "$(atf_get_srcdir)/d_context.in"
}

atf_test_case scope_pipe
scope_pipe_head()
{
	atf_set "descr" "Checks scope passing in a pipe (rhs)"
}
scope_pipe_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_scope_pipe.out"	     \
	    xmlgrep -vs foo.2 '*/*' "$(atf_get_srcdir)/d_scope_pipe_lhs.out"
}

atf_test_case regex
regex_head()
{
	atf_set "descr"	"Checks regex predicates"
}
regex_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_regex.out"	\
	    xmlgrep '{node()/text()~"(ab)+"}'				\
	    "$(atf_get_srcdir)/d_regex.in"
}

atf_test_case attr
attr_head()
{
	atf_set "descr"	"Checks attribute predicates with nullable attribute"
}
attr_body()
{
	atf_check -s eq:0 -o file:"$(atf_get_srcdir)/d_attr.out"	\
	    xmlgrep '@ax' "$(atf_get_srcdir)/d_attr.in"
}

atf_init_test_cases()
{
	atf_add_test_case descendant
	atf_add_test_case longest
	atf_add_test_case anchor_start
	atf_add_test_case anchor_end
	atf_add_test_case anchor_both
	atf_add_test_case nullable

	atf_add_test_case plist_value
	atf_add_test_case plist_key
	atf_add_test_case plist_key_value_key
	atf_add_test_case plist_key_value_value
	atf_add_test_case plist_key_value_complex

	atf_add_test_case entities_unknown
	atf_add_test_case entities_builtin
	atf_add_test_case entities_fail

	atf_add_test_case context
	atf_add_test_case reverse
	atf_add_test_case scope
	atf_add_test_case scope_context
	atf_add_test_case scope_pipe_lhs
	atf_add_test_case scope_pipe

	atf_add_test_case regex
	atf_add_test_case attr
}
