/*
 * nasd_keymgmt_afs.c
 *
 * Routines to access keys
 *
 * Author: Howard Gobioff
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#define PRINT_ERROR 1

#ifdef DEBUG_ALL
#define DEBUG_INIT_KEY_MGMT 1
#define DEBUG_KEYS
#endif

#include <nasd/nasd_options.h>
#include <nasd/nasd_keymgmt_afs.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>

/* This is a hacked module that has one set of keys for everyone --
the sole purpose is to get the demo up and running */



NASD_DECLARE_MUTEX(keylock)


nasd_key_t red_key;
nasd_key_t black_key;
nasd_key_t partition_key;

/* Our lock on the key hiearchy - grab it when you
   change or read a lock*/



nasd_status_t nasd_security_init_key_mgmt(char *keyfile,char *password,int init_from_key){

#if NASD_SECURE_RPCS_ENABLE > 0
 
  nasd_partnum_t partnum;
  int i;

  nasd_mutex_init(&keylock);
  
  partnum=1;
  for(i=0;i<sizeof(nasd_key_t);i++) {
    
    partition_key[i]=partnum;
    red_key[i]=partnum+1;
    black_key[i]=partnum+2;
  }

  return NASD_SUCCESS;
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
}

nasd_status_t nasd_security_get_red_key(int foo, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  bcopy(red_key,target,sizeof(nasd_key_t));
  NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}


nasd_status_t nasd_security_get_black_key(int foo, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  bcopy(black_key,target,sizeof(nasd_key_t));
  NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}


nasd_status_t nasd_security_get_partition_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  bcopy(partition_key,target,sizeof(nasd_key_t));
  NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}





