/*
 * nasd_cheops_cl_vnasd.h
 *
 * Cheops client clerk service module exporting a virtual NASD interface
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_CHEOPS_CL_VNASD_H_
#define _NASD_CHEOPS_CL_VNASD_H_

#include <nasd/nasd_options.h>
#include <stdio.h>
#include <sys/errno.h>

#include <nasd/nasd_types.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_cache.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_raidmap.h>

/* clerk initialization functions */
extern int _nasd_cheops_cl_init(
  char                  *resource_file,
  int                    default_binding,
  int                    override_defaults,
  int                    quietude);

/* the cheops clerk (virtual NASD) interface */
extern void _nasd_null_cl(
  nasd_cheops_handle_t   client_handle, 
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_getattr_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_identifier_t      in_identifier,
  nasd_partnum_t         in_partnum,
  nasd_attribute_t      *out_attribute,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_setattr_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_identifier_t      in_identifier,
  nasd_attribute_t      *in_attribute,
  nasd_fieldmask_t       in_fieldmask,
  nasd_partnum_t         in_partnum,
  nasd_guard_t           in_guard,
  nasd_attribute_t      *out_attribute,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_write_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_identifier_t      in_identifier,
  nasd_offset_t          in_offset,
  nasd_len_t             in_len,
  nasd_partnum_t         in_partnum,
  nasd_len_t            *out_len,
  nasd_byte_t           *in_data,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_read_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_identifier_t      in_identifier,
  nasd_offset_t          in_offset,
  nasd_len_t             in_len,
  nasd_partnum_t         in_partnum,
  nasd_len_t            *out_len,
  nasd_byte_t           *out_data,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_access_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_identifier_t      in_identifier,
  nasd_cookie_t         *out_capability, /* FIX -- */
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_part_create_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie, 
  nasd_partnum_t         in_partnum,  
  nasd_uint64            in_blkcnt,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_qos_create_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_attribute_t       in_attribute,
  nasd_fieldmask_t       in_fieldmask,
  nasd_partnum_t         in_partnum,
  nasd_cheops_qos_req_t  in_qos_req,
  nasd_identifier_t     *out_identifier,
  nasd_attribute_t      *out_attribute,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_create_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_attribute_t       in_attribute,
  nasd_fieldmask_t       in_fieldmask,
  nasd_partnum_t         in_partnum,
  nasd_identifier_t     *out_identifier,
  nasd_attribute_t      *out_attribute,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

extern void _nasd_remove_cl(
  nasd_cheops_handle_t   client_handle,
  nasd_cookie_t          in_cookie,
  nasd_identifier_t      in_identifier,
  nasd_status_t         *nasd_status,
  nasd_rpc_status_t     *op_status);

#endif /* !_NASD_CHEOPS_CL_VNASD_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
