/*
 * nasd_cheops_util.c
 */
/*
 * General Utility Routines
 *
 */
/*
 * Copyright (c) 1996,1997,1998,1999 Carnegie Mellon University.
 * All rights reserved.
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon the
 * rights to redistribute these changes.
 */
#include <nasd/nasd_options.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>

#include <sys/errno.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_cheops_cache.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_locks.h>

/* nasd_cheops_walk_str - walk over the given string, returning a pointer to
                          the next whitespace-delimited word, and advancing
                          the pointer just beyond it for the next call. */

char *
nasd_cheops_walk_str(
  char  **inout_ptr)
{
  char *ptr = *inout_ptr;
  char *ret;

  if (!*ptr)
    ret = NULL;
  else {
    while (*ptr)
      if ((*ptr != ' ') && (*ptr != '\t'))
        break;
      else
        ptr++;
    ret = ptr;
    while (*ptr)
      if ((*ptr == ' ') || (*ptr == '\t'))
        break;
      else
        ptr++;
    if (*ptr)
      *ptr++ = '\0';
    *inout_ptr = ptr;
  }
  return ret;
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
