/*
 * nasd_generic_addts.c
 *
 * Generic inc/add/subtract nasd timespec for most OSes.
 * Not very fast (involves locking/unlocking a mutex), but is portable.
 * If your architecture has atomic inc/add/sub operations, you probably
 * want to write a machine-specific version of this file.
 *
 * Authors: Jim Zelenka, Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_threadstuff.h>

NASD_SYS_DECLARE_EXTERN_MUTEX(nasd_atomic_global_mutex);

void
nasd_atomic_add_timespec(
  nasd_timespec_t  *result,
  nasd_timespec_t  *addend)
{
  NASD_SYS_LOCK_MUTEX(nasd_atomic_global_mutex);
  NASD_TIMESPEC_ADD(*result,*addend);
  NASD_SYS_UNLOCK_MUTEX(nasd_atomic_global_mutex);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
