/*
 * nasd_common_otw.c
 *
 * To convert the 64 bit ints for DCE
 *
 * Authors: Erik Riedel, Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_types.h>

#include <nasd/nasd_pdrive.h> 
#include <nasd/nasd_mem.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE

#define PERFORM_TRICKERY  /* if this is set, then we just point the output at the input */

void nasd_int64_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_dceidl_int64 *out)
{
  *out = *((nasd_dceidl_int64*)in);
}

void nasd_int64_to_xmit(nasd_dceidl_int64* in, nasd_dceidl_int64_otw_t **out)
{
#ifdef _KERNEL
  /* XXX - we can't allocate kernel memory (too slow), so we're going to cheat */
  *out = (nasd_dceidl_int64_otw_t *)in;
#else /* _KERNEL */
#ifdef PERFORM_TRICKERY
  *out = (nasd_dceidl_int64_otw_t *)in;
#else /* PERFORM_TRICKERY */
  *out = (nasd_dceidl_int64_otw_t *)malloc(sizeof(nasd_dceidl_int64_otw_t));
  *((nasd_dceidl_int64 *)*out) = *in;
#endif /* PERFORM_TRICKERY */
#endif /* _KERNEL */
}

void nasd_int64_free_inst(nasd_dceidl_int64 *in)
{
  /* nothing to do here */
}

void nasd_int64_free_xmit(nasd_dceidl_int64_otw_t *in)
{
#ifdef _KERNEL
  /* in the kernel we cheated (see above) */
#else /* _KERNEL */
#ifdef PERFORM_TRICKERY
  /* cheat (see above) */
#else /* PERFORM_TRICKERY */
  free(in);
#endif /* PERFORM_TRICKERY */
#endif /* _KERNEL */
}



void nasd_uint64_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_dceidl_uint64 *out)
{
  *out = *((nasd_dceidl_uint64*)in);
}

void nasd_uint64_to_xmit(nasd_dceidl_uint64* in, nasd_dceidl_int64_otw_t **out)
{
  *out = (nasd_dceidl_int64_otw_t *)in;
}

void nasd_uint64_free_inst(nasd_dceidl_uint64 *in)
{
  /* nothing to do here */
}

void nasd_uint64_free_xmit(nasd_dceidl_int64_otw_t *in)
{
  /* nothing to do here */
}



void nasd_identifier_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_identifier_t *out)
{
  *out = *((nasd_identifier_t*)in);
}

void nasd_identifier_t_to_xmit(nasd_identifier_t* in, nasd_dceidl_int64_otw_t **out)
{
  *out = (nasd_dceidl_int64_otw_t *)in;
}

void nasd_identifier_t_free_inst(nasd_identifier_t *in)
{
  /* nothing to do here */
}

void nasd_identifier_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{
  /* nothing to do here */
}

#if NASD_ALIGN_OTW_TYPES > 0
void nasd_otw_base_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_otw_base_t *out)
{
  *out = *((nasd_otw_base_t*)in);
}

void nasd_otw_base_t_to_xmit(nasd_otw_base_t* in, nasd_dceidl_int64_otw_t **out)
{
  *out = (nasd_dceidl_int64_otw_t *)in;
}

void nasd_otw_base_t_free_inst(nasd_otw_base_t *in)
{
  /* nothing to do here */
}

void nasd_otw_base_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{
  /* nothing to do here */
}
#endif /* NASD_ALIGN_OTW_TYPES > 0 */


/* The rest of them cheat in the kernel and outside */

void nasd_edrfs_marker_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_edrfs_marker_t *out)
{ *out = *((nasd_edrfs_marker_t*)in); }

void nasd_edrfs_marker_t_to_xmit(nasd_edrfs_marker_t* in, nasd_dceidl_int64_otw_t **out)
{ *out = (nasd_dceidl_int64_otw_t *)in; }

void nasd_edrfs_marker_t_free_inst(nasd_edrfs_marker_t *in)
{ /* nothing to do here */ }

void nasd_edrfs_marker_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{ /* nothing to do */ }


void nasd_edrfs_markerv_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_edrfs_markerv_t *out)
{ *out = *((nasd_edrfs_markerv_t*)in); }

void nasd_edrfs_markerv_t_to_xmit(nasd_edrfs_markerv_t* in, nasd_dceidl_int64_otw_t **out)
{ *out = (nasd_dceidl_int64_otw_t *)in; }

void nasd_edrfs_markerv_t_free_inst(nasd_edrfs_markerv_t *in)
{ /* nothing to do here */ }

void nasd_edrfs_markerv_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{ /* nothing to do */ }


void nasd_disk_ident_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_disk_ident_t *out)
{ *out = *((nasd_disk_ident_t*)in); }

void nasd_disk_ident_t_to_xmit(nasd_disk_ident_t* in, nasd_dceidl_int64_otw_t **out)
{ *out = (nasd_dceidl_int64_otw_t *)in; }

void nasd_disk_ident_t_free_inst(nasd_disk_ident_t *in)
{ /* nothing to do here */ }

void nasd_disk_ident_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{ /* nothing to do */ }


void nasd_offset_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_offset_t *out)
{ *out = *((nasd_offset_t*)in); }

void nasd_offset_t_to_xmit(nasd_offset_t* in, nasd_dceidl_int64_otw_t **out)
{ *out = (nasd_dceidl_int64_otw_t *)in; }

void nasd_offset_t_free_inst(nasd_offset_t *in)
{ /* nothing to do here */ }

void nasd_offset_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{ /* nothing to do */ }


void nasd_opcount_t_from_xmit(nasd_dceidl_int64_otw_t *in, nasd_opcount_t *out)
{ *out = *((nasd_opcount_t*)in); }

void nasd_opcount_t_to_xmit(nasd_opcount_t* in, nasd_dceidl_int64_otw_t **out)
{ *out = (nasd_dceidl_int64_otw_t *)in; }

void nasd_opcount_t_free_inst(nasd_opcount_t *in)
{ /* nothing to do here */ }

void nasd_opcount_t_free_xmit(nasd_dceidl_int64_otw_t *in)
{ /* nothing to do */ }

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
