/*
 * nasd_drive_tunable.c
 *
 * Global declarations of tunable drive parameters.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_drive_options.h>
#include <nasd/nasd_cache.h>

/*
 * What percentage of the disk might be inodes
 */
int nasd_od_nnpt_pcg = 75;

/*
 * When prefetching regions, stop clustering forward or backward if
 * a block is unused (physical refcount = 0).
 */
int nasd_odc_pfcontig_only = 0;

/*
 * When prefetching regions, be willing to fetch useless blocks
 */
int nasd_odc_pfcontig_useless = 1;

/*
 * When prefetching regions, abort clustering when we hit an
 * in-core block (avoid skipping)
 */
int nasd_odc_pfcontig_noskip = 1;

/*
 * When prefetching, override above settings to allow skipping
 * after the fetch block.
 *
 * 0 = no override
 * 1 = skip past incore blocks
 * 2 = skip past incore blocks, skip over noref blocks
 */
int nasd_odc_pfcontig_afterskip_policy = 2;

/*
 * Read whole regions at once.
 *
 * !!! Reassigned by most layout policy modules !!!
 */
int nasd_odc_read_regions = 0;

/*
 * Number of blocks in cache.
 *
 * !!! Resassigned by drive front-end !!!
 */
int nasd_odc_size = 1024;

/*
 * Number of buckets in cache hash table
 */
int nasd_odc_buckets = 127;

/*
 * Number of buckets in ident cache hash table
 */
int nasd_odc_logical_index_buckets = 128;

/*
 * Do we force alignment of the first datablock?
 * If so, to what boundary? (0 = no force)
 * This is a byte count.
 */
int nasd_od_force_align_disk_boundary = 131072;

/*
 * How many sectors reserved for system overhead
 */
nasd_sectcnt_t nasd_overhead_sects = 1;

/*
 * How many blocks are in a region.
 * (Multiple subsystems are interested in this;
 * layout policies which use regions are obligated
 * to use this as the size of those regions.)
 */
int nasd_od_region_blocks = 16;

/*
 * How many blocks to map at a time for read or write
 *
 * This may have any value in the range 1..MAX_BLOCKMAPCHUNK
 * It should *not* be patched while the drive is dispatching
 * I/Os. Someone should do some studies sometime to see how
 * diddling this affects performance.
 */
int nasd_od_obj_blockmapchunk = 32;

/*
 * Chunksize for hashing hints for list of unallocated blocks
 */
int nasd_drive_unallocated_hash_chunk = 800;

/*
 * Max blocks to coalesce into one I/O
 */
int nasd_drive_io_max_coalesce = 8;

/*
 * Similarly, prevent I/Os from crossing some alignment boundary.
 * This is useful if running on something like a striper or RAIDframe.
 * This is in terms of sectors (64=32k, 128=64k, ...).
 */
int nasd_drive_io_cluster_align = 256;

nasd_uint64 nasd_od_shutdown_timeouts_max = 10;
nasd_timespec_t nasd_od_shutdown_timeout_interval = {1, 0};

#if NASD_TRACE_DR > 0
int nasd_dt_max_trace_size = 1048576;
#endif /* NASD_TRACE_DR > 0 */

#if defined(DEC_OSF) && defined(KERNEL)
int nasd_k_flush_check_milliseconds = 2000; /* how often to check */
int nasd_k_flush_interval           = 3;    /* how many checks before force */
int nasd_k_dirty_percent            = 30;   /* % can be dirty before flush */

#endif /* defined(DEC_OSF) && defined(KERNEL) */

#ifndef KERNEL
int nasd_od_rusage_at_shutdown = 0;
#endif /* !KERNEL */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
