/*
 * nasd_keymgmt_edrfs.c
 *
 * Routines to access keys 
 *
 * Author: Howard Gobioff
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#define PRINT_ERROR 1
#ifdef DEBUG_ALL
#define DEBUG_INIT_KEY_MGMT 1
#endif

#include <nasd/nasd_options.h>
#include <nasd/nasd_keymgmt.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_security.h>

#include <nasd/nasd_mem.h>


/* Our lock on the key hiearchy - grab it when you
   change or read a lock*/
NASD_DECLARE_MUTEX(keylock)


nasd_status_t nasd_security_init_key_mgmt(char *keyfile,char *password,int init_from_key){
#if NASD_SECURE_RPCS_ENABLE > 0
  nasd_key_t master_key,drive_key,red_key,black_key,part_key;
  nasd_partnum_t partnum;
  int i;
#if  DEBUG_INIT_KEY_MGMT > 0
  nasd_printf("Initializing Keylock \n");
#endif
  nasd_mutex_init(&keylock);
  return NASD_SUCCESS;
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
}

nasd_status_t nasd_security_get_red_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}



nasd_status_t nasd_security_get_black_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}


nasd_status_t nasd_security_get_partition_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}

nasd_status_t  nasd_security_get_master_key(nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
 NASD_LOCK_MUTEX(keylock); 
 NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
return NASD_SUCCESS;
}


nasd_status_t  nasd_security_get_drive_key(nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
 NASD_LOCK_MUTEX(keylock); 
 NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
return NASD_SUCCESS;
}




nasd_status_t nasd_security_set_red_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  NASD_UNLOCK_MUTEX(keylock);
  nasd_edrfs_write_diskstate();
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}



nasd_status_t nasd_security_set_black_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  NASD_UNLOCK_MUTEX(keylock);
  nasd_edrfs_write_diskstate();
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}


nasd_status_t nasd_security_set_partition_key(nasd_partnum_t partnum, nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
  NASD_LOCK_MUTEX(keylock);
  NASD_UNLOCK_MUTEX(keylock);
  nasd_edrfs_write_diskstate();
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
  return NASD_SUCCESS;
}



nasd_status_t  nasd_security_set_drive_key(nasd_key_t target){
#if NASD_SECURE_RPCS_ENABLE > 0
 NASD_LOCK_MUTEX(keylock); 
 NASD_UNLOCK_MUTEX(keylock);
 nasd_edrfs_write_diskstate();
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
return NASD_SUCCESS;
}


nasd_status_t  nasd_security_initialize_drive(nasd_key_t master_key, nasd_key_t drive_key){

nasd_status_t rc=NASD_SUCCESS;
#if NASD_SECURE_RPCS_ENABLE > 0
 NASD_LOCK_MUTEX(keylock);
 NASD_UNLOCK_MUTEX(keylock);
#endif /* NASD_SECURE_RPCS_ENABLE >0*/
return rc;
}




nasd_status_t  nasd_edrfs_read_diskstate(){
	return NASD_SUCCESS;
}


nasd_status_t  nasd_edrfs_write_diskstate(){
  nasd_status_t err=NASD_SUCCESS;
  return err;
}
