/*
 * get_nasdid.c
 *
 * example program to demonstrate some of the EDRFS ioctls
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include <nasd/nasd_options.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_edrfs_client.h>
#include <nasd/linux/nasd_edrfs_client_linux_ioctl.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main(int argc, char **argv) {
  nasd_edrfs_file_ident_t fid;
  int fd, rc;
  const char *filename, *drive;
  struct in_addr in;
  
  if (argc < 2) {
    nasd_printf("I don't have enough arguments. Bye!\n");
    exit(1);
  }
  
  filename = argv[1];
  
  fd = open(filename, O_RDONLY);

  if (fd == -1) {
    perror("Couldn't open file");
    exit(1);
  }

  rc = ioctl(fd, NASD_EDRFS_GET_NASDID, &fid);
  if (rc == -1) {
    perror("ioctl failed");
    exit(1);
  }

  in.s_addr = fid.drive_address;
  drive = inet_ntoa(in);

  nasd_printf("File '%s' is backed by:\n", filename);
  nasd_printf("\tNASD ID 0x%" NASD_ID_FMT " in partition %d of drive '%s'\n",
	      fid.nasd_identifier, fid.partnum, drive);

  return(0);
}
