/*
 * nasd_cheops_ios.h
 *
 * mapping and access prototypes for different raid levels
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__CHEOPS_IOS_H_
#define _NASD__CHEOPS_IOS_H_

#include <stdio.h>
#include <malloc.h>

#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_raidmap.h>

#define _NASD_CHEOPS_CL_NUM_DOIO_THREADS 1

typedef enum {
  _NASD_CHEOPS_READ_IO,        /* read data stripe unit */
	_NASD_CHEOPS_RAID0_WRITE_IO, /* write data stripe unit */
	_NASD_CHEOPS_RAID1_WRITE_IO, /* write data stripe unit and its mirrored copy serially */
	_NASD_CHEOPS_TSWRITE_IO,    /* write data stripe unit with a timestamp check */
	_NASD_CHEOPS_GETATTR_IO,     /* getattr */
	_NASD_CHEOPS_SETATTR_IO      /* setattr */
} _nasd_cheops_io_type_t;

typedef struct _nasd_cheops_aggr_io_s {
  NASD_DECLARE_MUTEX(flag_mutex)
  NASD_DECLARE_COND(ios_all_done)
  int				 num_ios;
  int				 num_done;
  int				 in_datalen;
  int				 out_datalen;
  struct _nasd_cheops_io_s	*first_io;
  nasd_status_t			 nasd_status; /* set if any child io failed */
  nasd_rpc_status_t		 status;      /* set if any child io failed */
  int				 errors;      /* which ios have failed */
} _nasd_cheops_aggr_io_t;

typedef struct _nasd_cheops_io_s {
  _nasd_cheops_io_type_t         type;
  nasd_key_t                     req_key;
  nasd_identifier_t              ni;
  nasd_disk_ident_t              di;
  nasd_identifier_t              pni;
  nasd_disk_ident_t              pdi;
  int                            lblock;
  nasd_uint64                    bms_targ;
  int                            in_datalen;
  int                            in_offset;
  nasd_byte_t                   *databuf;
  nasd_host_tag_t                host_tag;
  int                            out_datalen;
  nasd_status_t                  nasd_status;
  nasd_rpc_status_t              status;
  struct _nasd_cheops_io_s      *qnext;
  struct _nasd_cheops_io_s      *qprev;
  struct _nasd_cheops_io_s      *cnext;
  struct _nasd_cheops_aggr_io_s *parent_io;  
} _nasd_cheops_io_t;


typedef struct _nasd_cheops_ioq_s {
  NASD_DECLARE_MUTEX(q_mutex)
  NASD_DECLARE_COND(q_not_empty)
  _nasd_cheops_io_t     *q_head;
  _nasd_cheops_io_t     *q_tail;
  int                    q_n_sig;
  int                    q_n;
  int                    q_n_deq;
} _nasd_cheops_ioq_t;

#endif /* !_NASD_CHEOPS_IOS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
