/*
 * nasd_drive_options.h
 *
 * drive-specific nasd_options.h
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DRIVE_OPTIONS_H_
#define _NASD__NASD_DRIVE_OPTIONS_H_

#include <nasd/nasd_options.h>


/*
 * Chunks of code to include/not include
 */


/* keep basic I/O subsys stats */
#define NASD_IO_KEEP_STATS 1

/* tracing in drive */
#define NASD_TRACE_DR 0

#if (NASD_SECURE_RPCS_ENABLE > 0)
/* Use key cache */
#define  NASD_USE_KEY_CACHE 1
#endif /* NASD_SECURE_RPCS_ENABLE  > 0*/

/* when using region-based layout, activate scoreboard */
#define NASD_NL_REG_SCOREBOARD 0

/* determine expense of maintianing region scoreboard */
#define NASD_NL_REG_SCOREBOARD_TIMERS 0

/* extended direct pointers in the drive, aka precomputed digests */
/* this does not work correctly yet, so it is turned off by default. */
#if NASD_SECURE_RPCS_ENABLE > 0
#define NASD_OD_EXT_PTR 0
#else /* NASD_SECURE_RPCS_ENABLE > 0 */
#define NASD_OD_EXT_PTR 0
#endif /* NASD_SECURE_RPCS_ENABLE > 0 */

/* keep timers for I/O subsys */
#define NASD_IO_TIMERS 1

/* keep timers for ioqueue subsys */
#define NASD_IOQUEUE_TIMERS 1

/* disable concurrent DCE pipe operations */
#define NASD_DRIVE_DISABLE_CONCURRENT_DCE_PIPES 1

/*
 * Compile-time policy decisions
 */


/*
 * 0 = simple lru
 * 1 = multiple chances for metadata
 * 2 = multiple LRUs
 */
#define NASD_DRIVE_BLOCK_REPLACEMENT 1

/* wire refcnt blocks */
#define NASD_DRIVE_WIRE_REFCNT 1

/* preread refcnts into cache at startup */
#define NASD_DRIVE_PREREAD_REFCNT 1

/*
 * 0 = NPT blocks swappable
 * 1 = NPT1 blocks swappable
 * 2 = NPT not swappable
 */
#define NASD_DRIVE_WIRE_NPT 1

/* preread NPT into cache at startup */
#define NASD_DRIVE_PREREAD_NPT 0

/* maximum number of blocks to map at a time in read/write */
#define NASD_DRIVE_MAX_BLOCKMAPCHUNK 32

/*
 * If zero, try to create inode in same hash table
 * block as last create. If nonzero, do it in the one
 * after that.
 */
#define NASD_DRIVE_ROTATE_CREATE 0

/*
 * 0 = allow nasd_odc_block_get_part2() to do all
 *     clustering when fetching inode blocks
 *     in nasd_odc_node_get()
 * 1 = always fully cluster I/Os within nasd_odc_node_get()
 * 2 = fully cluster unless inode is first block
 */
#define NASD_DRIVE_INODE_FETCH_CLUSTER_POLICY 2




/*
 * Debugging options
 */


/* keep track of enqueue file and line */
#define NASD_DRIVE_TRACK_IO_ENQUEUE_INFO 0

/* print info about system shutting down */
#define NASD_DRIVE_SHUTDOWN_DEBUG       1
#define NASD_DRIVE_AUTO_SHUTDOWN_DEBUG  NASD_SHUTDOWN_ANNOUNCE_NONE

/* track cache block release */
#define NASD_DRIVE_DEBUG_RELEASE 0

/* debug I/O lock */
#define NASD_IO_LOCK_DEBUG 0

/*
 * I/O module should keep debugging list of outstanding I/O.
 * Currently only supported by nasd_od_kio.c
 */
#define NASD_DRIVE_DEBUG_PHYS_OUTSTANDING 0

/*
 * Pluggable modules to include/not include
 */

/*
 * Disk queueing (be sure to include the default!)
 */
#define NASD_DRIVE_IOQUEUE_INCLUDE_CSCAN  1
#define NASD_DRIVE_IOQUEUE_INCLUDE_FIFO   1

/*
 * Layout (be sure to include the default!)
 */
#define NASD_DRIVE_LAYOUT_SEQUENTIAL_INCLUDE  1
#define NASD_DRIVE_LAYOUT_REGION_INCLUDE      1


/*
 * Size of so_sndbuf for UDP pipe transmission socket.  Note that this
 * buffer serves *all* UDP pipe clients, so it should be fairly large.
 */
#define NASD_OD_UDP_SNDBUF 200*1024

/* number of hash table buckets for the recent-nonce table */
#define NASD_DRIVE_NONCE_TABLE_SIZE           1024

#endif /* !_NASD__NASD_DRIVE_OPTIONS_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
