/*
 * nasd_edrfs_internal.h
 *
 * Internal structures and definitions for NASD EDRFS server.
 *
 * Author: Jim Zelenka, Mathew Monroe
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_EDRFS_INTERNAL_H_
#define _NASD__NASD_EDRFS_INTERNAL_H_

#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_types.h>

#define NASD_EDRFS_DRIVENAME_LEN 64
#define NASD_EDRFS_DRPATH_LEN    1024

#define NASD_EDRFS_ROOT_UID 0

/*******************************/

#define NASD_EDRFS_S_ISFIFO(m) (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFFIO)
#define NASD_EDRFS_S_ISCHR(m)  (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFCHR)
#define NASD_EDRFS_S_ISDIR(m)  (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFDIR)
#define NASD_EDRFS_S_ISBLK(m)  (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFBLK)
#define NASD_EDRFS_S_ISREG(m)  (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFREG)
#define NASD_EDRFS_S_ISLNK(m)  (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFLNK)
#define NASD_EDRFS_S_ISSOCK(m) (((m)&NASD_EDRFS_S_IFMT) == NASD_EDRFS_S_IFSOCK)

#endif /* !_NASD__NASD_EDRFS_INTERNAL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
