/*
 * nasd_itypes.h
 *
 * Common types for NASD prototype
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_ITYPES_H_
#define _NASD_ITYPES_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>

typedef struct nasd_mem_list_s     nasd_mem_list_t;
typedef struct nasd_freelist_s     nasd_freelist_t;
typedef struct nasd_threadgroup_s  nasd_threadgroup_t;

struct nasd_mem_list_s {
  void             *addr;	/* starting mem address */
  int               len;	/* element length in bytes */
  int               stride;	/* stride between elements in bytes */
  int               nelem;	/* num. of elements */
  nasd_mem_list_t  *next;
};

#endif /* _NASD_ITYPES_H_ */
