/*
 * nasd_marshall_tester.h
 *
 * Helper macros for marshalling testers
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_MARSHALL_TESTER_H_
#define _NASD__NASD_MARSHALL_TESTER_H_

#include <nasd/nasd_options.h>

/*
 * A certain whiner compiler generates warnings if the result of
 * sizeof is not cast to int when it is printed with %d. This
 * compiler, commonly known as gcc, shall remain nameless.
 */
#define NASD_MT_SizeOf(_x_) ((int)sizeof(_x_))

#define NASD_MT_CHECKBASIC2(_thing_,_thingafter_,_x_,_fmt_) { \
  if (_thing_._x_ != _thingafter_._x_) { \
    fail = 1; \
    printf("problem: %s.%s  %" _fmt_ " -> %" _fmt_ " (fmt \"%s\")\n", \
      NASD_STRING(_thing_), NASD_STRING(_x_), \
      _thing_._x_, _thingafter_._x_, \
      _fmt_); \
  } \
}

#define NASD_MT_CHECKBOOL2(_thing_,_thingafter_,_x_) { \
  NASD_MT_CHECKBASIC2(_thing_,_thingafter_,_x_,"02x") \
}

#define NASD_MT_CHECKBYTEARR2(_thing_,_thingafter_,_x_,_sz_) { \
  if (bcmp(_thing_._x_, _thingafter_._x_, _sz_)) { \
    printf("problem: %s.%s does not match\n", \
      NASD_STRING(_thing_), NASD_STRING(_x_)); \
  } \
}

#define NASD_MT_CHECKTIMESPEC2(_thing_,_thingafter_,_x_) { \
  NASD_MT_CHECKBASIC2(_thing_,_thingafter_,_x_.ts_sec,"d") \
  NASD_MT_CHECKBASIC2(_thing_,_thingafter_,_x_.ts_nsec,"d") \
}

#define NASD_MT_CHECKBASIC(_thing_,_x_,_fmt_) \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_,_fmt_)

#define NASD_MT_CHECKTIMESPEC(_thing_,_x_) \
  NASD_MT_CHECKTIMESPEC2(_thing_,NASD_CONCAT(_thing_,_after),_x_)

#define NASD_MT_CHECKCAPABILITY(_thing_,_x_) { \
  NASD_MT_CHECKBASIC(_thing_,_x_.ni,NASD_ID_FMT) \
  NASD_MT_CHECKBASIC(_thing_,_x_.expiration_seconds,"d") \
  NASD_MT_CHECKBASIC(_thing_,_x_.rights,"d") \
  NASD_MT_CHECKBASIC(_thing_,_x_.min_protection,"hu") \
  NASD_MT_CHECKBASIC(_thing_,_x_.AuditID,"hu") \
  NASD_MT_CHECKBASIC(_thing_,_x_.type,"hu") \
  NASD_MT_CHECKBASIC(_thing_,_x_.region_start,NASD_64s_FMT)  \
  NASD_MT_CHECKBASIC(_thing_,_x_.region_end,NASD_64s_FMT) \
  NASD_MT_CHECKBASIC(_thing_,_x_.partnum,"hd") \
}

#define NASD_MT_CHECKATTRIBUTE(_thing_,_x_) { \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.block_preallocation,NASD_64u_FMT) \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.blocks_used,NASD_64u_FMT) \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.block_size,"u") \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.av,"hd") \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.object_len,NASD_64u_FMT) \
  NASD_MT_CHECKTIMESPEC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.attr_modify_time) \
  NASD_MT_CHECKTIMESPEC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.object_modify_time) \
  NASD_MT_CHECKTIMESPEC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.object_create_time) \
  NASD_MT_CHECKTIMESPEC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.fs_attr_modify_time) \
  NASD_MT_CHECKTIMESPEC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.fs_object_modify_time) \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.layout_hint.lh_nid,NASD_ID_FMT) \
  NASD_MT_CHECKBYTEARR2(_thing_,NASD_CONCAT(_thing_,_after),_x_.fs_specific,NASD_FS_SPECIFIC_INFO_SIZE) \
}

#define NASD_MT_CHECKKEY(_thing_,_x_) \
  NASD_MT_CHECKBYTEARR2(_thing_,NASD_CONCAT(_thing_,_after),_x_,NASD_KEY_SZ)

#define NASD_MT_CHECKSTATUS(_thing_,_x_) \
  NASD_MT_CHECKBASIC(_thing_,_x_,"x")

#define NASD_MT_CHECKCLIENTADDR(_thing_,_x_) { \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.ip_addr,"u") \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.port,"u") \
}

#define NASD_MT_CHECKCOOKIE(_thing_,_x_) { \
  NASD_MT_CHECKCAPABILITY(_thing_,_x_.capability) \
  NASD_MT_CHECKBYTEARR2(_thing_,NASD_CONCAT(_thing_,_after),_x_.key,NASD_KEY_SZ) \
}

#define NASD_MT_CHECKEDRFSIDENT(_thing_,_x_) { \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.nasd_identifier,NASD_ID_FMT) \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.disk_identifier,"hd") \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.partnum,"hd") \
  NASD_MT_CHECKBASIC2(_thing_,NASD_CONCAT(_thing_,_after),_x_.pad1,"d") \
}

#define NASD_MT_CHECKEDRFSPOSTATTR(_thing_,_x_) { \
  NASD_MT_CHECKBOOL2(_thing_,NASD_CONCAT(_thing_,_after),_x_.valid) \
  NASD_MT_CHECKATTRIBUTE(_thing_,_x_.attribute) \
}

#endif /* !_NASD__NASD_MARSHALL_TESTER_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
