/*
 * nasd_mq.h
 *
 * Cheesy message-queue and shared memory interface to a NASD drive.
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_MQ_H_
#define _NASD_MQ_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_pdrive_client.h>

typedef struct nasd_msgq_msg_s		nasd_msgq_msg_t;
typedef struct nasd_msgq_rep_s		nasd_msgq_rep_t;
typedef struct nasd_msgq_buf_s		nasd_msgq_buf_t;

struct nasd_msgq_msg_s {
  unsigned int seqnum;
  int replyq;
  int shmid;
};

struct nasd_msgq_rep_s {
  nasd_rpc_status_t op_status;
};

#define NASD_MSGQ_KEY		0x4e415344 /* NASD */

/* largest possible message */
#define NASD_MSGQ_MSGLEN	(sizeof(nasd_msgq_buf_t)-sizeof(long))

/* message types */
#define NASD_MSGQ_BOGUS		0
#define NASD_MSGQ_NULL		1
#define NASD_MSGQ_SYNC		2
#define NASD_MSGQ_PCRPART	3
#define NASD_MSGQ_PCREATE	4
#define NASD_MSGQ_PGETATTR	5
#define NASD_MSGQ_PWRITE_SIMPLE	6
#define NASD_MSGQ_PREAD_SIMPLE	7
#define NASD_MSGQ_PREAD2_SIMPLE	8
#define NASD_MSGQ_PSETATTR	9
#define NASD_MSGQ_PFLUSH_OBJ	10
#define NASD_MSGQ_PEJECT_OBJ	11
#define NASD_MSGQ_PREMOVE	12
#define NASD_MSGQ_PINITIALIZE	13
#define NASD_MSGQ_PSTRT_IREAD	14
#define NASD_MSGQ_PSTOP_IREAD	15
#define NASD_MSGQ_KICK		16
#define NASD_MSGQ_PRSHUTDOWN	17
#define NASD_MSGQ_PTREAD_SIMPLE 18
#define NASD_MSGQ_PGETINFO      19
#define NASD_MSGQ_PREMOTE_ATTACH 20
#define NASD_MSGQ_PREMOTE_DETACH 21
#define NASD_MSGQ_PREMOTE_INVOKE 22

struct nasd_msgq_buf_s {
  long mtype;
  union {
    nasd_msgq_msg_t msg;
    nasd_msgq_rep_t rep;
  } gen;
  nasd_security_param_t sec_param;
  /* we use a marshalled capability and nonce here because the digest
     depends on the marshalled capability and timestamp, and this way
     we can use the same codepaths for message queues and "normal"
     across-the-network RPCs. */
  nasd_capability_otw_t capability_otw;
  int capability_valid;
  nasd_digest_nonce_otw_t digest_otw;
  union {
    nasd_p_getattr_dr_args_t getattr_args;
    nasd_p_getattr_dr_res_t getattr_res;
    nasd_p_setattr_dr_args_t setattr_args;
    nasd_p_setattr_dr_res_t setattr_res;
    nasd_p_create_dr_args_t create_args;
    nasd_p_create_dr_res_t create_res;
    nasd_p_part_creat_dr_args_t part_creat_args;
    nasd_p_flush_obj_dr_args_t flush_obj_args;
    nasd_p_remove_dr_args_t remove_args;
    nasd_p_initialize_dr_args_t initialize_args;
    nasd_p_change_key_dr_args_t change_key_args;
    nasd_p_eject_obj_dr_args_t eject_obj_args;
    nasd_p_strt_iread_dr_args_t strt_iread_args;
    nasd_p_strt_iread_dr_res_t strt_iread_res;
    nasd_p_stop_iread_dr_args_t stop_iread_args;
    nasd_p_rshutdown_dr_args_t rshutdown_args;
    nasd_p_rshutdown_dr_res_t rshutdown_res;
    nasd_p_getinfo_dr_res_t getinfo_res;
    nasd_p_smpl_op_dr_args_t smpl_op_args;
    nasd_p_thrtl_op_dr_args_t thrtl_op_args;
    nasd_p_fastread_dr_res_t fastread_res;
    nasd_p_fastwrite_dr_res_t fastwrite_res;
    nasd_p_remote_attach_dr_args_t remote_attach_args;
    nasd_p_remote_attach_dr_res_t remote_attach_res;
    nasd_p_remote_detach_dr_args_t remote_detach_args;
    nasd_p_remote_detach_dr_res_t remote_detach_res;
    nasd_p_smpl_op_dr_args_t remote_invoke_args;
    nasd_p_fastread_dr_res_t remote_invoke_res;
    nasd_status_t nasd_status;
  } op;
};

/* convenience macros */
#define MSG(_m_)		((_m_)->gen.msg)
#define REP(_m_)		((_m_)->gen.rep)
#define OP(_m_)			((_m_)->op)

nasd_status_t nasd_drive_startup_msgq(void);
nasd_status_t nasd_od_mq_stop_listeners(void);
nasd_status_t nasd_shutdown_msgq(void);
nasd_status_t nasd_od_mq_init(void);
void nasd_od_mq_shutdown(void *arg);

#endif /* !_NASD_MQ_H_ */
