/*
 * nasd_pdrive_client_msgq.h
 *
 * defs/structs used by MSGQ clients of NASD drives
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_PDRIVE_CLIENT_MSGQ_H_
#define _NASD__NASD_PDRIVE_CLIENT_MSGQ_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_pdrive.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_drive_types.h>
#include <nasd/nasd_pdrive_client.h>

typedef struct nasd_drive_handle_msgq_s {
  NASD_DECLARE_MUTEX(seqlock)   /* mutex for sequence number */
  int                replyq;    /* client msgq id */
  int                seqnum;	/* message sequence number */
  int                fd;
} nasd_drive_handle_msgq_t;

extern void nasd_cl_p_msgq_register(int counter_lock_held);

#endif /* !_NASD__NASD_PDRIVE_CLIENT_MSGQ_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
