/*
 * nasd_pipe_dce.h
 *
 * DCE byte pipe functions
 *
 * Authors: Jim Zelenka, Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_PIPE_DCE_H_
#define _NASD_PIPE_DCE_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_types.h>

#include <dce/dce_error.h>

nasd_status_t nasd_dcepipe_init(nasd_shutdown_list_t *shutdown_list);

nasd_status_t nasd_dcepipe_push(void *real_pipe,
                                void *buf,
                                nasd_len_t in_len);
nasd_status_t nasd_dcepipe_pull(void *real_pipe,
                                void *buf,
                                nasd_len_t in_len,
                                nasd_len_t *out_lenp);
nasd_status_t nasd_dcepipe_drainpull(void *real_pipe);
nasd_status_t nasd_dceprocpipe_push(void *real_pipe,
                                    void *buf,
                                    nasd_len_t in_len,
                                    nasd_byte_t *ign1,
                                    nasd_byte_t *ign2,
                                    int *ign3);


#endif /* !_NASD_PIPE_DCE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
