/*
 * nasd_udppipe.h
 *
 * Structures for UDP socket-based pipes.
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_UDPPIPE_H_
#define _NASD__NASD_UDPPIPE_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>

#ifndef KERNEL
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif /* !KERNEL */

#if defined(DEC_OSF) && defined(KERNEL)
#include <net/net_globals.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif /* DEC_OSF && KERNEL */

typedef struct nasd_udppipe_pipe_state_s    nasd_udppipe_pipe_state_t;

struct nasd_udppipe_pipe_state_s {
  int packet_complete;
  int nelem;
  nasd_mem_list_t *head;        /* head of buf list */
  nasd_mem_list_t *tail;        /* tail of buf list */
  int sock;
  struct sockaddr_in sockaddr;
  int sockaddr_len;
};

extern int nasd_od_udp_drive_socket;

nasd_status_t nasd_od_udp_init(void);
void nasd_od_udp_shutdown(void *ignored);
nasd_status_t nasd_od_udp_push(void *state, void *buf, nasd_len_t in_len,
                               nasd_byte_t *ign1, nasd_byte_t *ign2,
                               int *ign3);

#endif /* !_NASD__NASD_UDPPIPE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
