/*
 * merge_options.h
 * 
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _MERGE_OPTIONS_H_INCLUDED
#define _MERGE_OPTIONS_H_INCLUDED

#define RTSP_SERVER_PORT	3554
/* max. number of buffers to allocate */
#define DEFAULT_NBUFS		512
/* number of buffers to grow list by when extras are needed */
#define DEFAULT_BUFINC		32
/* default SO_RCVBUF size for DriveSocket, in KB */
#define DEFAULT_RCVBUF		1024
/* default bytes/ms to send PER CLIENT; 3Mbps = 375 bytes/ms */
#define DEFAULT_TARGET_BPMS	(3*1000/8)
/* default number of receiver threads to start */
#define NASD_MERGE_MAX_RXTHREADS_DEFAULT	2

/* number of previous data points to keep when calculating data rate */
#define HIST_SIZE		200
/* number of datagrams to wait for before deciding that a datagram is
   "lost" rather than just "misordered" */
/* may want to use higher value (300?) if splitting by frame */
/* set to 1 for "no waiting" */
#define TXTHRESH		50 

/* use extended-dance-remix throttling, or simple delay? */
#define AMP_TX_THROTTLE		0
/* just calculate rate based on current packet, or keep history of recent
   packets?  only works when AMP_TX_THROTTLE is on. */
#define TX_HISTORY		0

#define LOGFNBASE		"mergelog"

#define BUFLEN			1500

#endif /* _MERGE_OPTIONS_H_INCLUDED */
