/*
 * nasd_rpcgen_cpp.c
 *
 * read files through cpp
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "nasd_rpcgen.h"

void
nasd_cpp_flush(
  nasd_rpcgen_fhandle_t  *fhandle)
{
  while(fgets(fhandle->line_copy, NASD_RPCGEN_MAX_LINE_LEN, fhandle->f));
}

int
nasd_cpp_fopen(
  char                   *filename,
  nasd_rpcgen_fhandle_t  *fhandle)
{
  FILE *fil;
  int l;

  /* check for existance */
  fil = fopen(filename, "r");
  if (fil == NULL) {
    return(NASD_RPCGEN_BAD_KEY);
  }
  fclose(fil);

  l = strlen(cpp_cmd);

  strcat(cpp_cmd, filename);
  fil = popen(cpp_cmd, "r");

  cpp_cmd[l] = '\0';

  strcpy(fhandle->cur_filename, filename);
  fhandle->cur_line = 0;
  fhandle->f = fil;

  return(0);
}

char *
nasd_cpp_fgets(
  char                   *str,
  int                     len,
  nasd_rpcgen_fhandle_t  *fhandle)
{
  int count, line, n, l;
  char *ret, **words;

  n = 0;
  while (1) {
    ret = fgets(&str[n], len-n, fhandle->f);
    if (ret == NULL) {
      if (n == 0)
        return(NULL);
      str[n] = '\0';
      return(str);
    }
    fhandle->cur_line++;
    if ((str[n] == '\0') || ((str[n] == '\n') && (str[n+1] == '\0'))) {
      if (n)
        return(str);
      continue;
    }
    if (str[n] != '#') {
      l = strlen(&str[n]);
      if (str[n+l-1] == '\\') {
        n += l-1;
        continue;
      }
      if (str[n+l-2] == '\\') {
        n += l-2;
        continue;
      }
      if (n+l >= NASD_RPCGEN_MAX_LINE_LEN) {
        fprintf(stderr, "ERROR: line length exceeded at %s:%d\n",
          fhandle->cur_filename, fhandle->cur_line);
        fflush(stderr);
        exit(1);
      }
      bcopy(str, fhandle->line_copy, NASD_MIN(len, NASD_RPCGEN_MAX_LINE_LEN));
      return(ret);
    }
    words = lex_line(&str[n], &count, 0, fhandle);
    if (count != 0) {
      if (count < 3) {
        fprintf(stderr, "WARNING: suspicious line word count %d from cpp "
          "at %d in %s",
          count, fhandle->cur_line, fhandle->cur_filename);
      }
      else {
        if (sscanf(words[1], "%d", &line) != 1) {
          fprintf(stderr, "WARNING: suspicious 2nd operator \"%s\" from cpp "
            "at %d in %s", words[1], fhandle->cur_line, fhandle->cur_filename);
        }
        else {
          fhandle->cur_line = line-1;
        }
        if ((strlen(words[2]) >= 2) && (words[2][0] == '\"')
            && (words[2][strlen(words[2])-1] == '\"'))
        {
          /* strip out surrounding "" */
          strcpy(fhandle->cur_filename, &words[2][1]);
          fhandle->cur_filename[strlen(fhandle->cur_filename)-1] = '\0';
        }
        else {
          strcpy(fhandle->cur_filename, words[2]);
        }
      }
    }
  }
  /* NOTREACHED */
}

void
nasd_cpp_fclose(
  nasd_rpcgen_fhandle_t  *fhandle)
{
  pclose(fhandle->f);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
