/*
 * dce_err.c
 *
 * Translates a DCE error code to a string, if possible.
 *
 * Author: Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <stdio.h>
#include <dce/rpc.h>
#include <dce/dce_error.h>

void
usage(void)
{
  fprintf(stderr, "dce_err: usage: dce_err status\n");
}

int
main(int argc, char **argv)
{
  unsigned long status;
  dce_error_string_t err_str;
  int err_status;

  if(argc != 2) {
    usage();
    exit(1);
  }

  status = strtoul(argv[1], (char **) NULL, 0);
  if(status == 0) {
    fprintf(stderr, "dce_err: bad status value\n");
    usage();
    exit(1);
  }

  dce_error_inq_text(status, err_str, &err_status);
  if(err_status) {
    fprintf(stderr, "dce_err: error converting 0x%x: status=0x%x (%s)\n",
	    status, err_status, err_str);
    exit(1);
  }

  printf("status 0x%x is \"%s\"\n", status, err_str);
  exit(0);
}
