#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include "strerr.h"
#include "exit.h"
#include "generic-conf.h"

#define FATAL "rules-config: fatal: "

void usage()
{
  strerr_die1x(100,"rules-config: usage: rules-config dir maker");
}

char *dir;
char *maker;

main(int argc,char **argv)
{
  dir = argv[1];
  if (!dir) usage();
  if (dir[0] != '/') usage();
  maker = argv[2];
  if (!maker) usage();

  umask(022);
  if (chdir(dir) == -1)
    strerr_die4sys(111,FATAL,"unable to switch to ",dir,": ");

  makedir("rules");
  perm(02755);
  if (chdir("rules") == -1)
    strerr_die4sys(111,FATAL,"unable to switch to ",dir,"/rules: ");
  
  start("data");
  outs(":deny\n");
  finish();
  perm(0644);

  start("Makefile");
  outs("data.cdb: data\n\t"); outs(maker); outs(" data.cdb data.tmp <data\n");
  finish();
  perm(0644);

  _exit(0);
}
