/* $NetBSD: sleepto.c,v 1.3 2021/02/25 10:18:38 simonb Exp $ */

#include <err.h>
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>

#include "parsetime.h"

#define TIMEFMT	"%R"

static void	usage(void);

static volatile sig_atomic_t report_requested;
static void
report_request(int signo __unused)
{

	report_requested = 1;
}


int
main(int argc, char *argv[])
{
	struct timespec ntime;
	struct timeval tv;
	time_t when, now, original;
	int rv;

	if (argc < 2)
		usage();
		/* NOTREACHED */

	if (gettimeofday(&tv, NULL) == -1) {
		perror("gettimeofday");
		return EXIT_FAILURE;
	}

	when = parsetime(argc, argv);
	now = tv.tv_sec;

	printf("sleeping for %lld seconds...\n", (long long)when - now);
	ntime.tv_sec = when - now;
	if (ntime.tv_sec <= 0)
		return EXIT_SUCCESS;
	ntime.tv_nsec = 0;

	original = ntime.tv_sec;
	signal(SIGINFO, report_request);
	while ((rv = nanosleep(&ntime, &ntime)) != 0) {
		if (report_requested) {
			/* Reporting does not bother with nanoseconds. */
			warnx("about %lld second%s left out of the original %lld",
			    (long long)ntime.tv_sec,
			    ntime.tv_sec == 1 ? "" : "s",
			    (long long)original);
			report_requested = 0;
		} else
			break;
	}

	if (rv == -1)
 		err(EXIT_FAILURE, "nanosleep failed");

	return EXIT_SUCCESS;
}

static void
usage(void)
{
	(void)fprintf(stderr, "%s: usage: %s date\n",
	    getprogname(), getprogname());
	exit(EXIT_FAILURE);
}
