;;########################################################################
;; dashobj2.lsp
;; Contains code to define the datasheet prototype and its slot accessor methods,
;; Copyright (c) 1994-8 by Forrest W. Young
;;########################################################################

(defproto datasheet-proto '(data-object 
   data-matrix-strings variable-strings label-strings type-strings 
   editable edited nvar nobs nmat field-width field-height label-width 
   hot-cell hot-cell-ready hot-cell-string menu-states new-data discarded
   number-of-columns number-of-decimals newvar newobs newmat showing
   matrix-strings redraw-now help-menu-installed) nil graph-proto)

(defmeth datasheet-proto :isnew (&rest args) 
  (apply #'call-next-method args))

(defmeth datasheet-proto :data-object (&optional (obj-id nil set))
"Message args: (&optional obj-id)
 Sets or retrieves the object-id of the data object for this datasheet."
  (if set (setf (slot-value 'data-object) obj-id))
  (slot-value 'data-object))

(defmeth datasheet-proto :data-matrix-strings (&optional (matrix nil set))
"Message args: (&optional matrix)
 Sets or retrieves the data matrix with data as strings."
  (if set (setf (slot-value 'data-matrix-strings) matrix))
  (slot-value 'data-matrix-strings))

(defmeth datasheet-proto :variable-strings (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of variable strings."
  (if set (setf (slot-value 'variable-strings) list))
  (slot-value 'variable-strings))

(defmeth datasheet-proto :label-strings (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of label strings."
  (if set (setf (slot-value 'label-strings) list))
  (slot-value 'label-strings))

(defmeth datasheet-proto :type-strings (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of type strings."
  (if set (setf (slot-value 'type-strings) list))
  (slot-value 'type-strings))

(defmeth datasheet-proto :matrix-strings (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of matrix name strings."
  (if set (setf (slot-value 'matrix-strings) list))
  (slot-value 'matrix-strings))

(defmeth datasheet-proto :editable (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the datasheet is editable."
  (if set (setf (slot-value 'editable) logical))
  (slot-value 'editable))

(defmeth datasheet-proto :edited (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the datasheet is editable."
  (if set (setf (slot-value 'edited) logical))
  (slot-value 'edited))

(defmeth datasheet-proto :showing (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the datasheet window is showing."
  (if set (setf (slot-value 'showing) logical))
  (slot-value 'showing))

(defmeth datasheet-proto :nobs (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of observations in the datasheet."
  (if set (setf (slot-value 'nobs) number))
  (slot-value 'nobs))

(defmeth datasheet-proto :nvar (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of variables in the datasheet."
  (if set (setf (slot-value 'nvar) number))
  (slot-value 'nvar))

(defmeth datasheet-proto :newobs (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of observations in the datasheet."
  (if set (setf (slot-value 'newobs) number))
  (slot-value 'newobs))

(defmeth datasheet-proto :newvar (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of variables in the datasheet."
  (if set (setf (slot-value 'newvar) number))
  (slot-value 'newvar))

(defmeth datasheet-proto :newmat (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of variables in the datasheet."
  (if set (setf (slot-value 'newmat) number))
  (slot-value 'newmat))

(defmeth datasheet-proto :nmat (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of variables in the datasheet."
  (if set (setf (slot-value 'nmat) number))
  (slot-value 'nmat))

(defmeth datasheet-proto :field-width (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the field width of the datasheet."
  (if set (setf (slot-value 'field-width) number))
  (slot-value 'field-width))

(defmeth datasheet-proto :field-height (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the field height of the datasheet."
  (if set (setf (slot-value 'field-height) number))
  (slot-value 'field-height))

(defmeth datasheet-proto :label-width (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the label width of the datasheet."
  (if set (setf (slot-value 'label-width) number))
  (slot-value 'label-width))

(defmeth datasheet-proto :hot-cell (&optional (number-list nil set))
"Message args: (&optional number-list)
 Sets or retrieves a list of the row and column of the highlighted cell."
  (if set (setf (slot-value 'hot-cell) number-list))
  (slot-value 'hot-cell))

(defmeth datasheet-proto :hot-cell-ready (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the hot cell is ready for typing."
  (if set (setf (slot-value 'hot-cell-ready) logical))
  (slot-value 'hot-cell-ready))

(defmeth datasheet-proto :hot-cell-string (&optional (string nil set))
"Message args: (&optional string)
 Sets or retrieves the hot cell string."
  (if set (setf (slot-value 'hot-cell-string) string))
  (slot-value 'hot-cell-string))

(defmeth datasheet-proto :menu-states (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the hot cell is ready for typing."
  (if set (setf (slot-value 'menu-states) logical))
  (slot-value 'menu-states))

(defmeth datasheet-proto :new-data (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the hot cell is ready for typing."
  (if set (setf (slot-value 'new-data) logical))
  (slot-value 'new-data))

(defmeth datasheet-proto :number-of-decimals (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of decimals displayed in the datasheet."
  (if set (setf (slot-value 'number-of-decimals) number))
  (slot-value 'number-of-decimals))

(defmeth datasheet-proto :number-of-columns (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the number of columns displayed in the datasheet."
  (if set (setf (slot-value 'number-of-columns) number))
  (slot-value 'number-of-columns))

(defmeth datasheet-proto :redraw-now (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether redraw should be done (t) or delayed (nil)."
  (if set (setf (slot-value 'redraw-now) logical))
  (slot-value 'redraw-now))

(defmeth datasheet-proto :help-menu-installed (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether redraw should be done (t) or delayed (nil)."
  (if set (setf (slot-value 'help-menu-installed) logical))
  (slot-value 'help-menu-installed))

(defmeth datasheet-proto :discarded (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the changes were discarded."
  (if set (setf (slot-value 'discarded) logical))
  (slot-value 'discarded))

(defmeth datasheet-proto :set-window-size (fw fh lw nv no &optional (size-it? t))
  (let ((hor (+ 1 lw (* fw (+ 1 nv))))
        (ver (+ 1 (* fh (+ 3 no))))
        (desksize (send *vista* :desktop-sizes))
        )
    (send self :has-h-scroll (max hor (select (screen-size) 0)))
    (send self :has-v-scroll (max ver (select (screen-size) 1)))
    (when 
     size-it?
     (send self :size 
           (min (- (first desksize) (first (send self :location))
#+macintosh        10
                   border-thickness)
                (max (select (send self :size) 0) 
                     (+ 1 lw (* fw nv) (if (send self :editable) fw 0)
#+macintosh                  window-decoration-width -3
                             msdos-fiddle border-thickness)))
           (min (- (second desksize) (second (send self :location))
#+macintosh        10
                   (- (* 2 border-thickness)))
                (max (select (send self :size) 1) 
                     (+ (if (send self :editable) fh 0) 1 (* fh (+ 3 no)))))))
    ))

(defmeth datasheet-proto :enable-vista-menus&tools 
  (&optional (logical nil set)) 
  (when set 
        (cond 
          (logical ;enable appropriate menus and tools
             (cond
               ((send current-data :matrices)
                (send current-data :set-menu&tool-states "Matrix"))
               ((send current-data :ways)
                (send current-data :set-menu&tool-states "Table"))
               (t (send current-data :set-menu&tool-states "MV"))))
          (t       ;disable all menus and tools
             (send current-data :set-menu&tool-states "Disabled")
             (send self :menu-states 
                   (list (send *data-menu* :enabled) 
                         (send *trans-menu* :enabled)
                         (send *tools-menu* :enabled) 
                         (send *model-menu* :enabled))))))
  (send self :menu-states))


(defmeth datasheet-proto :create-data-matrix-strings ()
"Message args: nil
 Creates and stores the string version of the data matrix." 
  (let* ((mat (send (send self :data-object) :data-matrix))
         (numobs (send self :nobs))
         (numvar (send self :nvar))
         (nummat (send self :nmat))
         (ndec (send self :number-of-decimals))
         (ncol (send self :number-of-columns))
         (matst (make-array (list numobs numvar)))
         (k 0)) 
    (cond 
      ((= 0 (length (send current-data :matrices)))
       (dotimes (i numobs)
          (dotimes (j numvar)
             (setf (aref matst i j) (string-trim " " ;was string-right-trim
                   (format nil "~v,vf" ncol ndec (aref mat i j)))))))
      (t
       (send self :nobs (* numvar nummat))
       (dotimes (L nummat)
          (setf k 0)
          (dotimes (i numvar)
             (dotimes (j numvar)
                (setf (aref matst (+ i (* numvar L)) j) (string-trim " "
                      (format nil "~v,vf" ncol ndec (aref mat k L))))
                (setf k (+ k 1))))))) 
    (send self :data-matrix-strings matst))) 

(defmeth datasheet-proto :create-label-strings (data-object)
  (cond 
    ((send data-object :ways)
     (send self :label-strings (repeat (send data-object :labels) 
                                       (send data-object :cellfreqs))))
    ((send data-object :matrices)
     (send self :create-matrix-label-strings 0 (send self :nmat)))
    (t
     (send self :label-strings (copy-list (send data-object :labels))))))


(defmeth datasheet-proto :create-matrix-label-strings (nmats nmats-added)
  (dotimes (i nmats-added)
       (dotimes (j (send self :nvar))
         (send self :label-strings 
               (append (send self :label-strings) (list
                     (strcat (select (send self :matrix-strings) (+ nmats i)) 
                             ":"
                             (select (send self :variable-strings) j))))))))


(defmeth datasheet-proto :plot-help ()
  (plot-help-window (send self :title))
  (paste-plot-help (format nil "ABOUT THESE DATA:~2%"))
  (paste-plot-help (send (send self :data-object) :about))
  (if (send self :editable)
      (file-to-window (strcat *help-dir-name* "editable.hlp") 
                      (send self :title) *help-window* nil)
      (file-to-window (strcat *help-dir-name* "uneditab.hlp") 
                      (send self :title) *help-window* nil)))