;;##########################################################################
;; systmob2.lsp
;; Copyright (c) 1991-98 by Forrest W. Young
;; Continuation of code for ViSta system object.  Contains code for
;; redraw supervisor, preferences, configure, desktop constructor
;;##########################################################################

(defmeth VISTA-SYSTEM-OBJECT-PROTO :create-message-window 
  (&key (title "Text Window") (size '(300 75)) (location '(100 100)) 
        (show t))
  (let ((w (send display-window-proto2 :new 
                 :show show :size size :location location :title title)))
    ;(setf *message-window* w)
    ;(send w :show-window)
    (apply #'send w :frame-size size)
    (defmeth w :remove ()
      (send self :hide-window))
    w))

;;##########################################################################
;;REDRAW SUPERVISOR
;;##########################################################################

(defmeth vista-system-object-proto :ready-to-redraw (w)
  (let* ((ra (send self :redraw-active))
         (prl (send self :postponed-redraw-list))
         (returned-value t)
         )
    (when ra
          (send self :postponed-redraw-list
               (remove-duplicates 
                (combine
                 (add-element-to-list (send self :postponed-redraw-list) w)
                 *workmap*)))
          (setf returned-value nil))
    (when (and (equal w *workmap*) (send self :postponed-redraw-list))
          (send self :postponed-redraw-list 
                (remove-duplicates
                 (combine (send self :postponed-redraw-list) *workmap*))))
    (send self :redraw-active t)
    returned-value))
			
(defmeth vista-system-object-proto :finished-redraw (w)
  (let* ((prl (send self :postponed-redraw-list))
         (next-w nil)
         )
    (send self :redraw-active nil)
    (when prl
          (setf next-w (first prl))
          (send self :postponed-redraw-list (rest prl))
          (send next-w :redraw))))

;;##########################################################################
;;PREFERENCES
;;##########################################################################

(defmeth vista-system-object-proto :show-bug-list ()
  (let ((help-file-name 
#+macintosh(strcat *vista-dir-name* "help:"  "bug-list.hlp")
#+msdos    (strcat *vista-dir-name* "help\\" "bug-list.hlp")
#+X11      (strcat *vista-dir-name* "help/"  "bug-list.hlp")
         ))
   (file-to-window  help-file-name (strcat "Bug List: Version " version-number release-number " " release-date)
    (send self :help-window-object) t nil)))

(defun author-guidemaps()
  (author))

(defun startup-preferences ()
  (send *vista* :preferences))

(defmeth vista-system-object-proto :preferences ()
  (let* ((choices nil)
         (prefs nil)
         (file nil)
         (oldbreak *breakenable*))
    (when (send self :hide-workmap)    (setf choices (append choices '(0))))
    (when (send self :show-guidemap)   (setf choices (append choices '(1))))
    (when (send self :show-toolbar)    (setf choices (append choices '(2))))
    (when (send self :show-open-data)  (setf choices (append choices '(3))))
    (when (send self :show-long-menus) (setf choices (append choices '(4))))
    (when (send self :show-varobs)     (setf choices (append choices '(5))))
    (when (send self :show-load-vista) (setf choices (append choices '(6))))
    (when (send self :show-first-help) (setf choices (append choices '(7))))
    (when (send self :show-welcome)    (setf choices (append choices '(8))))
    (when (send self :show-listener)   (setf choices (append choices '(9))))
    (setf prefs (choose-subset-dialog "Select Startup Preferences:"
                   '("Hide WorkMap" "Show GuideMap" "Show Toolbar" 
                     "Show Open Data Dialog" "Show Long Menus"
                     "Show Var and Obs Lists" "Show Load Vista? Dialog"
                     "Show Initial Help" "Show Welcome Message"
#+macintosh          "Show Listener"
                           ) :initial choices))
    (when 
     (> (length prefs) 0)
     (setf file 
           (open (strcat *prefs-dir-name* "prefs.lsp") :direction :output))
    ; (setf file2
    ;       (open (strcat *prefs-dir-name* "prefload.lsp") :direction :output))
     (setq *breakenable* nil)
     (unwind-protect
      (cond ((member 0 (first prefs)) 
             (princ "(hide-workmap)"    file)
             (princ "(send *vista* :hide-workmap t)" file)
             (send self :hide-workmap t))
        (t (send self :hide-workmap nil)))
      (cond ((member 1 (first prefs)) 
             (princ "(send *vista* :show-guidemap t)" file)
             (send self :show-guidemap t))
        (t (send self :show-guidemap nil)))
      (cond ((member 2 (first prefs)) 
             (princ "(show-toolbar)"    file)
             (princ "(send *vista* :show-toolbar t)" file)
             (send self :show-toolbar t))
        (t (send self :show-toolbar nil)))
      (cond ((member 4 (first prefs)) 
             (princ "(make-long-menus)" file)
             (princ "(send *vista* :show-long-menus t)" file)
             (send self :show-long-menus t))
        (t (send self :show-long-menus nil)))
      (cond ((member 5 (first prefs)) 
             (princ "(send *vista* :show-varobs t)" file)
             (send self :show-varobs t))
        (t (princ "(send *vista* :show-varobs nil)" file)
           (send self :show-varobs nil)))
      (cond ((member 6 (first prefs)) 
            ; (princ "(setf ask-load-vista t)" file2)
            ; (princ "(setf memory-message t)" file2)
             (setf ask-load-vista t)
             (send self :show-load-vista t))
        (t 
        ; (princ "(setf ask-load-vista nil)" file2)
        ; (princ "(setf memory-message t)" file2)
         (setf ask-load-vista nil)
         (send self :show-load-vista nil)))
      (cond ((member 7 (first prefs))
             (princ "(send *vista* :show-first-help t)" file))
        (t
         (princ "(send *vista* :show-first-help nil)" file)))
      (cond ((member 8 (first prefs))
             (princ "(send *vista* :show-welcome t)" file))
        (t
         (princ "(send *vista* :show-welcome nil)" file)))
      (cond ((member 9 (first prefs)) 
             (princ "(send *vista* :show-listener t)" file)
             (send self :show-listener t))
        (t (send self :show-listener nil)))
      (cond ((member 3 (first prefs)) 
             (princ "(send *vista* :show-open-data t)" file)
             (send self :show-open-data t))
        (t (send self :show-open-data nil)))
      )
     (close file)
     (setq *breakenable* oldbreak)
     (send self :save-prefload)
     )
    )) 

(defun configure ()
  ;(send *vista* :configure t)
  (let* ((text1 (send text-item-proto :new "Configure ViSta"))
         (text2 (send text-item-proto :new "User has Privalege to:"))
         (dash1 (send text-item-proto :new " "))
         (togl1 (send toggle-item-proto 
                      :new "Configure ViSta"
                      :value *configure*))
         (togl2 (send toggle-item-proto 
                      :new "Change Startup Profile"
                      :value *change-profiles*))
         (togl3 (send toggle-item-proto 
                      :new "Author Guidemaps"
                      :value *author*))
         (text3 (send text-item-proto :new "See Dialog to Change:"))
         (dash2 (send text-item-proto :new " "))
         (togl4 (send toggle-item-proto :new "Startup Preferences"))
         (togl5 (send toggle-item-proto :new "Colors"))
         (togl6 (send toggle-item-proto :new "Desktop Size"))
 #+msdos (togl7 (send toggle-item-proto :new "Fonts and Directories"))
         (ok    (send modal-button-proto :new "OK"
                      :action #'(lambda ()
                        (list (send togl1 :value)
                              (send togl2 :value)
                              (send togl3 :value)
                              (send togl4 :value)
                              (send togl5 :value)
                              (send togl6 :value)
                      #+msdos (send togl7 :value)
                              ))))
         (cancel (send modal-button-proto :new "Cancel"))
         (dialog (send modal-dialog-proto :new
                       (list text1 
                             text2
                             (list dash1 (list togl1 togl2 togl3))
                             text3
                             (list dash2 (list togl4 togl5 togl6
                      #+msdos togl7
                                               ))
                             (list ok cancel))
                       :default-button ok))
         (result (send dialog :modal-dialog)))
    (when result
          (if (select result 0)
              (setf *configure* t)
              (setf *configure* nil))
          (if (select result 1)
              (setf *change-profiles* t)
              (setf *change-profiles* nil))
          (if (select result 2)
              (setf *author* t)
              (setf *author* nil))
          (if (select result 3) (startup-preferences))
          (if (select result 4) (change-colors))
          (if (select result 5) (resize-desktop))
          (save-desktop-settings)
          #+msdos(if (select result 6) (load "config"))
          ;(send *vista* :configure nil)
          )))

(defmeth vista-system-object-proto :save-prefload ()
  (let* ((oldbreak *breakenable*)
         (plfile (open (strcat *prefs-dir-name* "prefload.lsp") 
                       :direction :output)))
    (setq *breakenable* nil)
    (princ `(setf *change-profiles* ,*change-profiles* ) plfile)
    (princ `(setf *configure* ,*configure*  ) plfile)
    (princ `(setf *author* ,*author*) plfile)
    (princ `(setf *color-mode* ,*color-mode*) plfile)
    (princ `(setf ask-load-vista ,ask-load-vista) plfile)
    (princ `(setf *full-screen* ,*full-screen*) plfile)
    (setq *breakenable* oldbreak)
    (close plfile)))

(defun save-desktop-settings ()
  (let ((oldbreak *breakenable*)
        (file 
         (open (strcat *prefs-dir-name* "desktop.lsp") :direction :output)))
    (setq *breakenable* nil)
    (unwind-protect
     (format file "(send *vista* :desktop-sizes (list ~d ~d))" 
             (first (send *vista* :desktop-sizes)) 
             (second (send *vista* :desktop-sizes)))
     (princ "(send *vista* :save-desktop t)" file)
     (format file "(setf *color-mode* ~d)" *color-mode*)
     (format file "(send *vista* :background-color ~d)"
             (send *vista* :background-color))
     (format file "(send *workmap* :use-color ~d)"
             (send *workmap* :use-color))
     (format file "(setf *workmap-background* '~d)" *workmap-background*)
     (format file "(setf *toolbar-background* '~d)" *toolbar-background*)  
     (format file "(setf *data-icon-color* '~d)"    *data-icon-color*)
     (format file "(setf *model-icon-color* '~d)"   *model-icon-color*)
     (format file "(setf *tool-icon-color* '~d)"    *tool-icon-color*)
     (format file "(setf *guide-icon-color* '~d)"   *guide-icon-color*)
     (format file "(setf *button-on-color* '~d)"    *button-on-color*)
     (format file "(setf *button-off-color* '~d)"   *button-off-color*)
     (setq *breakenable* oldbreak)
     (close file)
     (send *vista* :save-prefload)
     )))
    
;;##########################################################################
;;REFRESH and RESIZE DESKTOP
;;##########################################################################

(defun refresh-desktop ()
  (send *vista* :refresh-desktop))

(defun show-desktop ()
  (send *vista* :refresh-desktop))

(defmeth vista-system-object-proto :refresh-desktop ()
  #+macintosh(when *guidemap* (when (send *guidemap* :gui) 
                                    (send *guidemap* :hide-window)))
  #+macintosh(send *workmap*     :hide-window)
  #+macintosh(send *obs-window*  :hide-window)
  #+macintosh(send *var-window*  :hide-window)
  #+macintosh(send *listener*    :hide-window)
  #+macintosh(send *help-window* :hide-window)
  #+X11(send self :make-desktop (send self :desktop-sizes) nil nil nil nil)
  #+macintosh(send self :make-desktop (send self :desktop-sizes) nil t nil nil)
  #+msdos(send self :make-desktop (send self :desktop-sizes) t t t nil)
  (send *obs-window*  :show-window)
  (send *var-window*  :show-window)
  #+macintosh(send *listener* :show-window)
  (send *help-window* :show-window)
   (when (not (send *workmap* :gui)) (send *workmap* :gui t))
  (send *workmap* :show-window)
  (when (send *vista* :guidemap) (send *guidemap* :gui t))
  )

(defun resize-desktop ()
  (send *vista* :resize-desktop))

(defmeth vista-system-object-proto :resize-desktop ()
  (let* ((result (send *vista* :resize-desktop-dialog))
         (height nil)
         (width nil)
         (new-size nil)
        )
    (when result
          (setf width (first result))
          (setf height (second result))
          (when (or (< (length width)  1)
                    (< (length height) 1))
                (fatal-message
                 "You must enter numbers for the width and height."))
          (when (or (equal " " (remove-duplicates width))
                    (equal " " (remove-duplicates height)))
                (fatal-message
                 "You must enter numbers for the width and height."))
          (setf height (read-from-string height))
          (setf width  (read-from-string width ))
          (when (or (not (numberp height))
                    (not (numberp width)))
                (fatal-message 
                 "You must enter numbers for the width and height."))
          (when (or (> width  (first screen-size))
                    (> height (second screen-size)))
                (fatal-message
                 "The width and/or height are too large."))
          (when (or (< height 300) (< width 360))
                (fatal-message
                 "The width and/or height  are too small."))
          (setf new-size (list width height))
          (send self :desktop-sizes new-size)
          (send self :refresh-desktop)
          (when *change-profiles* (save-desktop-settings))
          )))

(defmeth vista-system-object-proto :resize-desktop-dialog ()
  (let* ((sizes (send self :desktop-sizes))
         (title (send text-item-proto :new "Change Desktop Size:"))
         (resize (send text-item-proto :new 
                       "Desktop Size (current size shown):"))
         (width-text (send text-item-proto :new 
            (format nil "Width in Pixels (360 <= Width <= ~d)" 
                    (first screen-size)) ))
         (width (send edit-text-item-proto :new 
                      (format nil "~d" (first sizes)) :text-length 4))
         (height-text (send text-item-proto :new 
            (format nil "Height in Pixels (300 <= Height <= ~d)" 
                    (second screen-size))))
         (height (send edit-text-item-proto :new 
                      (format nil "~d" (second sizes)) :text-length 4))
         (ok (send modal-button-proto :new "OK"
                   :action #'(lambda ()
                               (list (send width :text)
                                     (send height :text)))))
         (cancel (send modal-button-proto :new "Cancel"))
         
#+win32  (bottom (send toggle-item-proto :new "Use MSWindows Toolbar Area"
                       :value (send *vista* :full-screen)
                       :action #'(lambda () 
                       (send *vista* :change-screen-size)
                       (send height-text :text 
                             (format nil 
                                     "Height in Pixels (300 <= Height <= ~d)"
                                     (second screen-size)))
                       (send height :text 
                             (format nil "~d" (min (second sizes)
                                                   (second screen-size)))))))
         (full-screen (send toggle-item-proto :new "Maximize"
                            :action #'(lambda ()
                                        (send *vista* :maximize))))
         (dialog (send modal-dialog-proto :new
                       (list title 
                             resize
                             (list width width-text)
                             (list height height-text)
#+win32                      (list bottom full-screen)
#-win32                      full-screen
                             (list ok cancel))
                       :default-button ok))
         )
    (defmeth vista-system-object-proto :maximize ()
      (send height :text (format nil "~d" (second screen-size)))
      (send width :text (format nil "~d" (first screen-size)))
      (send full-screen :value nil))
    (send dialog :modal-dialog)))

(defmeth vista-system-object-proto :change-screen-size ()
  (send self :full-screen (not (send self :full-screen)))
  (setf *full-screen* (send self :full-screen))
  (if (send self :full-screen)
      (setf screen-size (+ screen-size (list 0 40)))
      (setf screen-size (- screen-size (list 0 40))))
  )

(defmeth vista-system-object-proto :make-desktop
      (screen-size text-top winmac-x11 win-mac first-time)
  (if winmac-x11
  (if win-mac
      (send self :make-win-desktop screen-size text-top win-mac first-time)
      (send self :make-mac-desktop screen-size text-top win-mac))
  (send self :make-x11-desktop screen-size text-top))
  (send self :help-layout-sizeloc 
        (list (send *help-window* :size) (send *help-window* :location)))
  (send self :workmap-layout-sizeloc
        (list (send *workmap* :size) (send *workmap* :location)))
  )

(defmeth vista-system-object-proto :make-mac-desktop 
                    (screen-size text-top win-mac)
  (let* (
         (screen-w (first screen-size))
         (screen-h (second screen-size))
         (workmap-w 500)
         (workmap-h 280)
         (obs-var-win-w (min 100 (floor (/ screen-w 8))))
         (text-h (min 150 (floor (/ screen-h 4))));125
         (title-h (if win-mac 22 18))
         (scroll-w (if win-mac 32 0))
         (offset-x (if win-mac 4 10))
         (offset-x-r (if win-mac 8 10))
         (offset-y (if win-mac 16 20))
         (offset-y-b (if win-mac 10 10))
         (gap (if win-mac 8 4))
         (workmap-x offset-x)
         (workmap-y (if text-top (+ offset-y text-h gap title-h) offset-y))
         (obs-var-win-h workmap-h)
         (obs-win-x (+ workmap-x workmap-w gap))
         (obs-win-y workmap-y)
         (var-win-x (+ obs-win-x obs-var-win-w gap scroll-w))
         (var-win-y workmap-y)
         (text-w (floor (/ (- screen-w offset-x gap offset-x-r) 2))) 
         (text1-x workmap-x)
         (text2-x (+ offset-x text-w gap))
         (text-y (if text-top (+ offset-y gap border-thickness) 
                              (+ offset-y workmap-h gap title-h)))
         (unused-x (- screen-w 
                      (+ offset-x workmap-w (* 2 scroll-w) (- border-thickness)
                         (* 2 (+ gap obs-var-win-w)) offset-x-r)))
         (unused-y (- screen-h 
                      (+ offset-y workmap-h gap text-h offset-y-b)))
         (guide-win-w (first  (send *vista* :guide-window-size)))
         (guide-win-h (second (send *vista* :guide-window-size)))
         (guide-win-x 0)
         (guide-win-y 0)
         )
    (when (< unused-x 0)
          (setf var-win-x obs-win-x)
          (setf obs-var-win-w (min 100 (floor (/ screen-w 5))))
          (setf unused-x 
                (- screen-w 
                   (+ offset-x workmap-w gap obs-var-win-w offset-x-r)))
          (when nil (setf unused-x (+ 3 (- unused-x title-h)))))
    (setf workmap-w (+ workmap-w unused-x))
    (setf obs-win-x (+ obs-win-x unused-x))
    (setf var-win-x (+ var-win-x unused-x))
    (setf workmap-h (+ workmap-h unused-y))
    (cond
      ((= var-win-x obs-win-x)
       (setf obs-var-win-h (floor (/ (- workmap-h title-h gap) 2)))
       (setf var-win-y (+ workmap-y (floor (/ (+ workmap-h title-h gap) 2)))))
      (t
       (setf obs-var-win-h (+ obs-var-win-h unused-y))))
    (setf text-y (if text-top text-y (+ text-y unused-y)))
    (setf text-h (if text-top (- text-h (/ gap 2)) (- text-h title-h)))
    (if win-mac (setf text-h (- text-h (* 2 border-thickness))))
    (setf text-w (if text-top (+ text-w (/ gap 2)) text-w))
    (send *workmap*     :size workmap-w workmap-h )
    (send *workmap*     :location workmap-x workmap-y)
    (send *obs-window*  :size obs-var-win-w obs-var-win-h)
    (send *obs-window*  :location obs-win-x obs-win-y)
    (send *var-window*  :size obs-var-win-w obs-var-win-h)
    (send *var-window*  :location var-win-x var-win-y)
    (when (not win-mac) 
       (send *listener* :size text-w text-h)
       (send *listener* :location text1-x text-y))
    (send *help-window* :size text-w text-h)
    (send *help-window* :location text2-x text-y)
    (setf guide-win-x (- (+ var-win-x obs-var-win-w) guide-win-w))
    (setf guide-win-y (- (+ var-win-y obs-var-win-h) guide-win-h))
    (if win-mac 
        (send *vista* :guide-window-location
              (list (+ scroll-w guide-win-x) guide-win-y))
        (send *vista* :guide-window-location 
              (list guide-win-x guide-win-y)))
    (when *guidemap*
          (send *guidemap* :size guide-win-w guide-win-h)
          (apply #'send *guidemap* :location 
                 (send *vista* :guide-window-location))
          )))

(defmeth vista-system-object-proto :make-win-desktop 
                    (screen-size text-top win-mac first-time)
  (let* (
         (screen-w (first screen-size))
         (screen-h (+ 12 (second screen-size)))
         (workmap-w 500)
         (workmap-h 280)
         (obs-var-win-w (if win-mac 150 100));150 100
         (text-h (min 150 (floor (/ screen-h 4))))
         (workmap-x 0)
         (workmap-y (if text-top text-h 0))
         (obs-var-win-h workmap-h)
         (obs-win-x (+ workmap-x workmap-w))
         (obs-win-y workmap-y)
         (var-win-x (+ obs-win-x obs-var-win-w))
         (var-win-y workmap-y)
         (text-w (floor (/ screen-w 2)))
         (text1-x workmap-x)
         (text2-x text-w) ;(+ offset-x text-w gap)
         (text-y (if text-top 0 workmap-h))
         (unused-x (- screen-w workmap-w (* 2 obs-var-win-w)))
         (unused-y (- screen-h workmap-h text-h))
         (guide-win-w (first  (send *vista* :guide-window-size)))
         (guide-win-h (second (send *vista* :guide-window-size)))
         (guide-win-x 0)
         (guide-win-y 0)
         )
    (when (< unused-x 0)
          (setf var-win-x obs-win-x)
          (setf unused-x (- screen-w workmap-w obs-var-win-w )))
    (setf workmap-w (+ workmap-w unused-x))
    (setf obs-win-x (+ obs-win-x unused-x))
    (setf var-win-x (+ var-win-x unused-x))
    (setf workmap-h (+ workmap-h unused-y))
    (cond
      ((= var-win-x obs-win-x)
       (setf obs-var-win-h (floor (/ workmap-h 2)))
       (setf var-win-y (+ workmap-y obs-var-win-h)))
      (t
       (setf obs-var-win-h (+ obs-var-win-h unused-y))))
    (setf text-y (if text-top text-y (+ text-y unused-y)))
    (send *workmap*     :frame-size workmap-w workmap-h )
    (send *workmap*     :frame-location workmap-x workmap-y)
    (send *obs-window*  :frame-size obs-var-win-w obs-var-win-h)
    (send *obs-window*  :frame-location obs-win-x obs-win-y)
    (send *var-window*  :frame-size obs-var-win-w obs-var-win-h)
    (send *var-window*  :frame-location var-win-x var-win-y)
    (when (not win-mac)
       (send *listener* :frame-size text-w text-h)
       (send *listener* :frame-location text1-x text-y))
    (cond
      (first-time
       (send *help-window* :location text2-x text-y)
       (send *help-window* :size text-w text-h))
      (t
       (send *help-window* :frame-location text2-x text-y)
       (send *help-window* :frame-size text-w text-h)))
    (setf guide-win-x (- (+ var-win-x obs-var-win-w) guide-win-w))
    (setf guide-win-y (- (+ var-win-y obs-var-win-h) guide-win-h))
    (send *vista* :guide-window-location (list guide-win-x guide-win-y))
    (when *guidemap*
          (send *guidemap* :size guide-win-w guide-win-h)
          (apply #'send *guidemap* :location 
                 (send *vista* :guide-window-location))
          )))

(defmeth vista-system-object-proto :make-x11-desktop 
                    (screen-size text-top)
  (let* (
         (screen-w (first screen-size))
         (screen-h (second screen-size))
         (workmap-w 500)
         (workmap-h 280)
         (obs-var-win-w (min 100 (floor (/ screen-w 8))))
         (text-h (min 150 (floor (/ screen-h 4))));125
         (title-h (if win-mac 22 18))
         (scroll-w (if win-mac 32 0))
         (offset-x (if win-mac 4 10))
         (offset-x-r (if win-mac 8 10))
         (offset-y (if win-mac 16 20))
         (offset-y-b (if win-mac 10 10))
         (gap (if win-mac 8 4))
         (workmap-x offset-x)
         (workmap-y (if text-top (+ offset-y text-h gap title-h) offset-y))
         (obs-var-win-h workmap-h)
         (obs-win-x (+ workmap-x workmap-w gap))
         (obs-win-y workmap-y)
         (var-win-x (+ obs-win-x obs-var-win-w gap scroll-w))
         (var-win-y workmap-y)
         (text-w (floor (/ (- screen-w offset-x gap offset-x-r) 2))) 
         (text1-x workmap-x)
         (text2-x (+ offset-x text-w gap))
         (text-y (if text-top (+ offset-y gap border-thickness) 
                              (+ offset-y workmap-h gap title-h)))
         (unused-x (- screen-w 
                      (+ offset-x workmap-w (* 2 scroll-w) (- border-thickness)
                         (* 2 (+ gap obs-var-win-w)) offset-x-r)))
         (unused-y (- screen-h 
                      (+ offset-y workmap-h gap text-h offset-y-b)))
         (guide-win-w (first  (send *vista* :guide-window-size)))
         (guide-win-h (second (send *vista* :guide-window-size)))
         (guide-win-x 0)
         (guide-win-y 0)
         )
    (when (< unused-x 0)
          (setf var-win-x obs-win-x)
          (setf obs-var-win-w (min 100 (floor (/ screen-w 5))))
          (setf unused-x 
                (- screen-w 
                   (+ offset-x workmap-w gap obs-var-win-w offset-x-r)))
          (when nil (setf unused-x (+ 3 (- unused-x title-h)))))
    (setf workmap-w (+ workmap-w unused-x))
    (setf obs-win-x (+ obs-win-x unused-x))
    (setf var-win-x (+ var-win-x unused-x))
    (setf workmap-h (+ workmap-h unused-y))
    (cond
      ((= var-win-x obs-win-x)
       (setf obs-var-win-h (floor (/ (- workmap-h title-h gap) 2)))
       (setf var-win-y (+ workmap-y (floor (/ (+ workmap-h title-h gap) 2)))))
      (t
       (setf obs-var-win-h (+ obs-var-win-h unused-y))))
    (setf text-y (if text-top text-y (+ text-y unused-y)))
    (setf text-h (if text-top (- text-h (/ gap 2)) (- text-h title-h)))
    (if win-mac (setf text-h (- text-h (* 2 border-thickness))))
    (setf text-w (if text-top (+ text-w (/ gap 2)) text-w))
    (send *workmap*     :size workmap-w workmap-h )
    (send *workmap*     :location workmap-x workmap-y)
    (send *obs-window*  :size obs-var-win-w obs-var-win-h)
    (send *obs-window*  :location obs-win-x obs-win-y)
    (send *var-window*  :size obs-var-win-w obs-var-win-h)
    (send *var-window*  :location var-win-x var-win-y)
    ;(when (not win-mac) 
    ;   (send *listener* :size text-w text-h)
    ;   (send *listener* :location text1-x text-y))
    (send *help-window* :size text-w text-h)
    (send *help-window* :location text2-x text-y)
    (setf guide-win-x (- (+ var-win-x obs-var-win-w) guide-win-w))
    (setf guide-win-y (- (+ var-win-y obs-var-win-h) guide-win-h))
    (if win-mac
        (send *vista* :guide-window-location
              (list (+ scroll-w guide-win-x) guide-win-y))
        (send *vista* :guide-window-location 
              (list guide-win-x guide-win-y)))
    (when *guidemap*
          (send *guidemap* :size guide-win-w guide-win-h)
          (apply #'send *guidemap* :location 
                 (send *vista* :guide-window-location))
          )))

