;;########################################################################
;; vismenu1.lsp
;; contains code to define ViSta data, transform, analyze and model menus
;; Copyright (c) 1991-98 by Forrest W. Young
;; X11 changes by Anthony J. Rossini
;;########################################################################


#+X11(defun about-xlisp-stat ()
    (message-dialog (format nil "XLISP-PLUS version 2.1g~%~
Portions Copyright (c) 1988, by David Betz~%~
Modified by Thomas Almy and others.~%~%~
XLISP-STAT Version 2.1 Release ~d.~d  (Beta).~%~
Statistical additions to XLISP by Luke Tierney~%~
Copyright 1990 (c) by Luke Tierney"
xls-major-release xls-minor-release)))

(defproto expert-menu-item-proto () () menu-item-proto)

;fwy4.28 7/16/97 modified so that menu items can show help
(defmeth expert-menu-item-proto :do-action ()
  (when (author) (copyitem (send self :title)))
  (when (send *vista* :show-help) (send *workmap* :show-help self))
  (when (not (send *vista* :show-help))
        (when (send self :action) (funcall (send self :action)))))

;; X11 doesn't have a file-menu? AJR
#+X11 (defvar *file-menu* (send menu-proto :new "File"))
#+X11 (send   *file-menu* :enabled nil)

(defvar *data-menu* (send menu-proto :new "Data"))
(send   *data-menu* :enabled nil)

(setf guide-data-menu-item
      (send expert-menu-item-proto :new "Guidance"
            :action #'(lambda () (guidance "data"))))

(setf about-data-menu-item
      (send expert-menu-item-proto :new "About These Data"
            :action 'about-these-data))

(setf load-data-menu-item
      (send expert-menu-item-proto :new "Load Data ..." :key #\D
            :action 'load-data))

(setf save-data-menu-item
      (send expert-menu-item-proto :new "Save Data ..." :enabled nil
            :action 'save-data))

(setf delete-data-menu-item
      (send expert-menu-item-proto :new "Delete Data" :enabled nil ;fwy 428
            :action 'delete-data))

(setf create-dob-data-menu-item
      (send expert-menu-item-proto :new "Create Data ..." :enabled nil
            :action #'(lambda () (send *current-data* :create-data))))
;:action 'create-data

(setf show-datasheet-menu-item
      (send expert-menu-item-proto :new "Edit Data ..." :enabled nil
            :action 'edit-data))

(setf show-vars-menu-item
      (send expert-menu-item-proto :new "List Variables" :enabled nil
            :action 'list-variables))

(setf show-obs-menu-item
      (send expert-menu-item-proto :new "List Observations" :enabled nil
            :action 'list-observations))

(setf merge-vars-menu-item
      (send expert-menu-item-proto :new "Merge Variables" :enabled nil
            :action 'merge-variables))

(setf merge-obs-menu-item
      (send expert-menu-item-proto :new "Merge Observations" :enabled nil
            :action 'merge-observations))

(setf merge-mats-menu-item
      (send expert-menu-item-proto :new "Merge Matrices" :enabled nil
            :action 'merge-matrices))

(setf visualize-data-menu-item
      (send expert-menu-item-proto :new "Visualize Data ..." :enabled nil
             :action #'(lambda () (visualize-data :dialog t))))

(setf report-data-menu-item
      (send expert-menu-item-proto :new "Report Data" :enabled nil :key #\R
            :action #'(lambda () (report-data))))

(setf browse-data-menu-item
      (send expert-menu-item-proto :new "Browse Data" :enabled nil :key #\B
            :action #'(lambda () (browse-data))))

(setf summarize-data-menu-item
      (send expert-menu-item-proto :new "Summarize Data ..." :enabled nil
            :key #\Y :action #'(lambda () (summarize-data :dialog t))))

;; AJR -- moved here, since we need it for X11.
(setf open-data-file-menu-item
      (send menu-item-proto
	    :new "Open Data"
	    :key #\O
            :action 'open-data))

(send *data-menu* :append-items
      guide-data-menu-item
      about-data-menu-item
      (send dash-item-proto :new)
      visualize-data-menu-item
      summarize-data-menu-item
      (send dash-item-proto :new)
     ;delete-data-menu-item       not yet implemented
      create-dob-data-menu-item
      browse-data-menu-item
      show-datasheet-menu-item
      report-data-menu-item
      (send dash-item-proto :new)
      show-obs-menu-item
      show-vars-menu-item
      (send dash-item-proto :new)
      merge-vars-menu-item
      merge-obs-menu-item
      merge-mats-menu-item
      )

(defvar *trans-menu* (send menu-proto :new "Transform"))
(send   *trans-menu* :enabled nil)

(setf trnsps-trans-menu-item
      (send expert-menu-item-proto :new "Transpose Data" :enabled t
            :action 'transpose-data))

(setf norm-trans-menu-item
      (send expert-menu-item-proto :new "Normalize Data ... " :enabled t
            :action #'(lambda () (normalize-data :dialog t))))

(setf orth-trans-menu-item
      (send expert-menu-item-proto :new "Orthogonalize Data" :enabled t
            :action 'orthogonalize-data))

(setf corr-trans-menu-item
      (send expert-menu-item-proto :new "Correlations" :enabled t
            :action 'correlations))

(setf covar-trans-menu-item
      (send expert-menu-item-proto :new "Covariances" :enabled t
            :action 'covariances))

(setf dist-trans-menu-item
      (send expert-menu-item-proto :new "Distances" :enabled t
            :action 'distances))

(setf sort-trans-menu-item
      (send expert-menu-item-proto :new "Sort-Permute ... " :enabled t
            :action #'(lambda () (sort-permute :dialog t))))

(setf rank-trans-menu-item
      (send expert-menu-item-proto :new "Ranks" :enabled t
            :action #'(lambda () (ranks :dialog t))))

(setf nscores-trans-menu-item
      (send expert-menu-item-proto :new "Normal Scores" :enabled t
            :action 'normal-scores))

(setf absval-trans-menu-item
      (send expert-menu-item-proto :new "Absolute Value" :enabled t
            :action 'absolute-value))

(setf exponent-trans-menu-item
      (send expert-menu-item-proto :new "Exponential ..." :enabled t
            :action #'(lambda () (exponential :dialog t))))

(setf logarithm-trans-menu-item
      (send expert-menu-item-proto :new "Logarithm ..." :enabled t
            :action #'(lambda () (logarithm :dialog t))))

(setf round-trans-menu-item
      (send expert-menu-item-proto :new "Rounding ... " :enabled t
            :action #'(lambda () (rounding :dialog t))))

(setf trig-trans-menu-item
      (send expert-menu-item-proto :new "Trigonometric ... " :enabled t
            :action #'(lambda () (trigonometric :dialog t))))

(setf recip-trans-menu-item
      (send expert-menu-item-proto :new "Reciprocal" :enabled t
            :action 'reciprocal))

(setf user-trans-menu-item
      (send expert-menu-item-proto :new "User Defined ... " :enabled t
            :action #'(lambda () (user-defined :dialog t))))

(send *trans-menu* :append-items
      sort-trans-menu-item
      rank-trans-menu-item
      (send dash-item-proto :new)
      nscores-trans-menu-item
      absval-trans-menu-item
      round-trans-menu-item
      recip-trans-menu-item
      (send dash-item-proto :new)
      exponent-trans-menu-item
      logarithm-trans-menu-item
      trig-trans-menu-item
      (send dash-item-proto :new)
      corr-trans-menu-item
      covar-trans-menu-item
      dist-trans-menu-item
      (send dash-item-proto :new)
      trnsps-trans-menu-item
      norm-trans-menu-item
      orth-trans-menu-item
      (send dash-item-proto :new)
      user-trans-menu-item
)

(defvar *model-menu* (send menu-proto :new "Model"))
(send   *model-menu* :enabled nil)

(setf guide-model-menu-item
      (send expert-menu-item-proto :new "Guidance" :enabled nil
            :action #'(lambda () (guidance "model"))))

(setf load-model-menu-item
      (send expert-menu-item-proto :new "Load Model ..." :key #\M
            :action 'load-model))

(setf save-model-menu-item
      (send expert-menu-item-proto :new "Save Model ..." :enabled nil
            :action 'save-model))

(setf delete-model-menu-item
      (send expert-menu-item-proto :new "Delete Model"  :enabled nil
            :action 'delete-model))

(defun delete-model () (error-message "Not yet implemented.") t)

(setf visualize-model-menu-item
      (send expert-menu-item-proto :new "Visualize Model" :enabled nil
            :action #'(lambda () (visualize-model))))

(setf report-model-menu-item
      (send expert-menu-item-proto :new "Report Model ... " :enabled nil
            :action #'(lambda () (send current-model :report :dialog t))))

(setf interpret-model-menu-item
      (send expert-menu-item-proto :new "Interpret Model" :enabled nil
            :key #\I :action #'(lambda () (interpret-model))))

(setf create-dataobjects-model-menu-item
      (send expert-menu-item-proto :new "Create Data ..." :enabled nil
            :action #'(lambda () (send current-model :create-data :dialog t))))

(send *model-menu* :append-items
      guide-model-menu-item
      (send dash-item-proto :new)
      visualize-model-menu-item
      report-model-menu-item
  ;   interpret-model-menu-item    to be implemented later
      (send dash-item-proto :new)
     ;delete-model-menu-item       to be implemented later
      create-dataobjects-model-menu-item
      )

(defvar *tools-menu* (send menu-proto :new "Analyze"))
(defvar *analyze-menu* *tools-menu*);fwy4.25
(send   *tools-menu* :enabled nil)

(setf anova-model-menu-item
      (send expert-menu-item-proto :new "Analysis of Variance ..." 
            :enabled nil
            :action  #'(lambda () (analysis-of-variance :dialog t))))

(setf corresp-model-menu-item
      (send expert-menu-item-proto :new "Correspondence Analysis ..."
      :action #'(lambda () (correspondence-analysis :dialog t))
            :enabled nil))

(setf mds-model-menu-item
      (send expert-menu-item-proto :new "Multidimensional Scaling ..."
      :action #'(lambda () (multidimensional-scaling :dialog t))
            :enabled nil))

(setf mulreg-model-menu-item
      (send expert-menu-item-proto :new "Multivariate Regression ..."
      :action #'(lambda () (multivariate-regression :dialog t))
            :enabled nil))

(setf nonpar-model-menu-item
      (send expert-menu-item-proto :new "Nonparametric Analysis ..." 
            :enabled nil
            :action #'(lambda () (nonparametric-analysis :dialog t))))

(setf prin-model-menu-item
      (send expert-menu-item-proto :new "Principal Components ..." 
            :enabled nil
            :action #'(lambda () (principal-components :dialog t))))

(setf reg-model-menu-item
      (send expert-menu-item-proto :new "Regression Analysis ..." 
            :enabled nil
            :action #'(lambda () (regression-analysis :dialog t))))

(setf univar-model-menu-item
      (send expert-menu-item-proto :new "Univariate Analysis ..." 
            :enabled nil
            :action #'(lambda () (univariate-analysis :dialog t))))

(send *tools-menu* :append-items
      anova-model-menu-item
      corresp-model-menu-item
      mds-model-menu-item
      mulreg-model-menu-item
   ;  nonpar-model-menu-item
      prin-model-menu-item
      reg-model-menu-item
      univar-model-menu-item)

;; AJR :NOT NEED
;; #+X11(make-fake-menu-bar)
;; #+X11(send *fake-menu-bar* :title "ViSta Menubar")

(defvar *popup-desktop-menu* (send menu-proto :new "Desktop"))

(setf show-guidemap-popup-item
      (send menu-item-proto :new "Show GuideMap"
            :action 'show-guidemap))

(setf show-toolbar-popup-item
      (send menu-item-proto :new "Show ToolBar"
            :action 'show-toolbar))

(setf hide-toolbar-popup-item
      (send menu-item-proto :new "Hide ToolBar"
            :action 'hide-toolbar))

(setf load-data-popup-menu-item
      (send menu-item-proto :new "Load Data" :key #\D
            :action 'load-data))

(setf new-data-popup-menu-item
      (send menu-item-proto :new "New Data" :key #\N
            :action 'new-data))

(setf simulate-data-popup-menu-item
      (send menu-item-proto :new "Simulate Data"
            :action 'simulate-data))

(setf import-data-popup-menu-item
      (send menu-item-proto :new "Import Data"
            :action 'import-data))

(setf open-data-popup-menu-item
      (send menu-item-proto :new "Open Data" :key #\O
           :action 'open-data))

(setf new-edit-popup-menu-item
      (send menu-item-proto :new "New Edit" 
            :action #'(lambda () (send edit-window-proto :new))))

(setf open-edit-popup-menu-item
      (send menu-item-proto :new "Open Edit"
            :action #'(lambda ()
                        (send edit-window-proto :new :bind-to-file t))))

(setf load-model-popup-menu-item
      (send menu-item-proto :new "Load Model" :key #\M
            :action 'load-model))

;(setf load-program-popup-menu-item
;      (send menu-item-proto :new "Load Edit" :key #\L
;            :action #'(lambda ()
;             (let ((f (open-file-dialog-clean t)))
;               (when f (load f) (format t "; finished loading ~s~%" f))
;               ))))

(setf load-program-popup-menu-item
      (send menu-item-proto :new "Load Edit" :key #\L
            :action #'(lambda () (clean-open-file-dialog t))))

(setf preferences-popup-menu-item
      (send menu-item-proto :new "Preferences ... "
            :action #'(lambda () (send *vista* :preferences))))

(setf show-buglist-popup-menu-item
      (send menu-item-proto :new "Show Bug List"
            :action 'show-bug-list))

(send *popup-desktop-menu* :append-items
             new-data-popup-menu-item
             open-data-popup-menu-item
             load-data-popup-menu-item
             load-model-popup-menu-item
             (send dash-item-proto :new)
             simulate-data-popup-menu-item
             import-data-popup-menu-item
#+macintosh  (send dash-item-proto :new)
#+macintosh  new-edit-popup-menu-item
#+macintosh  open-edit-popup-menu-item
             load-program-popup-menu-item
             (send dash-item-proto :new)
             show-guidemap-popup-item
#+macintosh  (send menu-item-proto :new "Show Listener"
                        :action #'(lambda () (send *listener* :show-window)))
             preferences-popup-menu-item
             show-buglist-popup-menu-item
             show-toolbar-popup-item)

(defvar *popup-data-menu* (send menu-proto :new "Data"))

(setf guide-data-popup-menu-item
      (send menu-item-proto :new "Guidance"
            :action #'(lambda () (guidance "data"))))

(setf about-data-popup-item
      (send expert-menu-item-proto :new "About These Data"
            :action 'about-these-data))

(setf save-data-popup-menu-item
      (send menu-item-proto :new "Save Data"
            :action 'save-data))

(setf delete-data-popup-menu-item
      (send menu-item-proto :new "Delete Data"
            :action 'delete-data :enabled nil))

(setf transform-data-popup-menu-item
      (send menu-item-proto :new "Transform Data ..."
            :action 'transform-data))

(setf analyze-data-popup-menu-item
      (send menu-item-proto :new "Analyze Data ..."
            :action 'analyze-data))

(setf create-dob-data-popup-menu-item
      (send menu-item-proto :new "Create Data"
            :action #'(lambda () (send *current-data* :create-data))))
;:action 'create-data

(setf show-datasheet-popup-menu-item
      (send menu-item-proto :new "Edit Data"
            :action 'edit-data))

(setf show-vars-popup-menu-item
      (send menu-item-proto :new "List Variables"
            :action 'list-variables))

(setf show-obs-popup-menu-item
      (send menu-item-proto :new "List Observations"
            :action 'list-observations))

(setf visualize-data-popup-menu-item
      (send menu-item-proto :new "Visualize Data ..."
            :action #'(lambda () (visualize-data :dialog t))))

(setf report-data-popup-menu-item
      (send menu-item-proto :new "Report Data"
            :action #'(lambda () (report-data))))

(setf browse-data-popup-menu-item
      (send menu-item-proto :new "Browse Data"
            :action #'(lambda () (browse-data))))

(setf summarize-data-popup-menu-item
      (send menu-item-proto :new "Summarize Data ..."
            :action #'(lambda () (summarize-data :dialog t))))

(setf merge-vars-popup-menu-item
      (send menu-item-proto :new "Merge Variables" :enabled nil
            :action 'merge-variables))

(setf merge-obs-popup-menu-item
      (send menu-item-proto :new "Merge Observations" :enabled nil
            :action 'merge-observations))

(setf merge-mats-popup-menu-item
      (send menu-item-proto :new "Merge Matrices" :enabled nil
            :action 'merge-matrices))

(send *popup-data-menu* :append-items
      guide-data-popup-menu-item
      about-data-popup-item
      (send dash-item-proto :new)
      visualize-data-popup-menu-item
      summarize-data-popup-menu-item
      (send dash-item-proto :new)
      save-data-popup-menu-item
    ; delete-data-popup-menu-item
      create-dob-data-popup-menu-item
      browse-data-popup-menu-item
      show-datasheet-popup-menu-item
      (send dash-item-proto :new)
      show-obs-popup-menu-item
      show-vars-popup-menu-item
      (send dash-item-proto :new)
      merge-vars-popup-menu-item
      merge-obs-popup-menu-item
      merge-mats-popup-menu-item
      (send dash-item-proto :new)
      transform-data-popup-menu-item
      analyze-data-popup-menu-item)

(defun transform-data ()
  (let ((choice (choose-item-dialog "Transform Data ..." '(
"Sort-Permute ..." "Ranks"
"Normal Scores"    "Absolute Value"     "Rounding ..."       "Reciprocal"
"Exponential ..."  "Logarithm ..."      "Trigonometric ..."
"Correlations"     "Covariances"        "Distances"
"Transpose Data"   "Normalize Data ..." "Orthogonalize Data"
"User Defined ..." ))))
    (case choice
      ((0) (sort-permute :dialog t))
      ((1) (ranks))
      ((2) (normal-scores))
      ((3) (absolute-value))
      ((4) (rounding :dialog t))
      ((5) (reciprocal))
      ((6) (exponential :dialog t))
      ((7) (logarithm :dialog t))
      ((8) (trigonometric :dialog t))
      ((9) (correlations))
      ((10) (covariances))
      ((11) (distances))
      ((12) (transpose-data))
      ((13) (normalize-data :dialog t))
      ((14) (orthogonalize-data))
      ((15) (user-defined :dialog t)))
    ))

(defvar *popup-model-menu* (send menu-proto :new "Model"))

(setf guide-model-popup-menu-item
      (send menu-item-proto :new "Guidance"
            :action #'(lambda () (guidance "model"))))

(setf save-model-popup-menu-item
      (send menu-item-proto :new "Save Model"
            :action 'save-model))

(setf delete-model-popup-menu-item
      (send menu-item-proto :new "Delete Model"
            :action 'delete-model :enabled nil))

(setf create-dataobjects-model-popup-menu-item
      (send menu-item-proto :new "Create Data"
      :action #' (lambda () (send current-model :create-data :dialog t))))

(setf visualize-model-popup-menu-item
      (send menu-item-proto :new "Visualize Model"
            :action #'(lambda () (visualize-model))))

(setf report-model-popup-menu-item
      (send menu-item-proto :new "Report Model"
            :action #'(lambda () (report-model))))

(setf interpret-model-popup-menu-item
      (send expert-menu-item-proto :new "Interpret Model"
            :action #'(lambda () (interpret-model))))

(send *popup-model-menu* :append-items
      guide-model-popup-menu-item
      (send dash-item-proto :new)
      visualize-model-popup-menu-item
      report-model-popup-menu-item
  ;   interpret-model-popup-menu-item
      (send dash-item-proto :new)
      save-model-popup-menu-item
  ;   delete-model-popup-menu-item
      create-dataobjects-model-popup-menu-item
      )

(defun menus (arg)
  (when arg
;; AJR -mac => +msdos #-macintosh (send *command-menu* :install)
#+msdos     (send *command-menu* :install)
#+X11       (send *command-menu* :install)
            (send *data-menu*    :install)
            (send *trans-menu*   :install)
            (send *tools-menu*   :install)
            (send *model-menu*   :install)
            (send *help-menu*    :install))
  (when (not arg)
#+msdos     (send *command-menu* :remove)  ;; AJR same as above.
#+X11       (send *command-menu* :remove)
            (send *data-menu*    :remove)
            (send *trans-menu*   :remove)
            (send *tools-menu*   :remove)
            (send *model-menu*   :remove)
            (send *help-menu*    :remove))
  )


(provide "vismenu1")
