;;######################################################################## 
;; ViSta.lsp
;; Copyright (c) 1991-98 by Forrest W. Young 
;; Version 5.0.5 Beta, March 29th, 1998
;; For further information contact the author at forrest@unc.edu 
;; Modified for X11 by Anthony J. Rossini (4.24) & Charles Kurak (4.27)
;; This file contains initialization code and hardware-specific code 
;;######################################################################## 

#+macintosh(send *listener* :hide-window)
#-xlisp-plus(error "ViSta requires XLisp-Plus and version 3.37 (or later) of XLisp-Stat.") 
#-dialogs(error "ViSta requires the XLisp-Stat Dialogs feature.") 
#-windows(error "ViSta requires the XLisp-Stat Windowing sub-system.") 
#-color(error "ViSta requires color support.")
(when (not (screen-has-color)) (error "Color support conflict. The problem may be with XLispStat 32-bit color mode support."))
(if (> xls-minor-release 49)
    (setf *68040* nil)
    (setf *68040* t))
(provide "vista")
(setf *copyright-string* "Copyright (c) 1991-98 by Forrest W. Young")
(setf version-number " 5.")
(setf release-number "0.5E")
(setf release-date "March 29th, 1998") 
#+X11 (setf release-number (strcat release-number "X Beta)"))
#+macintosh (setf release-number (strcat release-number "M Beta"))
#+msdos (setf release-number (strcat release-number "W Beta"))
(setf *version-string* 
      (strcat "Version " version-number release-number 
              (format nil " (XLS ~a.~a" xls-major-release xls-minor-release) 
              (if (or (> xls-major-release 3) (> xls-minor-release 50))
                  (format nil ".~a) " xls-subminor-release)
                  ") ")
              release-date))

;;########################################################################
;;display logo window
;;########################################################################
(setf *logo-background* '(.75 1 1))
(setf *workmap-background* *logo-background*)
(apply #'make-color 'logo-background *logo-background*)
(apply #'make-color 'workmap-background *workmap-background*)
(load (strcat *vista-dir-name* "logoobj"))

#+msdos(let* ((size (floor (- (* .75 (screen-size)) (list 0 90))))
              (h (floor (/ (- (first size) 440) 2)))
              (v (floor (/ (- (second size) 220) 2))))
         (setf *logo* (make-logo :show t :size size
                                 :margin (list h v h v))))
#-msdos(setf *logo* (make-logo :show t))

;;########################################################################
;; define window sizes, locations and offsets. 
;;########################################################################
(send *logo* :write-text "Defining Window Attributes")
#+macintosh (setf menu-bar-height 38)
#+macintosh (setf window-decoration-width 18) 
#+macintosh (setf window-decoration-height 18) 
#+macintosh (setf size-width-fiddle 0)
#+macintosh (setf size-height-fiddle 0)
#-msdos     (setf msdos-fiddle 0)
#-msdos     (setf border-thickness 0)

#+msdos(setf menu-bar-height 0)
#+msdos(setf window-decoration-width 8) ;8
#+msdos(setf window-decoration-height 8);8
#+msdos(setf border-thickness 4) 
#+msdos(setf size-width-fiddle 0)
#+msdos(setf size-height-fiddle 0);0
#+msdos(setf msdos-fiddle 15)


#+X11 (setf menu-bar-height 0)
#+X11 (setf window-decoration-width 0)
#+X11 (setf window-decoration-height 0)
#+X11 (setf size-width-fiddle 22)
#+X11 (setf size-height-fiddle 70)

(setf screen-size (* 2 (floor (/ (screen-size) 2)))) 
#+msdos (setf screen-size (list (select screen-size 0) 
                                (- (select screen-size 1) 54)));58 56 54
#+win32 (if (not *full-screen*)
            (setf screen-size (list (select screen-size 0) 
                                    (- (select screen-size 1) 40))));50

;(setf screen-size (list 640 398)) ;for 640 480 win95 screen test
;(setf screen-size (list 640 480)) ;for 640 480 mac screen test
;(setf screen-size (list 725 480))
;(setf screen-size (list 725 500))

(defun spreadplot-sizes (size)
  (setf screen-size size)
  (setf row-pixels (select screen-size 1)) 
  (setf graph-size (floor (/ (- row-pixels menu-bar-height) 2))) 
  (setf med-graph-width (floor (/ (first screen-size) 2))) 
  (setf med-graph-height graph-size)
  (setf wide-graph-width (first screen-size)) 
  (setf wide-graph-height graph-size)
  (setf location11 (list 1 menu-bar-height)) 
  (setf location12
        (list (+ graph-size window-decoration-width) menu-bar-height)) 
  (setf location13
        (list (* 2 (+ graph-size window-decoration-width)) menu-bar-height)) 
  (setf location21
        (list 1 (+ graph-size menu-bar-height 
                   border-thickness window-decoration-height))) 
  (setf location22
        (list (+ graph-size window-decoration-width) 
              (+ graph-size menu-bar-height
                 border-thickness window-decoration-height))) 
  (setf location23
        (list (* 2 (+ graph-size window-decoration-width)) 
              (+ graph-size menu-bar-height 
                  border-thickness window-decoration-height))) 
  (setf graph-size
        (list (- graph-size size-width-fiddle)
              (- graph-size size-height-fiddle border-thickness)))
  (setf med-graph-size
        (list (- med-graph-width size-width-fiddle) 
              (- med-graph-height size-height-fiddle))) 
  (setf wide-graph-size
        (list (- wide-graph-width size-width-fiddle) 
              (- wide-graph-height size-height-fiddle))) 

  (setf full-graph-size
        (list (- wide-graph-width size-width-fiddle 9) 
              (- (* 2 wide-graph-height) size-height-fiddle 10))) 

#+macintosh(setf full-graph-size (+ full-graph-size (list (- 9) 28))) 

  (setf namelist-size 
        (list (- (select screen-size 0) (select location23 0) 8 
                 (- msdos-fiddle)) 
              (select graph-size 1)))
  (setf long-namelist-length 
        (* 2 (+ 10 (- (select namelist-size 1) msdos-fiddle))))
#+msdos (setf long-namelist-length (+ long-namelist-length 3))
#+macintosh (setf long-namelist-length (- long-namelist-length 2))
  (setf (select graph-size 1) (- (select graph-size 1) msdos-fiddle))
  (setf *text-window-size*
        (list 490 (max 112 (min 280 (- (second screen-size) 326))))) 
  (setf *text-window-location* (list 10 (min 322 (- row-pixels 138)))) 
  )

(spreadplot-sizes screen-size)

;;########################################################################
;;define copyright information for About ViSta
;;########################################################################

(setf about (strcat "ViSta: The Visual Statistics System 
" *copyright-string*
"
" *version-string* "
Web Site: http://forrest.psych.unc.edu/")) 

#+msdos(defun about-vista ()
         (setf *copyright*
               (send dialog-proto :new 
                     (list (send text-item-proto :new about)) 
                     :title "About ViSta"
                     :location '(10 10)
                     :size '(320 140)
                     )))
#-msdos(defun about-vista ()
         (setf *copyright*
               (send dialog-proto :new 
                     (list (send text-item-proto :new about)) 
                     :title "About ViSta")))

#+X11(defun about-xlisp-stat ()
       (message-dialog (format nil "XLISP-PLUS version 2.1g~%~
Portions Copyright (c) 1988, by David Betz~%~
Modified by Thomas Almy and others.~%~%~
XLISP-STAT Version 2.1 Release ~d.~d  (Beta).~%~
Statistical additions to XLISP by Luke Tierney~%~
Copyright 1990 (c) by Luke Tierney"
xls-major-release xls-minor-release)))

#+macintosh(send *listener* :flush-window)
#-msdos(princ about)
#-msdos(terpri)
#-msdos(terpri)

;;########################################################################
;;load base files - vista, boxplot2 and overlay are also base files
;;########################################################################
(mapcar #'(lambda (file)
            (let ((space (if (= (length file) 7) " " "")))
              (send *logo* :write-text 
                  (format nil "Loading Program Files: ~a~a" space file)) 
              (load (strcat *vista-dir-name* file))))
        (list "vismenu1" "vismenu2" "iconobj1" "iconobj2" "workmap1"
              "workmap2" "workmap3" "systmob1" "systmob2" "systmob3"
              "dataobj1" "dataobj2" "dataobj3" "dataobj4" "datasim"
              "graphic0" "graphic1" "spinplot" "boxplot1" "qplotobj" 
              "datavis"  "dashobj1" "dashobj2" "dashobj3" "dashobj4" 
              "modelobj" "tranobj1" "tranobj2" "function" "statfunc" 
              "sprdplot" "generic"  "displayw" "graphelp"))
#-macintosh(load (strcat *vista-dir-name* "cursors"));non-base file
#+X11 (load (strcat *vista-dir-name* "file-sel"));;Charles Kurak Dec 1996

(send *logo* :write-text "Creating Objects: Colors ")

;;########################################################################
;;construct workmap
;;########################################################################

;;Set default colors. These may be overridden by preferences file.

(case *color-mode*
  (0 ; no color
     (setf *workmap-background* (list 1 1 1))
     (setf *toolbar-background* (list 1 1 1)))
  (1 ; 64 colors
     (setf *workmap-background* (list .75 .75 1.0))
     (setf *toolbar-background* (list 1.0 .75 .75)))
  (2 ; 256 colors
     (setf *workmap-background* (list .875 .875 1.00))
     (setf *toolbar-background* (list 1.00 .875 .875)))
  (3 ; millions of colors
     (setf *workmap-background* (list .92 .98 1.0))
     (setf *toolbar-background* (list 1.0 .95 .95))))

(setf *data-icon-color* '(0 0 .75))
(setf *model-icon-color*'( 0 5 .25))
(setf *tool-icon-color* '(.75 0 0))
(setf *guide-icon-color* '(.75 0 0))
(setf *button-on-color* '(0 0 1))
(setf *button-off-color* '(1 1 1))

(apply #'make-color 'toolbar-background *toolbar-background*)
(apply #'make-color 'workmap-background *workmap-background*)
(apply #'make-color 'data-icon-color *data-icon-color*)
(apply #'make-color 'model-icon-color *model-icon-color*)
(apply #'make-color 'tool-icon-color *tool-icon-color*)
(apply #'make-color 'guide-icon-color *guide-icon-color*)
(apply #'make-color 'button-on-color *button-on-color*)
(apply #'make-color 'button-off-color *button-off-color*)

(setf *workmap* (workmap))
(setf *desktop* *workmap*)
(send *workmap* :toolbar nil)
(setf *toolbox* (toolbox))
(send (select (send *toolbox* :icon-list) 0) :icon-state "normal") 

(send *workmap* :num-data-menu-items
      (length (send (eval *data-menu*) :items))) 
(send *workmap* :num-model-menu-items
      (length (send (eval *model-menu*) :items))) 

(setf current-data nil)
(setf current-model nil)
(setf current-transf nil)
(setf current-object nil)
(setf *current-object* nil)
(setf *current-spreadplot* nil)
(setf previous-data nil)
(setf *guidemap*	nil)
(setf *expertmap* nil)
(setf v-options '((0)))

;;########################################################################
;;create system object and windows 
;;########################################################################

(send *logo* :write-text "Creating Objects: System ")
;following statements needed in systmobj. values are not important
#+msdos(setf var-obs-window-size (list 125 179)) ; 125 193
#+msdos(setf obs-window-location (list 508 0)) ;483 0 
#+msdos(setf var-window-location (list 508 207)) ;483 221
#-msdos(setf var-obs-window-size (list 100 196)) 
#-msdos(setf obs-window-location (list 505  40))
#-msdos(setf var-window-location (list 505 258)) 
 
(setf *vista* (vista-system))
(setf *message-window* (send *vista* :create-message-window :show nil))
(send *vista* :show-load-vista ask-load-vista)


;#+macintosh (send *vista* :guide-window-location '(275  38)) ;257  20
;#+msdos     (send *vista* :guide-window-location '(121  80)) ;278 150
;#+X11       (send *vista* :guide-window-location '(278 140)) ;258 120
#+msdos     (send *vista* :guide-window-size '(246 280)) 
#-msdos     (send *vista* :guide-window-size '(243 280)) 
(send *vista* :guide-window-location 
      (floor (/ (- screen-size (send *vista* :guide-window-size)) 2)))

(setf *var-window* (send *vista* :var-window-object)) 
(setf *obs-window* (send *vista* :obs-window-object)) 
(setf *mat-window* *obs-window*)
(send *obs-window* :add-plot-help-item "Obs Window")
(send *var-window* :add-plot-help-item "Vars Window")

;;########################################################################
;;install menus
;;########################################################################

(send *logo* :write-text "Creating Objects: Menus  ") 
#+macintosh (send *apple-menu* :append-items 
                  (send menu-item-proto :new "About ViSta" :action 
                        #'(lambda () (about-vista))))

(defun make-long-menus ()
  (send *vista* :long-menus t)
  (send *data-menu* :append-items (send dash-item-proto :new)) 
  (send *model-menu* :append-items (send dash-item-proto :new)) 
  (send *workmap* :num-data-menu-items
        (1+ (send *workmap* :num-data-menu-items))) 
  (send *workmap* :num-model-menu-items
        (1+ (send *workmap* :num-model-menu-items))) )

(send *vista* :long-menus nil)
(send *workmap* :enabled-trans-menu nil)
#+msdos(msdos-file-menu)
(send *help-menu* :append-items (send dash-item-proto :new))

;(setf *vista-help* (send menu-item-proto :new "Topics"))
(plot-help-window "ViSta: The Visual Statistics System")
(setf text-top nil)
(setf winmac-x11 nil)
#-X11(setf winmac-x11 t)
(setf win-mac nil)
#+msdos(setf text-top t)
#+msdos(setf win-mac t)

(load (strcat *prefs-dir-name* "prefs"))
(load (strcat *prefs-dir-name* "desktop"))

(send *logo* :write-text "Creating Objects: Colors ") 
#-color (send *vista* :background-color nil)
(apply #'make-color 'workmap-background *workmap-background*)
(apply #'make-color 'toolbar-background *toolbar-background*)
(apply #'make-color 'data-icon-color *data-icon-color*)
(apply #'make-color 'model-icon-color *model-icon-color*)
(apply #'make-color 'tool-icon-color *tool-icon-color*)
(apply #'make-color 'guide-icon-color *guide-icon-color*)
(apply #'make-color 'button-on-color *button-on-color*)
(apply #'make-color 'button-off-color *button-off-color*)
(send *vista* :color-values-list 
      (list *workmap-background* *toolbar-background* 
            *data-icon-color*  *model-icon-color* 
            *tool-icon-color* *guide-icon-color* 
            *button-on-color* *button-off-color*))
(when (not (send *vista* :desktop-sizes))
      (send *vista* :desktop-sizes screen-size))
(when (> 0 (min (- screen-size (send *vista* :desktop-sizes))))
      (send *vista* :desktop-sizes screen-size))

(fade-splash-screen *logo*)

(when (= *color-mode* 0)(send *vista* :turn-color-off))

;;########################################################################
;;construct desktop
;;########################################################################

(send *vista* :make-desktop (send *vista* :desktop-sizes) text-top winmac-x11 win-mac t)
(when (not (send *vista* :hide-workmap))
      (send *workmap* :gui t)) ;show workmap

#+color(when (> *color-mode* 0)
             (when (send *vista* :background-color)
                   (send *workmap* :back-color 'workmap-background)))

(when (send *vista* :show-varobs) (show-varobs))

#+macintosh(send *listener* :flush-window)
#+macintosh(send *listener* :title "Listener")
(setf *about-window* nil)
#|
(setf *about-window* (send *vista* :create-message-window 
                           :location
               #+macintosh  (+ '(30 30) (send *listener* :location))
               #-macintosh     '(30 30)
                           :show nil :size '(400 75)))
|#
#-msdos(princ about)
#-msdos(terpri)
#+macintosh(when (send *vista* :show-listener) (show-xlisp-stat))
#+macintosh (when ask-load-vista (send *vista* :show-load-vista t))
#+macintosh(when (< xls-minor-release 52)
                 (apply #'send *help-window* :location 
                        (+ (send *help-window* :location)'(0 20))))
#+macintosh(apply #'send *help-window* :size 
                  (- (send *help-window* :size)'(15 0)))
(send *help-window* :show-window)
(setf *vista-help* (send menu-item-proto :new "Topics"))
#+msdos(send *vista* :refresh-desktop)

(cond 
  ((send *vista* :show-first-help)
   (send *workmap* :show-help *vista-help*)
   (when *change-profiles* 
         (paste-plot-help (format nil "~%If you do not wish to see this help message when you first run ViSta, use the COMMAND menu's STARTUP PREFERENCES item to turn initial help off."))))
  #-macintosh(t
              (plot-help-window "ViSta: The Visual Statistics System")
              (paste-plot-help about))
  #+macintosh(t
              (plot-help-window "Help and Information Window" )
              )
  )
(show-plot-help)

#+X11 (send xlisp::*fake-menu-bar* :location 1 38)
#+X11 (send xlisp::*fake-menu-bar* :size 500 27)
#+X11 (defmeth xlisp::*fake-menu-bar* :close ())
#+X11 (send *workmap* :location 1 120)
#+X11 (send *workmap* :size 500 280)
#+X11 (defmeth XLISP::*FAKE-MENU-BAR* :close () (quit))

(defun about-vista () (about-vista-with-logo))

#+macintosh(make-cursor 'no-action 3)
#+macintosh(make-cursor 'i-beam 1)

;(send *help-window* :has-v-scroll (* (+ 2 (send *help-window* :nlines)) 
;                                     (send *help-window* :line-height)))

(when (send *vista* :show-welcome) (welcome-message))
(when (send *vista* :show-open-data) (open-data))
(when (send *vista* :show-guidemap)  (show-guidemap))
