/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DockingSplitPaneUI
extends BasicSplitPaneUI {
    Color shadow = UIManager.getColor("VLDocking.shadow");
    Color highlight = UIManager.getColor("VLDocking.highlight");
    TexturePaint tp = null;
    private static boolean drawDelimitors = UIManager.getBoolean("SplitContainer.drawDotsDelimitors");
    private static boolean useCustomImages = UIManager.getBoolean("SplitContainer.useCustomImages");
    private static BufferedImage horizontalImage = (BufferedImage)UIManager.get("SplitContainer.hImage");
    private static BufferedImage verticalImage = (BufferedImage)UIManager.get("SplitContainer.vImage");
    private static int dividerSize = UIManager.getInt("SplitContainer.dividerSize");
    private static boolean isSplitResizingEnabled = UIManager.getBoolean("SplitContainer.isResizingEnabled");

    public static void setDrawDelimitors(boolean draw) {
        drawDelimitors = draw;
    }

    public static ComponentUI createUI(JComponent x) {
        return new DockingSplitPaneUI();
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        ((JSplitPane)comp).setDividerSize(dividerSize);
        comp.setEnabled(isSplitResizingEnabled);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.divider.setBorder(null);
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        DockingSplitPaneDivider bd = new DockingSplitPaneDivider(this);
        return bd;
    }

    class DockingSplitPaneDivider
    extends BasicSplitPaneDivider {
        private static final long serialVersionUID = 1L;

        DockingSplitPaneDivider(BasicSplitPaneUI ui) {
            super(ui);
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            Color bgColor = this.getBackground();
            if (bgColor != null) {
                g.setColor(bgColor);
                g.fillRect(0, 0, size.width, size.height);
            }
            if (useCustomImages) {
                Graphics2D g2 = (Graphics2D)g.create();
                BufferedImage image = DockingSplitPaneUI.this.getOrientation() == 1 ? verticalImage : horizontalImage;
                int width = image.getWidth();
                int height = image.getHeight();
                Rectangle r = new Rectangle(0, 0, width, height);
                if (DockingSplitPaneUI.this.tp == null) {
                    DockingSplitPaneUI.this.tp = new TexturePaint(image, r);
                }
                if (DockingSplitPaneUI.this.getOrientation() == 1) {
                    g2.setPaint(DockingSplitPaneUI.this.tp);
                    g2.fillRect(size.width / 2 - width / 2, 0, width, size.height);
                } else {
                    g2.setPaint(DockingSplitPaneUI.this.tp);
                    g2.fillRect(0, size.height / 2 - height / 2, size.width, height);
                }
            } else if (drawDelimitors) {
                if (DockingSplitPaneUI.this.tp == null) {
                    BufferedImage bi = new BufferedImage(4, 4, 1);
                    Graphics2D big = bi.createGraphics();
                    big.setColor(this.getBackground());
                    big.fillRect(0, 0, 4, 4);
                    big.setColor(DockingSplitPaneUI.this.highlight);
                    big.fillRect(1, 1, 1, 1);
                    big.setColor(DockingSplitPaneUI.this.shadow);
                    big.fillRect(2, 2, 1, 1);
                    Rectangle r = new Rectangle(0, 0, 4, 4);
                    DockingSplitPaneUI.this.tp = new TexturePaint(bi, r);
                    big.dispose();
                }
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setPaint(DockingSplitPaneUI.this.tp);
                if (DockingSplitPaneUI.this.getOrientation() == 1) {
                    g2.fillRect(size.width / 2 - 2, 0, 4, size.height);
                } else {
                    g2.fillRect(0, size.height / 2 - 2, size.width, 4);
                }
            }
            super.paint(g);
        }
    }
}

