/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.custom;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.Version;

public final class CustomAnalyzer
extends Analyzer {
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] tokenFilters;
    private final Integer posIncGap;
    private final Integer offsetGap;

    public static Builder builder() {
        return CustomAnalyzer.builder(new ClasspathResourceLoader());
    }

    public static Builder builder(Path configDir) {
        return CustomAnalyzer.builder(new FilesystemResourceLoader(configDir));
    }

    public static Builder builder(ResourceLoader loader) {
        return new Builder(loader);
    }

    CustomAnalyzer(Version defaultMatchVersion, CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] tokenFilters, Integer posIncGap, Integer offsetGap) {
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.tokenFilters = tokenFilters;
        this.posIncGap = posIncGap;
        this.offsetGap = offsetGap;
        if (defaultMatchVersion != null) {
            this.setVersion(defaultMatchVersion);
        }
    }

    protected Reader initReader(String fieldName, Reader reader) {
        for (CharFilterFactory charFilter : this.charFilters) {
            reader = charFilter.create(reader);
        }
        return reader;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tk;
        Tokenizer ts = tk = this.tokenizer.create();
        for (TokenFilterFactory filter : this.tokenFilters) {
            ts = filter.create((TokenStream)ts);
        }
        return new Analyzer.TokenStreamComponents(tk, (TokenStream)ts);
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.posIncGap == null ? super.getPositionIncrementGap(fieldName) : this.posIncGap.intValue();
    }

    public int getOffsetGap(String fieldName) {
        return this.offsetGap == null ? super.getOffsetGap(fieldName) : this.offsetGap.intValue();
    }

    public List<CharFilterFactory> getCharFilterFactories() {
        return Collections.unmodifiableList(Arrays.asList(this.charFilters));
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public List<TokenFilterFactory> getTokenFilterFactories() {
        return Collections.unmodifiableList(Arrays.asList(this.tokenFilters));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('(');
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory).append(',');
        }
        sb.append(this.tokenizer);
        for (AbstractAnalysisFactory abstractAnalysisFactory : this.tokenFilters) {
            sb.append(',').append(abstractAnalysisFactory);
        }
        return sb.append(')').toString();
    }

    public static final class Builder {
        private final ResourceLoader loader;
        private final SetOnce<Version> defaultMatchVersion = new SetOnce();
        private final List<CharFilterFactory> charFilters = new ArrayList<CharFilterFactory>();
        private final SetOnce<TokenizerFactory> tokenizer = new SetOnce();
        private final List<TokenFilterFactory> tokenFilters = new ArrayList<TokenFilterFactory>();
        private final SetOnce<Integer> posIncGap = new SetOnce();
        private final SetOnce<Integer> offsetGap = new SetOnce();
        private boolean componentsAdded = false;

        Builder(ResourceLoader loader) {
            this.loader = loader;
        }

        public Builder withDefaultMatchVersion(Version version) {
            Objects.requireNonNull(version, "version may not be null");
            if (this.componentsAdded) {
                throw new IllegalStateException("You may only set the default match version before adding tokenizers, token filters, or char filters.");
            }
            this.defaultMatchVersion.set((Object)version);
            return this;
        }

        public Builder withPositionIncrementGap(int posIncGap) {
            if (posIncGap < 0) {
                throw new IllegalArgumentException("posIncGap must be >= 0");
            }
            this.posIncGap.set((Object)posIncGap);
            return this;
        }

        public Builder withOffsetGap(int offsetGap) {
            if (offsetGap < 0) {
                throw new IllegalArgumentException("offsetGap must be >= 0");
            }
            this.offsetGap.set((Object)offsetGap);
            return this;
        }

        public Builder withTokenizer(String name, String ... params) throws IOException {
            return this.withTokenizer(name, this.paramsToMap(params));
        }

        public Builder withTokenizer(String name, Map<String, String> params) throws IOException {
            Objects.requireNonNull(name, "Tokenizer name may not be null");
            this.tokenizer.set((Object)this.applyResourceLoader(TokenizerFactory.forName(name, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public Builder addTokenFilter(String name, String ... params) throws IOException {
            return this.addTokenFilter(name, this.paramsToMap(params));
        }

        public Builder addTokenFilter(String name, Map<String, String> params) throws IOException {
            Objects.requireNonNull(name, "TokenFilter name may not be null");
            this.tokenFilters.add(this.applyResourceLoader(TokenFilterFactory.forName(name, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public Builder addCharFilter(String name, String ... params) throws IOException {
            return this.addCharFilter(name, this.paramsToMap(params));
        }

        public Builder addCharFilter(String name, Map<String, String> params) throws IOException {
            Objects.requireNonNull(name, "CharFilter name may not be null");
            this.charFilters.add(this.applyResourceLoader(CharFilterFactory.forName(name, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public CustomAnalyzer build() {
            if (this.tokenizer.get() == null) {
                throw new IllegalStateException("You have to set at least a tokenizer.");
            }
            return new CustomAnalyzer((Version)this.defaultMatchVersion.get(), this.charFilters.toArray(new CharFilterFactory[this.charFilters.size()]), (TokenizerFactory)this.tokenizer.get(), this.tokenFilters.toArray(new TokenFilterFactory[this.tokenFilters.size()]), (Integer)this.posIncGap.get(), (Integer)this.offsetGap.get());
        }

        private Map<String, String> applyDefaultParams(Map<String, String> map) {
            if (this.defaultMatchVersion.get() != null && !map.containsKey("luceneMatchVersion")) {
                map.put("luceneMatchVersion", ((Version)this.defaultMatchVersion.get()).toString());
            }
            return map;
        }

        private Map<String, String> paramsToMap(String ... params) {
            if (params.length % 2 != 0) {
                throw new IllegalArgumentException("Key-value pairs expected, so the number of params must be even.");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < params.length; i += 2) {
                Objects.requireNonNull(params[i], "Key of param may not be null.");
                map.put(params[i], params[i + 1]);
            }
            return map;
        }

        private <T> T applyResourceLoader(T factory) throws IOException {
            if (factory instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)factory).inform(this.loader);
            }
            return factory;
        }
    }
}

