/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNWCDbSelectIPropsNode
extends SVNSqlJetSelectStatement {
    private SVNDepth depth;

    public SVNWCDbSelectIPropsNode(SVNSqlJetDb sDb) throws SVNException {
        super(sDb, SVNWCDbSchema.NODES);
        this.setDepth(SVNDepth.EMPTY);
    }

    public void setDepth(SVNDepth depth) {
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        this.depth = depth;
    }

    @Override
    protected String getIndexName() {
        if (this.depth == SVNDepth.IMMEDIATES || this.depth == SVNDepth.FILES) {
            return SVNWCDbSchema.NODES__Indices.I_NODES_PARENT.toString();
        }
        return super.getIndexName();
    }

    @Override
    protected Object[] getWhere() throws SVNException {
        if (this.depth == SVNDepth.EMPTY || this.depth == SVNDepth.IMMEDIATES || this.depth == SVNDepth.FILES) {
            return new Object[]{this.getBind(1), this.getBind(2)};
        }
        return new Object[]{this.getBind(1)};
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        if (this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) != 0L) {
            return false;
        }
        byte[] blob = this.getColumnBlob(SVNWCDbSchema.NODES__Fields.inherited_props);
        return blob != null;
    }

    @Override
    protected String getPathScope() {
        if (this.depth == SVNDepth.INFINITY) {
            return (String)this.getBind(2);
        }
        return null;
    }

    @Override
    protected boolean isStrictiDescendant() {
        return true;
    }
}

