/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.model.length;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.loomchild.maligna.model.length.LengthModel;

public class MutableLengthModel
implements LengthModel {
    private ArrayList<Float> lengthProbabilityArray = new ArrayList();
    float meanLength = 0.0f;
    int totalLength = 0;
    int lengthOccurenceCount = 0;

    @Override
    public float getLengthProbability(int length) {
        assert (length >= 0);
        if (length < this.lengthProbabilityArray.size()) {
            return this.lengthProbabilityArray.get(length).floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getMeanLength() {
        return this.meanLength;
    }

    public void addLengthOccurence(int length) {
        assert (length >= 0);
        this.ensureSize(length + 1);
        this.lengthProbabilityArray.set(length, Float.valueOf(this.lengthProbabilityArray.get(length).floatValue() + 1.0f));
        ++this.lengthOccurenceCount;
        this.totalLength += length;
    }

    public void normalize() {
        for (int i = 0; i < this.lengthProbabilityArray.size(); ++i) {
            float probability = this.lengthProbabilityArray.get(i).floatValue() / (float)this.lengthOccurenceCount;
            this.lengthProbabilityArray.set(i, Float.valueOf(probability));
        }
        this.meanLength = (float)this.totalLength / (float)this.lengthOccurenceCount;
    }

    private void ensureSize(int size) {
        int currentSize = this.lengthProbabilityArray.size();
        if (size > currentSize) {
            this.lengthProbabilityArray.ensureCapacity(size);
            for (int i = currentSize; i < size; ++i) {
                this.lengthProbabilityArray.add(Float.valueOf(0.0f));
            }
        }
    }

    @Override
    public void format(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        for (int i = 0; i < this.lengthProbabilityArray.size(); ++i) {
            printWriter.println(i + "\t" + this.lengthProbabilityArray.get(i));
        }
    }
}

