/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSModelLoader;
import opennlp.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;

public final class POSTaggerEvaluatorTool
extends AbstractEvaluatorTool<POSSample, EvalToolParams> {
    public POSTaggerEvaluatorTool() {
        super(POSSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the POS tagger model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        POSModel model = (POSModel)new POSModelLoader().load(((EvalToolParams)this.params).getModel());
        POSEvaluationErrorListener missclassifiedListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            missclassifiedListener = new POSEvaluationErrorListener();
        }
        POSTaggerFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new POSTaggerFineGrainedReportListener(reportOutputStream);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating POS Tagger fine-grained report file: " + e.getMessage());
            }
        }
        POSEvaluator evaluator = new POSEvaluator(new POSTaggerME(model), missclassifiedListener, reportListener);
        System.out.print("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        if (reportListener != null) {
            System.out.println("Writing fine-grained report to " + ((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        System.out.println();
        System.out.println("Accuracy: " + evaluator.getWordAccuracy());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
        @ArgumentParser.ParameterDescription(valueName="outputFile", description="the path of the fine-grained report file.")
        @ArgumentParser.OptionalParameter
        public File getReportOutputFile();
    }
}

