	; Main changes to ge this compiled with AS:
	; -> remove semicolons used to separate statements
	; -> rework statements that spanned multiple lines to single-line statements
	; -> change % to ; (comment lead-in)
	; -> rework hex constants #... to ...h
	; -> change CONST to EQU resp. =
	; -> change BYTE/WORD to DB/DW
	; -> change macro(s) to AS-style
	; -> change Rn to Rn^ for OTIR/IN/OUT (did this work with original assembler?)
	; -> change TIME to ITIME (conflicts with built-in symbol)
	; -> change ORIGIN to ORG resp. RORG

	CPU	Z8002:AMDSyntax=1
	include	"bitfuncs.inc"
	SUPMODE	ON

;	PROGRAM PROCMTR	; TODO
	TITLE	'PROC.070 MONITOR V2.0'
	ORG	0h
	PAGE	0
;
CPT	=	0C001H	;CONSOLE PORT  UPD 7201 CHIP
SPT	=	0C005H	;TTY PORT	UPD 7201 CHIP
BKP	=	0E100H	;BREAKPOINT REGISTER
TPT	=	0C011H	;TIMER PORT
TMD2	=	0B6H	;TIMER 2 MODE
TMD1	=	76H	;TIMER 1 MODE
TMD0	=	036H	;TIMER 0 MODE
RT96	=	14H	;TIMER RATE FOR 9600
BNKMSK	=	0FF80H	;BANKSWITCH MASK
;
CR	=	0DH	;CARRIAGE RETURN
LF	=	0AH	;LINE FEED
ESC	=	1BH	;ESCAPE
DEL	=	7FH	;CHARACTER DELETE
CAN	=	18H	;LINE CANCEL
BSP	=	08H	;BACKSPACE
;
USERP	=	1000H	;USER PROM ADDRESS
DATA	=	7E04H	;NPSAREA AND DATA STORAGE AREA
SYMDE	=	4000H	;SYSTEM MODE FLAG CONTROL WORD
;
PTM	=	0D000H	;TIMER DATA PORT
MPTA	=	PTM+4	;MASTER PIC PORT
MPTB	=	PTM+6	;MASTER PIC PORT A=1
SA1A	=	PTM+8	;SLAVE 1 PIC PORT
SA1B	=	PTM+0AH	;SLAVE 1 PIC PORT A=1
SA2A	=	PTM+0CH	;SLAVE 2 PIC PORT
SA2B	=	PTM+0EH	;SLAVE 2 PIC PORT A=1
;
TRMDE	=	5	;SET IF STEP MODE PERMITTED
STPFLG	=	6	;SET IF IN STEP MODE
;
M3	=	7	;VARIOUS MASKS
M4	=	0FH
M5	=	1FH
M7	=	7FH
M8	=	0FFH
MU4	=	0F000H
MU8	=	0FF00H
MU12	=	0FFF0H
MU13	=	0FFF8H
MU15	=	0FFFEH
;
LDA	MACRO	DST,SRC
	DW	4D05H		;LD DA,IM
	DW	DST		;DA
	DW	SRC		;IM
	ENDM
;
PROCMTR:DW	0
	DW	SYMDE
	DW	INIT
;
CHTAB:	DB	'    '		; SPACE
NIMS:	DB	' NI='
BSPMS:	DB	BSP,' ',BSP
FCWL:	DB	'XSXVNXXXCZSPDH'
PCMS:	DB	'NXT PC='
BPCMS:	DB	'BRK PC='
CNMSG:	DB	'#',CR,LF
PRMSG:	DB	'*',CR,LF
ERMSG:	DB	'?',CR,LF
;
SIGNON:	DB	CR,LF
	DB	'PROC 070 MONITOR V 2,0'	
	DB	CR,LF
;
SIGNONL	=	^$-^SIGNON
;
SPECM:	DB	'SPEC. OPCODE',CR,LF
SPECML	=	^$-^SPECM
PRIVM:	DB	'PRIV. INSTR.',CR,LF
PRIVML	=	^$-^PRIVM
NONVM:	DB	'NON VECT. INT.',CR,LF
NONVML	=	^$-^NONVM
VEC3M:	DB	'VECT.3',CR,LF
VEC3ML	=	^$-^VEC3M
;
CMDLST: DB	'BCDEFGHMNOPRSIVXZ',CR,0


	RORG	LO($) & 1
CMDADD:	DW	SETBRK			;SET BREAKPOINTS AND GO
	DW	SETCRY			;SET CARRY FLAG
	DW	SETDAJ			;SET DEC ADJUST FLAG OR DISP MEMORY
	DW	EXBRK			;SET HARDWARE BREAKPOINT
	DW	FILMEM			;FILL MEMORY
	DW	XECTE			;GO TO PC OR SPECIFIED ADDRESS
	DW	SETHLF			;SET HALF CARRY FLAG
	DW	MOVE			;MOVE MEMORY
	DW	UMODE			;SET USER NORMAL MODE
	DW	OUTPORT			;EXECUTE OUTPUT COMMAND
	DW	SETPAR			;SET PARITY FLAG OR PC ADDRESS
	DW	SETREG			;SET REGISTER CONTENT
	DW	SETSGN			;SET SIGN FLAG OR SUBSTITUTE MEMORY
	DW	IOPORT			;EXECUTE INPUT COMMAND
	DW	SETOVF			;SET OVERFLOW FLAG
	DW	DISREG			;DISPLAY REGISTERS
	DW	SETZRO			;SET ZERO FLAG
	DW	STEP			;EXECUTE STEP MODE
;
;DMSGL	=	^$-^DMSG		; TODO
USERM:	DB	'PROGRAM ERROR',CR,LF
USERML	=	^$-^USERM
;
	RORG	LO($) & 1
;
STAREA:	DW	SYMDE
	DW	SPEC			;SPECIAL OPCODE
	DW	SYMDE
	DW	PRIV			;PRIV. INSTRUCTION
	DW	SYMDE
	DW	SYSCAL			;SYSTEM CALL
	DW	SYMDE
	DW	USERR
	DW	SYMDE
	DW	STPRTN			;NON MASK. INT.
	DW	SYMDE
	DW	NONV			;NON VECT INT.
	DW	SYMDE
	DW	CLOCK			;VECTORED INT.
	DW	VEC1
	DW	VEC2
	DW	VEC3			;CLOCK INT
;
USEXT:	DB	'PROGRAM EXIT'
USEXTL	=	^$-^USEXT
;
VEC1M:	DB	'VECT.1',CR,LF
VEC1ML	=	^$-^VEC1M
;
VEC2M:	DB	'VECT.2',CR,LF
VEC2ML	=	^$-^VEC2M
;
	RORG	LO($) & 1
;
INIT:	LD	R1,^STAREA		;MOVE NPASP IN RAM
	LD	R3,^NPSAREA
	LD	R2,0010H
	LDIR	R3^,R1^,R2
	LD	R0,^NPSAREA-4
	LDCTL	PSAPOFF,R0
	SOUT	0FF00H,R0		;SELECT BANK 0
	CLR	BANKSW			;CLEAR BNKSW. REG
	CLR	HWBRK			;CLEAR HWBRK REG.
;
;	INIT. PCMI 070
;
	LD	R0,TMD2
	OUT	TPT+6,R0		;MODE TIMER 2
	LD	R0,TMD1
	OUT	TPT+6,R0		;MODE TIMER 1
	LD	R0,TMD0
	OUT	TPT+6,R0		;MODE TIMER 0
	LD	R1,RT96
	OUT	TPT,R1			;TIMER 0 LSB (CRT PORT)
	EXB	RH1,RL1
	OUT	TPT,R1			;TIMER 0 MSB
	LD	R1,RT96
	OUT	TPT+4,R1		;TIMER 2 LSB (AUX PORT)
	EXB	RH1,RL1
	OUT	TPT+4,R1		;TIMER 2 MSB
	LD	R1,RT96
	OUT	TPT+2,R1		;TIMER 1 LSB (TTY PORT)
	EXB	RH1,RL1
	OUT	TPT+2,R1		;TIMER 1 MSB
;
	LD	R4,^ENDBUFA-^SRCBUFA
	LD	R2,^SRCBUFA
	LD	R1,CPT+2		;INIT SIO #1 CH A : CONSOLE
	OTIRB	R1,R2^,R4
;
	LD	R4,^ENDBUFB-^SRCBUFB
	LD	R2,^SRCBUFB
	LD	R1,SPT+2		;INIT SIO #1 CH B : TTY
	OTIRB	R1,R2^,R4
;
	LD	R4,^ENDBUFA-^SRCBUFA
	LD	R2,^SRCBUFA
	LD	R1,CPT+10		;INIT SIO #2 CH A : AUX 1
	OTIRB	R1,R2^,R4
;
	LD	R4,^ENDBUFB-^SRCBUFB
	LD	R2,^SRCBUFB
	LD	R1,CPT+14		;INIT SIO #2 CH B : AUX 2
	OTIRB	R1,R2^,R4
;
;	INIT. PTIM 070
;
	LD	R0,0FFFFH		;MASTER RESET
	OUT	PTM+2,R0
	LD	R0,0FFEFH		;16 BIT MODE
	OUT	PTM+2,R0
	LD	R0,0FF17H		;MASTER MODE REGISTER
	OUT	PTM+2,R0
	LD	R0,6CE1H		;MM SETTING 50HZ CLOCK
	OUT	PTM,R0
;
	LD	R0,0FF03H		;DATA PNT CNT 3
	OUT	PTM+2,R0
	LD	R0,0B22H		;SQUARE WAVE
	OUT	PTM,R0
;
	LD	R0,0FF04H		;DATA PNT CNT 4
	OUT	PTM+2,R0
	LD	R0,0B22H		;SQUARE WAVE
	OUT	PTM,R0
;
	LD	R0,0FF05H		;DATA PNT CNT 5
	OUT	PTM+2,R0
	LD	R0,0E21H		;PULS
	OUT	PTM,R0
;
	LD	R0,0FF0BH		;DATA PNT CNT 3
	OUT	PTM+2,R0
	LD	R0,0008H		;LOAD REG
	OUT	PTM,R0
;
	LD	R0,0FF0CH		;DATA PNT CNT 4
	OUT	PTM+2,R0
	LD	R0,0010H		;LOAD REG
	OUT	PTM,R0
;
	LD	R0,0FF0DH		;DATA PNT CNT 5
	OUT	PTM+2,R0
	LD	R0,0258H		;LOAD REG
	OUT	PTM,R0
;
	LD	R0,0FF7CH		;LOAD AND ARM
	OUT	PTM+2,R0
;
;	MASTER
;
	LD	R0,0011H		;ICW 1
	OUT	MPTA,R0
	LD	R0,0000H		;ICW 2
	OUT	MPTB,R0
	LD	R0,00C0H		;S7,S6 SLAVE
	OUT	MPTB,R0
	LD	R0,0017H		;ICW 4
	OUT	MPTB,R0
	LD	R0,0002H
	OUT	MPTB,R0			;OCW 1
	OUT	MPTA,R0			;EN INT
;
;	SLAVE #1
;
	LD	R0,0011H		;ICW 1
	OUT	SA1A,R0
	LD	R0,0010H		;ICW 2
	OUT	SA1B,R0
	LD	R0,0006H		;ICW 3
	OUT	SA1B,R0
	LD	R0,0013H		;ICW 4
	OUT	SA1B,R0
	LD	R0,0000H
	OUT	SA1B,R0			;OCW 1
	OUT	SA1A,R0			;EN INT
;
;	SLAVE #2
;
	LD	R0,0011H		;ICW 1
	OUT	SA2A,R0
	LD	R0,0020H		;ICW 2
	OUT	SA2B,R0
	LD	R0,0007H		;ICW 3
	OUT	SA2B,R0
	LD	R0,0013H		;ICW 4
	OUT	SA2B,R0
	LD	R0,0000H		;OCW 1
	OUT	SA2B,R0			;EN INT
	OUT	SA2A,R0
;
;	MOVE MONITOR IN SAME RAM SPACE
;	AND DISABLE PROM.
;
	LD	R1,0
	LD	R3,0
	LD	R2,0800H
	LDIR	R3^,R1^,R2
	MSET
;
	CLR	CTLWD
SETUPC:	LD	USPC,USERP		;SET DEFAULT USER PC
	CLR	USFCW			;SET DEFAULT USER FCW

        LD	R15,^STACK		;SET MONITOR STACK
	LD	R0,^USRSTK		;SET DEFAULT USER STACK
	LD	R14,^SIGNON
	LD	R13,SIGNONL
	CALR	RESET_RECVE_SWITCH
	LD	U15,R0
	JR	DISER
PROMPT:	LD	R14,^PRMSG
DISERA:	LD	R13,3
DISER:	CALR	CONOUT			;PROMPT
RDKBD:	CALR	CONIN			;GET COMMAND(KEYBD ADDRESS IN R14)
PRKBD:	LD	R2,' '
	LD	R3,R2			;CLEAR ASSEMBLY
	CALR	GETCH
	CP	R0,ESC
	JR	NZ,TESTCR
	CALR	GETCH
TESTCR:	CP	R0,CR
	JR	ZR,DECPOS		;END ON CR
	LD	R1,R3
	AND	R1,M8
	SRLL	RR2,8
	SLL	R0,8
	OR	R2,R0
	CALR	NEXCH			;NEXT CHARACTER
	CP	R0,' '
	JR	NZ,TESTCR
DECPOS: DEC	R14,1
	CPL	RR2,'MSA '-32
	JP	ZR,XASM			;ASSEMBLER REQUEST
	CPL	RR2,'KNAB'		;SELECT BANK
	JP	ZR,BANK			;SWITCH BANK
	CPL	RR2,'TMEM'
	JP	ZR,MEMTST
	CPL	RR2,'EMIT'		;TIME
	JP	ZR,ITIME
	CPL	RR2,'PMUD'		;DUMP
	JP	ZR,DUMP
	CPL	RR2,'DAOL'		;LOAD
	JP	ZR,LOAD
	CPL	RR2,'1XUA'		;AUX1
	JP	ZR,AUX1
	CPL	RR2,'2XUA'		;AUX2
	JP	ZR,AUX2
RESKBD: LD	R14,^KEYBD
	CALR	GETCH			;CHECK SINGLE LETTER COMMANDS
	CP	R0,ESC
	JR	NZ,SAVPOS
	CALR	GETCH
SAVPOS:	PUSH	R15^,R14
	LD	R14,^ CMDLST
	LD	R1,^CMDADD(-2)
	LD	R2,R0
CMDTLP:	INC	R1,2
	CALR	NEXCH
	TEST	R0
	JR	ZR,CMDPOP
	CP	R0,R2
	JR	NZ,CMDTLP
	POP	R14,R15^
	LD	R2,R1^
	JP	R2^			;EXECUTE SINGLE LETTER COMMAND
CMDPOP: POP	R14,R15^
CMDER:	LD	R14,^ERMSG
	JR	DISERA			;PUT QUESTION PROMPT
;
;	SET BREAKPOINT(1-3) AND EXECUTE - B COMMAND
;
SETBRK:	CLR	R11
	CLR	R12
SETBA:	CALR	HEX_TST			;FETCH BREAKPOINT ADDRESS
	LD	R13,R12
	LD	R12,R11
	RES	R1,0
	LD	R11,R1
	CP	R0,CR
	JR	ZR,SETBB
	TEST	R13
	JR	NZ,CMDER
	JR	SETBA
SETBB:	LD	R0,3
	LD	R1,^BRKTAB
SETBC:	LD	R1^,R11			;SAVE ADDRESS
	INC	R1,2
	TEST	R11
	JR	ZR,SETBD
	LD	R2,R11^
	LD	R1^,R2			;SAVE CONTENT
	LD	R11^,7FFFH		;STUFF SYSTEM CALL
SETBD:	INC	R1,2
	LD	R11,R12
	LD	R12,R13
	DBJNZ	RL0,SETBC		;LOOP FOR 3 BREAKPOINTS
	SET	CTLWD,TRMDE
SETBE:	CALR	RESTR			;RESTORE USER REGISTERS
	IRET
;
;	SET HARDWARE BREAKPOINT - E COMMAND
;
EXBRK:	CALR	HEX_TST
	PUSH	R15^,R1
	CALR	COMMA
	JP	NZ,CMDERR
	CALR	HEX_TST
	CALR	CR_CHK
	OUT	BKP+2,R1
	POP	R1,R15^
EXBRK1:	OUT	BKP,R1
	LD	HWBRK,R1
	SET	CTLWD,STPFLG
	JR	SETFCB
;
;	SET CARRY FLAG(OR CLEAR) - C COMMAND
;
SETCRY:	LD	R2,7
SETFCW:	CALR	GETBIT
	JR	NZ,CMDER
SETFCA:	LD	R0,1
	SDL	R0,R2
	COM	R0
	SDL	R1,R2
	LD	R2,USFCW
	AND	R2,R0
	OR	R2,R1
	LD	USFCW,R2
SETFCB:	JP	PROMPT
;
;	SET DECIMAL ADJUST(OR CLEAR) - D COMMAND
;
SETDAJ:	PUSH	R15^,R14
	CALR	GETBIT
	POP	R14,R15^
	LD	R2,3
	JR	ZR,SETFCA
;
;	DISPLAY MEMORY WORDS IN HEX AND ASCII -D COMMAND
;
	CALR	HEX_TST			;FETCH FROM ADDRESS
	LD	R12,R1
	RES	R12,0
	LD	R13,R12
	CP	R0,CR
	JR	ZR,DISMED		;NO END ADDRESS
	CALR	HEX_TST			;FETCH TO ADDRESS
	LD	R13,R1
	RES	R13,0
	CALR	CR_CHK
	CP	R12,R13
	JR	LGT,CMDER		;FROM > TO
DISMED:	INC	R13,2			;SET LWA+1
DISMEA:	LD	R10,R13
	SUB	R10,R12
	LD	R11,16
	JR	NZ,DISMEB
	JR	SETFCB
DISMEB:	CP	R10,R11
	JR	NC,DISMEC
	LD 	R11,R10
DISMEC:	LD	R10,R11
	LD	R14,R12
	LD	R8,^KEYBD
	LD	R1,R14
	CALR	PUTH4			;ADDRESS TO OUTPUT AREA
	LD	R1,4
	CALR	PUTSP			;4 SPACES AFTER ADDRESS
DISMEE:	LD	R1,R12^
	INC	R12,2
	CALR	PUTH4			;HEX DATA TO OUTPUT AREA
	LD	R0,' '
	CALR	PUTCH
	DEC	R10,2
	JR	NZ,DISMEE
DISMEF:	CALR	NEXCH
	CP	R0,' '
	JR	CY,DISMEG
	CP	R0,DEL
	JR	CY,DISMEH
DISMEG:	LD	R0,'_'
DISMEH:	CALR	PUTCH			;ASCII DATA TO OUTPUT AREA
	DEC	R11,1
	JR	NZ,DISMEF
	CALR	CRLF
	PUSH	R15^,R13
	PUSH	R15^,R14
	LD	R14,^KEYBD
	LD	R13,R8
	SUB	R13,R14
	CALR	CONOUT			;DISPLAY DATA LINE
	POP	R12,R15^
	POP	R13,R15^
	CALR	BREAK			;BACK TO MONITOR ?
	JP	ZR,GOPRM		;YES
	JR	DISMEA			;LOOP FOR MORE LINES
;
;	FILL MEMORY - F COMMAND
;
FILMEM:	CALR	HEX_TST			;FETCH FIRST (OR ONLY) ADDRESS
	LD	R12,R1
	RES	R12,0
	LD	R13,R12
	CALR	COMMA
	JR	NZ,CMDERR
	CALR	HEX_TST			;FETCH SECOND ADDRESS (OR VALUE)
	CP	R0,CR
	JR	ZR,FILMA		;ONLY ONE ADDRESS
	LD	R13,R1
	RES	R13,0
	CP	R12,R13
	JR	LGT,CMDERR		;FROM > TO
	CALR	HEX_TST			;FETCH VALUE
	CALR	CR_CHK
FILMA:	LD	R12^,R1			;DO FILL
	INC	R12,2
	CP	R12,R13
	JR	LLE,FILMA		;LOOP TO END
	JR	GOPRM
;
;	SET HALF CARRY FLAG(OR CLEAR) - H COMMAND
;
SETHLF:	LD	R2,2
SETHLA:	JR	SETFCW
;
;	MOVE MEMORY - M COMMAND
;
MOVE:	CALR	HEX_TST;FETCH FROM ADDRESS
	LD	R12,R1
	RES	R12,0
	CALR	COMMA
	JR	NZ,CMDERR
	CALR	HEX_TST			;FETCH THROUGH ADDRESS
	LD	R13,R1
	RES	R13,0
	CALR	COMMA
	JR	NZ,CMDERR
	CALR	HEX_TST			;FETCH TO ADDRESS
	CALR	CR_CHK
	CP	R12,R13
	JR	LGT,CMDERR
	LD	R2,R13
	SUB	R2,R12
	CP	R1,R12
	JR	LGT,MOVEA
	INC	R2,2
	SRL	R2,1
	LDIR	R1^,R12^,R2
	JR	GOPRM
MOVEA:	ADD	R1,R2
	INC     R2,2
	SRL	R2,1
	LDDR	R1^,R13^,R2
	JR	GOPRM
;
;	SET USER NORMAL MODE - NM COMMAND
;
UMODE:	CALR	GETCH
	CP	R0,'M'
	JR	ZR,NOMO
;
;	SET NVECT.INT. (OR CLEAR) - N COMMAND
;
	CP	R0,'1'
	JR	ZR,NVECT
	CP	R0,'0'
	JR	NZ,CMDERR
NVECT:	LD	R2,11
	CALR	GETBIT1
	JR	NZ,CMDERR
	JP	SETFCA
NOMO:	CLR	R3
	JR	SETMDE
;
;	SET PARITY/OVERFLOW FLAG(OR CLEAR) - P COMMAND
;
SETPAR:	PUSH	R15^,R14
	CALR	GETBIT
	POP	R14,R15^
	LD	R2,4
SETPAA:	JP	ZR,SETFCA
;
;	SET USER PC ADDRESS - P COMMAND
;
	CALR	GETCH
	CP	R0,'='
	JR	NZ,CMDERR
	CALR	HEX_TST
	CALR	CR_CHK
	LD	USPC,R1
	JR	GOPRM
;
;	SET REGISTER CONTENT - R COMMAND
;
SETREG:	PUSH	R15^,R14
	CALR	GETCH
	CLR	R13
	CP	R0,'L'
	JR	ZR,SETBRG		;LOWER BYTE REGISTER
	SET	R13,3
	CP	R0,'H'
	JR	ZR,SETBRG		;UPPER BYTE REGISTER
	POP	R14,R15^
	CALR	REGVAL
	JR	ZR,SETREA
CMDERR:	JP	CMDER
REGVAL:	CALR	DEC4
	RET	NZ
	CP	R0,'='
	RET	NZ
	LD	R12,R1
	ADD	R12,R12
	CALR	HEX16
	RET	NZ
	CP	R0,CR
	RET
SETBRG:	POP	R1,R15^
	CALR	REGVAL
	JR	NZ,CMDERR
	LD	R0,R12
	AND	R0,MU12
	JR	NZ,CMDERR
	LD	R2,R1
	AND	R1,MU8
	JR	NZ,CMDERR
	LD	R1,U0(R12)
	SDL	R2,R13
	LD	R0,M8
	SDL	R0,R13
	COM	R0
	AND	R1,R0
	OR	R1,R2
SETREA:	LD	U0(R12),R1
GOPRM:	JP	PROMPT
;
;	SET SIGN FLAG(OR CLEAR) - S COMMAND
;
SETSGN:	PUSH	R15^,R14
	CALR	GETBIT
	POP	R14,R15^
	LD	R2,5
	JP	ZR,SETFCA
;
;	SET USER SYSTEM MODE - SM COMMAND
;
	CALR	GETCH
	CP	R0,'M'
	JR	NZ,SUBST
	LD	R3,4000H
SETMDE:	CALR	GETCH
	JR	NZ,CMDERR
	LD	USFCW,R3
	JR	GOPRM
;
;	SUBSTITUTE MEMORY - S COMMAND
;
SUBST:	DEC	R14,1
	CALR	HEX_TST			;FETCH SUBSTITUTE ADDRESS
	CALR	CR_CHK
	LD	R13,R1
	RES	R13,0
SUBSTA:	LD	R8,^KEYBD
	LD	R1,R13
	CALR	PUTH4			;ADRESS TO OUTPUT AREA
	LD	R0,' '
	CALR	PUTCH			;SPACE AFTER ADDRESS
	LD	R1,R13^
	CALR	PUTH4			;CONTENT TO OUTPUT AREA
	LD	R0,'-'
	CALR	PUTCH			;HYPHEN PROMPT
	PUSH	R15^,R13
	LD	R14,^KEYBD
	LD	R13,10
	CALR	CONOUT			;DISPLAY LINE
	CALR	CONIN			;FETCH RESPONSE
	POP	R13,R15^
	CALR	GETCH
	JR	ZR,SUBSTB		;CR ONLY IS ADVANCE
	CP	R0,'.'
	JP	ZR,PROMPT		;PERIOD IS TERMINATE
	DEC	R14,1
	CALR	HEX16			;GET SUBSTITUTE VALUE
	JR	NZ,SUBSTA		;IGNORE ERRORS
	CP	R0,CR
	JR	NZ,SUBSTA
	LD	R13^,R1			;DO SUBSTITUTION
SUBSTB:	INC	R13,2
	JR	SUBSTA
;
;	EXECUTE INPUT - I COMMAND
;
IOPORT:	CALR	HEX_TST
	CALR	CR_CHK
	LD	R13,R1
IOPORT1:LD	R8,^KEYBD
	LD	R1,R13
	CALR	PUTH4
	LD	R0,' '
	CALR	PUTCH
	IN	R1,R13
	CALR	PUTH4
	PUSH	R15^,R13
	LD	R14,^KEYBD
	LD	R13,9
	CALR	CONOUT
	CALR	CONIN
	POP	R13,R15^
	CALR	GETCH
	JR	ZR,IOPORT2
	CP	R0,'.'
	JR	ZR,GOPRM
	JR	IOPORT1
IOPORT2:INC	R13,1
	JR	IOPORT1
;
;	EXECUTE OUTPUT - O COMMAND
;
OUTPORT:CALR	HEX_TST
	CALR	CR_CHK
	LD	R13,R1
OUT1:	LD	R8,^KEYBD
	LD	R1,R13
	CALR	PUTH4
	LD	R0,'-'
	CALR	PUTCH
	PUSH	R15^,R13
	LD	R14,^KEYBD
	LD	R13,5
	CALR	CONOUT
	CALR	CONIN
	POP	R13,R15^
	CALR	GETCH
	JR	ZR,OUT2
	CP	R0,'.'
	JR	ZR,GOPRM
	DEC	R14,1
	CALR	HEX16
	JR	NZ,OUT1
	CP	R0,CR
	JR	NZ,OUT1
	OUT	R13,R1
OUT2:	INC	R13,1
	JR	OUT1
;
;	SET VECT. INT. ENABLE (OR CLEAR) - V COMMAND
;
SETOVF:	LD	R2,12
	JP	SETFCW
;
;	DISPLAY REGISTERS - X COMMAND
;
DISREG:	LD	R8,^KEYBD
	CALR	GETCH
	JR	NZ,DISPRG		;NOT GENERAL CASE
	LD	R13,^U0
	CLR	R12
	CALR	PUTPC			;PC=XXXX
	LD	R1,3
DISRA:	CALR	PUTSP
	CALR	PUTRG			;REGISTERS 0-7
	INC	R13,2
	LD	R1,1
	INC	R12,1
	CP	R12,8
	JR	NZ,DISRA
	CALR	CRLF
	PUSHL	R15^,RR12
	LD	R14,^KEYBD
	LD	R13,79
	CALR	CONOUT
	POPL	RR12,R15^
	LD	R8,^KEYBD
	LD	R1,14
DISRB:	CALR	PUTSP
	CALR	PUTRG			;REGISTERS 8-15
	INC	R13,2
	LD	R1,1
	INC	R12,1
	CP	R12,16
	JR	NZ,DISRB
	LD	R13,79
DISRC:	CALR	CRLF
	LD	R14,^KEYBD
	CALR	CONOUT
DISRE:	LD	R8,^KEYBD
	CALR	PUTFL1
	LD	R13,10H
	CALR	CRLF
	LD	R14,^KEYBD
	CALR	CONOUT
	LD	R8,^KEYBD
	CALR	PUTFL2
	LD	R13,10H
DISRF:	CALR	CRLF
	LD	R14,^KEYBD
	CALR	CONOUT
DISRD:	JP	SETFCB
DISPRG:	CP	R0,'P'
	JR	NZ,DISFLG
	CALR	GETCH		;HANDLE P REGISTER
	JP	NZ,CMDER
	CALR	BRKDIS		;PC=XXXX
	JR	DISRD
DISFLG:	CP	R0,'F'
	JR	NZ,DISNRG
	CALR	GETCH		;HANDLE FLAG REGISTER
	JP	NZ,CMDRE
	CALR	PUTFL1
	JR	DISRE
DISNRG:	DEC	R14,1		;DO SPECIFIC REGISTER
	CALR	DEC4
	JP	NZ,CMDRE
	CALR	CR_CHK
	LD	R12,R1
	LD	R13,^U0(R1)
	ADD	R13,R1
	CALR	PUTRG
	LD	R13,9
	JR	DISRC
;
;	SET ZERO FLAG(OR CLEAR) - Z COMMAND
;
SETZRO:	LD	R2,6
	JP	SETFCW
;
;	GO COMMAND
;
XECTE:	RES	CTLWD,TRMDE
	CALR	GETCH
	JR	ZR,SETBEE	;NO ADDRESS
	DEC	R14,1
	CALR	HEX_TST		;FETCH PC ADDRESS
	CALR	CR_CHK
	LD	USPC,R1
SETBEE:	JP	SETBE
;
;	ASM COMMAND
;
XASM:	RES	CTLWD,TRMDE
	LD	USPC,USERP
	LD	USFCW,SYMDE
	JR	SETBEE
;
;	RAMTEST
;
MEMTST:	CALR	HEX_TST
	LD	R11,R1		;START ADDR. IN R11
	RES	R11,0
	CALR	COMMA
	JP	NZ,CMDERR
	CALR	HEX_TST
	CALR	CR_CHK
	LD	R12,R1		;END ADDR. IN R12
	RES	R12,0
	CP	R11,R12
	JP	LGT,CMDERR	;R11>R12,THEN ERROR
	LD	R3,0000H
	CALR	DISPL
	LD	R10,R11		;START ADDR. IN R10
	LD	R9,0
VUNU:	LD	R10^,R9
	CP	R10,R12
	JR	ZR,VEVO
	INC	R10,2
	JR	VUNU
VEVO:	LD	R6,R9
	INC	R9,1
;
CONT:	CALR	BREAK		;BACK TO MONITOR ?
	JP	ZR,PROMPT	;YES
	CALR	BEGREG
	INC	R3,1
	CALR	DISPL
	LD	R10,R11		;START ADDR IN R10
VOLG:	LD	R7,R10^
	CP	R6,R7		;PRIVIOUS DATA CORRECT ?
	JR	ZR,NOERR	;YES
	CALR	BREAK		;BACK TO MONITOR ?
	JP	ZR,PROMPT	;YES
	CALR	ERROR
NOERR:	LD	R10^,R9
	CP	R10,R12
	JR	ZR,ENDADR
	INC	R10,2
	JR	VOLG
ENDADR:	LD	R6,R9
	RL	R9,1
	JR	NC,CONT
	CP	R9,0FFFFH
	JR	ZR,RCM30
RCM25:	RLC	R9,1
	JR	CY,RCM25
	JR	CONT
RCM30:	LD	R6,R9
	LD	R9,1
	JR	CONT
;
BREAK:	CLRB	RL0
	INB	RL0,CPT
	CPB	RL0,'S'
	RET	NZ
BREAK1:	INB	RL0,CPT
	CPB	RL0,ESC
	RET	ZR
	CPB	RL0,'C'
	JR	NZ,BREAK1
	RESFLG	ZR
	RET
;
BEGREG:	LD	R14,^SIGNON
	LD	R13,1
	CALR	CONOUT
	RET
;
NREG:	LD	R14,^SIGNON
	LD	R13,2
	CALR	CONOUT
	RET
;
ERROR:	LD	R8,^KEYBD	;R8=BUFFER POINTER
	LD	R14,R8
	LD	R1,R10
	CALR	PUTH4		;R10 IN BUFFER
	LD	R1,4
	CALR	PUTSP		;4 SPACES IN BUFFER
	LD	R1,R7
	CALR	PUTH4		;R7 IN BUFFER
	LD	R1,4
	CALR	PUTSP		;4 SPACES IN BUFFER
	LD	R1,R6
	CALR	PUTH4		;R6 IN BUFFER
	CALR	CRLF
	LD	R13,22		;22 CHARACTERS
	CALR	CONOUT
	RET
;
DISPL:	LD	R8,^KEYBD
	LD	R14,R8
	LD	R1,R3
	CALR	PUTH4
	LD	R13,4
	CALR	CONOUT
	RET
;
CR_CHK:
	CP	R0,CR
	RET	EQ
	POP	R2,R15^
CMDRE:
	CALR	RESET_RECVE_SWITCH
	JP	CMDER
;
DISERG:	
	CALR	RESET_RECVE_SWITCH
	CALR	CONOUT
	JP	SETFCB
;
;	INPUT TIME - TIME COMMAND.
;
ITIME:	CALR	HEX_TST		;FETCH HOURS,MINUTES
	LD	R12,R1
	LD	R13,R12
	JP	NZ,CMDERR
	CALR	CR_CHK		;R12 = HOURS,MINUTES
;
	LD	R0,0FF01H	;DATA PNT CNT 1
	OUT	PTM+2,R0
	LD	R0,1139H	;MODE
	OUT	PTM,R0
;
	LD	R0,0FF02H	;DATA PNT CNT 2
	OUT	PTM+2,R0
	LD	R0,0039H	;MODE
	OUT	PTM,R0
;
	LD	R0,0FF09H	;CLEAR	COUNTER 1
	OUT	PTM+2,R0
	LD	R0,0
	OUT	PTM,R0
;
	LD	R0,0FF0AH	;CLEAR	COUNTER 2
	OUT	PTM+2,R0
	LD	R0,0
	OUT	PTM,R0
;
	LD	R0,0FF43H	;LOAD
	OUT	PTM+2,R0	;COUNTERS 1 AND 2
;
	LD	R0,0FF09H	;DATA PNT CNT 1
	OUT	PTM+2,R0	;LOAD
	LD	R0,0		;CLEAR SECONDS
	OUT	PTM,R0
	LD	R0,0FF0AH	;DATA PNT CNT 1
	OUT	PTM+2,R0	;LOAD
	OUT	PTM,R12		;LOAD HOURS AND MINUTES
	LD	R0,0FF43H	;LOAD CNT 1 AND 2
	OUT	PTM+2,R0
;
	LD	R0,0FF09H	;CLEAR COUNTER 1
	OUT	PTM+2,R0
	LD	R0,0
	OUT	PTM,R0
;
	LD	R0,0FF0AH	;CLEAR COUNTER 2
	OUT	PTM+2,R0
	LD	R0,0
	OUT	PTM,R0
;
	LD	R0,0FF23H	;ARM COUNTER 1 AND 2
	OUT	PTM+2,R0
	EI	VI		;ENABLE VECT. INT.
	JP 	PROMPT
;
;	DUMP MEMORY ON TTY IN MOTOROLA FORMAT
;
DUMP:	CALR	HEX_TST
	LD	R10,R1		;START ADDRESS IN R10
	CALR	COMMA
	JP	NZ,CMDERR
	CALR	HEX_TST
	LD	R11,R1		;END ADDRESS IN R11
DUMP10:	LD	R4,R11
	SUB	R4,R10
	CP	R4,10H
	JR	CY,DUMP20
	LD	R4,0FH
DUMP20:	ADD	R4,4
	LD	R5,R4
	SUB	R5,3
	LDB	RL0,CR
	CALR	TRNCHE
	LDB	RL0,LF
	CALR	TRNCHE
	LDB	RL0,'S'
	CALR	TRNCHE
	LDB	RL0,'1'
	CALR	TRNCHE
	CLRB	RL6
	LDB	RL0,RL4
	CALR	DUMP40
	LD	R1,R10
	LDB	RL0,RH1
	CALR	DUMP40
	LDB	RL0,RL1
	CALR	DUMP40
DUMP30:	LDB	RL0,R10^
	CALR	DUMP40
	INC	R10,1
	DEC	R5,1
	JR	NZ,DUMP30
	COMB	RL6
	LDB	RL0,RL6
	CALR	DUMP40
	CP	R10,R11
	JR	CY,DUMP10	;NEXT RECORD
	LDB	RL0,CR
	CALR	TRNCHE
	LDB	RL0,LF
	CALR	TRNCHE
	LDB	RL0,'S'
	CALR	TRNCHE
	LDB	RL0,'9'
	CALR	TRNCHE
	LDB	RL0,CR
	CALR	TRNCHE
	LDB	RL0,LF
	CALR	TRNCHE
	JP	PROMPT
;
;
DUMP40:	ADDB	RL6,RL0
	LDB	RL7,RL0
	RRB	RL0,2
	RRB	RL0,2
	CALR	DUMP50
	LDB	RL0,RL7
DUMP50:	ANDB	RL0,0FH
	ADDB	RL0,'0'
	CPB	RL0,'9'
	JR	LLE,DUMP60
	ADDB	RL0,07H
DUMP60:	CALR	TRNCHE
	RET
;
;	LOAD FROM TTY IN MOTOROLA FORMAT
;
LOAD:	CALR	RECHB		;INPUT	CHARACTER
	CPB	RL0,'S'
	JR	NZ,LOAD
	CALR	RECHB
	CPB	RL0,'9'
	JR	NZ,LOAD00
	JP	PROMPT		;LAST CHARACTER
;
LOAD00:	CPB	RL0,'1'
	JR	NZ,LOAD
LOAD10:	CLRB	RL6
	CALR	LOAD50		;INPUT BYTE COUNT
	DECB	RL0,2		;DEC. BYTE COUNT
	LDB	RH6,RL0
	CALR	LOAD40
LOAD20:	CALR	LOAD50
	DECB	RH6,1
	JR	ZR,LOAD30	;INPUT BYTE
	LDB	R7^,RL0
	INC	R7,1
	JR	LOAD20
LOAD30:	INCB	RL6,1
	JR	ZR,LOAD
	JP	CMDERR
;
LOAD40:	CALR	LOAD50
	LDB	RH7,RL0
	CALR	LOAD50
	LDB	RL7,RL0		;START ADDRESS IN R7
	RET
;
LOAD50:	CALR	RECHB		;INPUT 2 ASCII CHARACTERS
	CALR	LOAD60
	LDB	RH3,RL0
	CALR	RECHB
	CALR	LOAD60
	RLB	RH3,2
	RLB	RH3,2
	ADDB	RL0,RH3
	ADDB	RL6,RL0		;2 HEX CHARACTERS IN RL6
	RET
;
LOAD60:	CPB	RL0,'0'		;CONVERT ASCII TO HEX NIBBLE
	JP	CY,CMDERR
	CPB	RL0,3AH
	JR	CY,LOAD70
	CPB	RL0,41H
	JP	CY,CMDERR
	CPB	RL0,46H
	JP	LGT,CMDERR
	SUBB	RL0,07H
LOAD70:	ANDB	RL0,0FH
	RET
;
;	USER PROGRAM ILLEGAL TRAP
;
USERR:	CALR	SAVER		;SAVE USER REGISTERS
	RES	CTLWD,STPFLG	;CLEAR STEP CONTROL
	LD	R14,^USERM
	LD	R13,USERML
	JP	DISERG
SPEC:	CALR	SAVER
	RES	CTLWD,STPFLG
	LD	R14,^SPECM
	LD	R13,SPECML
	JP	DISERG

PRIV:	CALR	SAVER
	RES	CTLWD,STPFLG
	LD	R14,^PRIVM
	LD	R13,PRIVML
	JP	DISERG
NONV:	CALR	SAVER
	RES	CTLWD,STPFLG
	LD	R14,^NONVM
	LD	R13,NONVML
	JP	DISERG
VEC3:	CALR	SAVER
	RES	CTLWD,STPFLG
	LD	R14,^VEC3M
	LD	R13,VEC3ML
	JP	DISERG
;
VEC1:	CALR	SAVER
	RES	CTLWD,STPFLG
	LD	R14,^VEC1M
	LD	R13,VEC1ML
	JP	DISERG
;
VEC2:	CALR	SAVER
	RES	CTLWD,STPFLG
	LD	R14,^VEC2M
	LD	R13,VEC2ML
	JP	DISERG
;
;	BANK SWITCH
;
BANK:	LD	R13,BANKSW
	AND	R13,7
	LD	R8,^KEYBD
	LD	R1,R13
	CALL	PUTH4
	LD	R0,'-'
	CALL	PUTCH
	PUSH	R15^,R13
	LD	R14,^KEYBD+3
	LD	R13,2
	CALR	CONOUT
	CALR	CONIN
	POP	R13,R15^
	CALR	GETCH
	JR	ZR,BANK1
	DEC	R14,1
	CALR	HEX16
	JP	NZ,CMDERR
	CP	R0,CR
	JR	NZ,BANK1
	CP	R1,8
	JP	PL,CMDERR
	OR	R1,BNKMSK
	LD	R0,1
	SOUTD	R1^,R2^,R0
	LD	BANKSW,R1
BANK1:	JP	PROMPT
;
;	NON MASK. INTERUPT
;
STPRTN:	CALR	SAVER		;SAVE USER REGISTERS
	BIT	CTLWD,STPFLG
	LD	R4,USPC
	OUT	BKP,R4
	CALR	BRKDIS1
	LD	HWBRK,R4
STPRTB:	RES	CTLWD,STPFLG
	CALR	BRKDIS
	SET	CTLWD,STPFLG
	JP	RDKBD
;
;	STEP COMMAND(CR ONLY IF CONDITION SET)
;
STEP:	BIT	CTLWD,STPFLG
	JP	ZR,CMDER
	JP	SETBE
;
;	USER PROGRAM CALL
;
SYSCAL:	CALR	SAVER		;SAVE USER REGISTERS
	AND	R2,M8
	JR	ZR,PROCAL	;SERVICE REQUEST
	CP	R2,M8
	JR	NZ,UEXIT	;NOT BREAKPOINT TRAP
	LD	R0,3
	LD	R4,^BRKTAB
	LD	R3,USPC
	DEC	R3,2		;BACK PC TO TRAP ADDRESS
CHKBRK:	TEST	R4
	JR	ZR,UEXIT
	CP	R3,R4^
	JR	ZR,BRKHIT	;MATCH ON SET BREAKPOINT
	INC	R4,4
	DEC	R0,1
	JR	NZ,CHKBRK
UEXIT:	CALR	CLRBRK		;CLEAR BREAKPOINT TABLE
	RES	CTLWD,STPFLG
	LD	R8,^KEYBD
	PUSH	R15^,R2
	LD	R1,USEXTL
	LD	R2,^USEXT
	CALR	PUTMS
	POP	R1,R15^
	SLA	R1,8
	CALR	PUTHXB
	LD	R13,USEXTL+4
	JP	DISRF
BRKHIT:	LD	USPC,R3		;SET USER PC TO TRAP LOCATION
	CALR	CLRBRK		;AND CLEAR BREAKPOINT TABLE
	JR	STPRTB
CLRBRK:	LD	R0,3		;CLEAR BREAKPOINT TABLE(IN REVERSE)
	LD	R4,^BRKTAB(8)
CLRBA:	LD	R5,R4^
	CLR	R4^
	INC	R4,2
	TEST	R5
	JR	ZR,CLRBB
	LD	R6,R4^
	CLR	R4^
	LD	R5^,R6		;RESTORE BREAKPOINT CONTENT
CLRBB:	DEC	R4,6
	DEC	R0,1
	JR	NZ,CLRBA
	RET
;
;	PROCESS A USER PROGRAM REQUEST
;
PROCAL:	LDM	R3,R1^,4	;FETCH PARAMETER LIST
	SRA	R3,8
	AND	R3,M8
	CP	R3,1
	JR	CY,PROCAA
	JR	NZ,PROCAE
	CALR	CONIN		;RETURN KEYBOARD REQUEST
	CALR	GETCH
	CP	R0,ESC
	JP	ZR,PRKBD	;ESCAPE IS MONITOR RETURN
PROCAA:	LD	R1,U1
	LD	R14,^KEYBD
	LDM	R3,R1^,4
	LD	R8,R5
	LD	R7,R6
	CLR	R6
PROCAB:	SUB	R7,1
	JR	CY,PROCAC	;PREMATURE END
	CALR	NEXCH
	LD	R9,R0
	CALR	PUTCH
	INC	R6,1
	CP	R9,CR
	JR	NZ,PROCAB
	CLR	R7		;NORMAL END
PROCAC:	NEG	R7
PROCAD:	AND	R3,MU8
	OR	R3,R7
	LD	R1,U1
	LDM	R1^,R3,4	;RESTORE USER PARAMETERS
	JP	SETBE
PROCAE:	CP	R3,3
	LD	R13,R6		;OUTPUT CONSOLE REQUEST
	JR	NC,PROCAG
	LD	R14,R5
	CALR	CONOUT
	CLR	R7
PROCAF:	LD	R1,U1
	LDM	R3,R1^,4
	JR	PROCAD
PROCAG:	LD	R14,R4
	CLR	R4
	JR	ZR,PROCAC
	LD	R4,R14
	CP	R3,7
	JR	NC,PROCAC
	CLR	R13
PROCAH:	JP	PROCAC
;
;	TRANSMIT CHARACTER IN R0
;
TRNCHE:	IN	R2,SPT+2
	BIT	R2,2
	JR	ZR,TRNCHE	;WAIT SERIAL READY
	OUT	SPT,R0
	RET
;
;	RECEIVE CHARACTER TO R0
;
RECHB:	IN	R0,SPT+2
	BITB	RL0,0H
	JR	ZR,RECHB
	IN	R0,SPT
RECHF:	ANDB	RL0,M8
	CLRB	RH0
	RES	R0,7
	RET
;
;	TTY OUTPUT GOES TO AUX1
;
AUX1:	LD	R4,2
	LD	R5,10
	LD	TRNCHE(R4),CPT+10
	LD	TRNCHE(R5),CPT+8
	LD	RECHB(R4),CPT+10
	LD	RECHB(R5),CPT+8
PRPT:	JP	PROMPT
;
;	TTY OUTPUT GOES TO AUX2
;
AUX2:	LD	R4,2
	LD	R5,10
	LD	TRNCHE(R4),CPT+14
	LD	TRNCHE(R5),CPT+12
	LD	RECHB(R4),CPT+14
	LD	RECHB(R5),CPT+12
	JR	PRPT
;
;	READ KEYBOARD MESSAGE
;
CONIN:	LD	R8,^KEYBD
	LD	R5,R8
	LD	R13,80
	JR	CRTWT		;RS232 CONSOLE
CONID:	CALR	PUTCH
	LD	R14,^PRMSG+1
	LD	R13,2
	CALR	CONOUT		;ECHO CARRIAGE RETURN LINE FEED
CONIE:	LD	R14,^KEYBD
	RET
;
;	INPUT FROM SERIAL CONSOLE
;
CRTWT:	IN	R0,CPT+2
	BITB	RL0,0H
	JR	ZR,CRTWT
	IN	R0,CPT
	AND	R0,M7
	CP	R0,CR
	JR	ZR,CONID	;CARRIAGE RETURN
	CALR	PROCH
	JR	CRTWT
PROCH:	CP	R0,DEL
	JR	ZR,PRODL
	CP	R0,BSP
	JR	ZR,PRODL
	CP	R0,CAN
	JR	ZR,PROCN
	CP	R0,' '
	RET	CY
	LD	R2,^KEYBD+79
	CP	R8,R2
	RET	ZR
	LD	R14,R8
	LD	R13,1
	CALR	PUTCH
	CALR	CONOUT		;ECHO CHARACTER
	RET
PRODL:	LD	R2,^KEYBD
	CP	R8,R2
	RET	ZR
	LD	R14,^BSPMS
	DEC	R8,1
PRODM:	LD	R13,3
	CALR	CONOUT
	RET
PROCN:	LD	R14,^CNMSG
	LD	R8,^KEYBD
	JR	PRODM
;
;	OUT R13 CHARACTERS FROM R14 TO CONSOLE
;
CONOUT:	CALR	NEXCH
	CP	R0,DEL
	JR	LGE,CONLF
	JR	CONCRT		;RS232 CONSOLE
CONLF:	DEC	R13,1
	JR	NZ,CONOUT
	RET
CONCRT:	IN	R1,CPT+2
	BITB	RL1,2H
	JR	ZR,CONCRT
	OUT	CPT,R0
	JR	CONLF
;
;	FETCH NEXT CHARACTER FROM (R14) TO R0
;
NEXCH:	LDB	RL0,R14^
	INC	R14,1
	CLRB	RH0
	CP	R0,CR
	RET
;
;	FETCH NEXT NON-BLANK CHARACTER FROM (R14) TO R0 - SET CR FLAG
;
GETCH:	CALR	NEXCH
	RET	ZR
	CP	R0,' '
	JR	ZR,GETCH
	RET
;
;	FETCH 16 BIT HEX TO R1 FROM (R14) TO CR OR COMMA
;
HEX_TST:CALR	HEX16
	RET	ZR
	POP	R2,R15^
	JP	CMDER
HEX16:	CLR	R1
	CALR	GETCH
HX16A:	SUB	R0,'0'
	RET	CY
	CP	R0,10
	JR	CY,HX16B
	SUB	R0,7
	CP	R0,10
	RET	CY
	CP	R0,15
	RET	LGT
HX16B:	LD	R2,R1
	AND	R2,MU4
	RET	NZ
	SLL	R1,4
	OR	R1,R0
	CALR	GETCH
	RET	ZR
	CP	R0,','
	RET	ZR
	JR	HX16A
;
;	FETCH 0 OR 1 BIT TO R1 FROM (R14)
;
GETBIT:	CALR	GETCH
GETBIT1:SUB	R0,'0'
	RET	CY
	LD	R1,R0
	SUB	R0,1
	RET	LGT
	JR	GETCH
;
;	PUT 4 HEX DIGITS FROM R1 TO (R8)
;
PUTH4:	CALR	PUTHD
	CALR	PUTHD
PUTHXB:	CALR	PUTHD
PUTHD:	SLLL	RR0,4
	AND	R0,M4
	ADD	R0,'0'
	CP	R0,'9'+1
	JR	MI,PUTCH
	ADD	R0,7
PUTCH:	LDB	R8^,RL0
	INC	R8,1
	RET
;
;	PUT CR AND LF TO (R8)
;
CRLF:	LD	R0,CR
	CALR	PUTCH
	LD	R0,LF
	JR	PUTCH
;
;	RESTORE USER REGISTERS
;
RESTR:	LD	R0,U15
	POP	U15,R15^
	LDL	RR2,USFCW
	BIT	R2,14
	JR	NZ,RESTRB	;ENTERING SYSTEM MODE
	LDCTL	NSPOFF,R0
RESTRA:	PUSHL	R15^,RR2
	PUSH	R15^,R2
	LDM	R0,U0,15
	PUSH	R15^,U15
	RET
RESTRB:	LD	R15,R0
	JR	RESTRA
;
;	FETCH 16 BIT DECIMAL TO R1 FROM (R14) TO CR, =,OR COMMA
;
DEC16:	CLR	R1
	CALR	GETCH
DEC16A:	SUB	R0,'0'
	RET	CY
	CP	R0,9
	RET	LGT
	LD	R2,R0
	MULT	RR0,10
	ADD	R1,R2
	CLR	R2
	ADC	R0,R2
	RET	NZ
	CALR	GETCH
	RET	ZR
	CP	R0,'='
	RET	ZR
	CALR	COMMA
	RET	ZR
	JR	DEC16A
;
;	FETCH 4 BIT DECIMAL TO R1 FROM (R14) TO CR, =, OR COMMA
;
DEC4:	CALR	DEC16
	LD	R2,R1
	AND	R2,MU12
	RET
;
;	PUT R1 SPACES TO (R8)
;
PUTSP:	LD	R0,' '
	CALR	PUTCH
	DEC	R1,1
	JR	NZ,PUTSP
	RET
;
;	PUT R1 CHARACTERS FROM R2 TO (R8)
;
PUTMS:	LDIRB	R8^,R2^,R1
	RET
;
;	PUT NXT PC=XXXX TO (R8)
;
PUTPC:	LD	R1,7
	LD	R2,^PCMS
	CALR	PUTMS
	LD	R1,USPC
	CALR	PUTH4
	RET
;
;	REGISTER IN R13=(R23) TO (R8)
;
PUTRG:	CP	R12,10
	JR	CY,PUTRA
	LD	R0,'1'
	CALR	PUTCH
	LD	R0,R12
	ADD	R0,'0'-10
	JR	PUTRB
PUTRA:	LD	R0,' '
	CALR	PUTCH
	LD	R0,R12
	ADD	R0,'0'
PUTRB:	CALR	PUTCH
	LD	R0,'='
	CALR	PUTCH
	LD	R1,R13^
	JP	PUTH4
;
;	FLAG REGISTER TO (R8) CZSPDH
;
PUTFL1:	LD	R14,^FCWL
	LD	R3,0EH
PUTFA:	CALR	NEXCH
	CALR	PUTCH
	DBJNZ	RL3,PUTFA
	RET
;
PUTFL2:	LD	R1,USFCW
	LD	R3,0EH
PUTFB:	LD	R0,'0'/2
	RL	R1,1
	ADC	R0,R0
	CALR	PUTCH
	DBJNZ	RL3,PUTFB
	RET
;
;	SAVE USER REGISTERS
;
SAVER:	LDM	U0,R0,15
	POP	R3,R15^
	POP	R2,R15^
	POPL	RR4,R15^
	LDL	USFCW,RR4
	BIT	R4,14
	JR	NZ,SAVERA	;FROM SYSTEM MODE
	LDCTL	R0,NSPOFF
	LD	U15,R0
	JP	R3^
SAVERA:	LD	U15,R15
	LD	R15,^STACK
	JP	R3^
;
;	DISPLAY NXT PC=XXXX FOR BREAKPOINT
;
BRKDIS:	LD	R8,^KEYBD
	CALR	PUTPC
	LD	R2,^NIMS
	LD	R1,4
	CALR	PUTMS
	LD	R2,USPC
	LD	R1,R2^
	CALR	PUTH4
	CALR	CRLF
	LD	R13,21
	LD	R14,^KEYBD
	CALR	CONOUT
	RET
;
;	DISPLAY BRK PC=XXXX
;
BRKDIS1:LD	R8,^KEYBD
	CALR	PUTBPC
	CALR	CRLF
	LD	R13,13
	LD	R14,^KEYBD
	CALR	CONOUT
	RET
;
;	PUT BRK PC=XXXX TO (R8)
;
PUTBPC:	LD	R1,7
	LD	R2,^BPCMS
	CALR	PUTMS
	LD	R1,HWBRK
	CALR	PUTH4
	RET
;
RESET_RECVE_SWITCH:
	LDA	CHDEST,PUTCH	; RESET CO-ROUTINE SWITCH
	RET
;
COMMA:	CP	R0,','
	RET
;
; READ TIME AND DISPLAY
;
CLOCK:	PUSHL	R15^,RR0	;SAVE REGISTERS
	PUSHL	R15^,RR2
	PUSHL	R15^,RR4
	PUSH	R15^,R8
	PUSH	R15^,R14
	LD	R0,0FFA3H	;SAVE CNT 1 & 2
	OUT	PTM+2,R0
	LD	R0,0FF11H	;DATA PNT
	OUT	PTM+2,R0	;
	IN	R3,PTM		;INPUT SECONDS
	LD	R0,0FF12H	;DATA PNT
	OUT	PTM+2,R0	;TO CNT 2
	IN	R2,PTM		;INPUT HOURS,MINUTES,SECONDS
	LD	R8,^KEYBD	;DISPLAY TIME
	CALR	CRLF
	LD	R1,R2		;HOUR MINUTES
	CALR	PUTH4
	LD	R0,':'
	CALR	PUTCH
	LD	R1,R3		;SECONDS
	CALR	PUTH4
	LD	R14,^KEYBD
	LD	R13,11
	CALR	CONOUT		;DISPLAY
	POP	R14,R15^
	POP	R8,R15^
	POPL	RR4,R15^
	POPL	RR2,R15^
	POPL	RR0,R15^
	EI	VI
	IRET
;
; CHANNEL A
;
SRCBUFA:DB	18H		;CHANNEL A RESET
	DB	04H		;SELECT WR 4.
	DB	44H		;X16,1 STOPB,N.PARITY.
	DB	05H		;SELECT WR 5.
	DB	68H		; 8 BITS, TX EN.
	DB	03H		;SELECT WR 3.
	DB	0C1H		; 8 BITS, RX EN.
	DB	01H		;SELECT WR 1.
	DB	12H		;TXINT,RXINT EN.
	DB	00H		;SELECT RR0
ENDBUFA:
;
;CHANNEL B
;
SRCBUFB:DB	18H		;CHANNEL B RESET
	DB	04H		;SELECT WR 4.
	DB	44H		;X16,1 STOPB,N.PARITY.
	DB	05H		;SELECT WR 5.
	DB	68H		; 8 BITS, TX EN.
	DB	03H		;SELECT WR 3.
	DB	0C1H		; 8 BITS, RX EN.
	DB	01H		;SELECT WR 1.
	DB	12H		;TXINT,RXINT EN.
	DB	00H		;SELECT RR0
ENDBUFB:
;	ORIGIN	DATA		; TODO
;
;
NPSAREA:DW	126 DUP (?)	;NEW PROGRAM STATUS AREA
;
;
STATE:
CHDEST:	DW	1 DUP (?)	;CO-ROUTINE ENTRY POINT
COUNT:	DW	1 DUP (?)	;#BYTES TO BE TRANSFERED
DEST_ADR: DW	1 DUP (?)	;DESTINATION ADDRESS
OLD_STATE: DW	3 DUP (?)	;CO-ROUTINE RECOVERY INFO
BANKSW:	DW	1 DUP (?)	;BANKSWITCH REGISTER
CTLWD:	DW	1 DUP (?)	;CONSOLE I/O SWITCH CONTROL
KEYBD:	DW	41 DUP (?)	;KEYBOARD BUFFER
HWBRK:	DW	1 DUP (?)	;HARDWARE BREAKPOINT
BRKTAB:	DW	6 DUP (?)	;BREAKPOINT TABLE
TRCNT:	DW	1 DUP (?)	;TRACE INSTRUCTION COUNT
TRDIS:	DW	1 DUP (?)	;TRACE DISPLAY INTERVAL
TRINC:	DW	1 DUP (?)	;TRACE DISPLAY COUNT
USFCW:	DW	1 DUP (?)	;USER FLAG CONTROL DW
USPC:	DW	1 DUP (?)	;USER PROGRAM COUNTER
U0:	DW	1 DUP (?)	;USER REGISTER SAVE AREA
U1:	DW	1 DUP (?)
U2:	DW	1 DUP (?)
U3:	DW	1 DUP (?)
U4:	DW	1 DUP (?)
U5:	DW	1 DUP (?)
U6:	DW	1 DUP (?)
U7:	DW	1 DUP (?)
U8:	DW	1 DUP (?)
U9:	DW	1 DUP (?)
U10:	DW	1 DUP (?)
U11:	DW	1 DUP (?)
U12:	DW	1 DUP (?)
U13:	DW	1 DUP (?)
U14:	DW	1 DUP (?)
U15:	DW	1 DUP (?)
	DW	20 DUP (?)	;USER STACK AREA
USRSTK:	DW	0 DUP (?)
	DW	20 DUP (?)	;SYSTEM STACK
STACK:	DW	0 DUP (?)
	END
