/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionFork
implements Instruction {
    private final List<InstructionList> forks = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;

    public InstructionFork(Instruction parent, LinkRendering inlinkRendering) {
        this.parent = parent;
        this.inlinkRendering = inlinkRendering;
        this.forks.add(new InstructionList());
    }

    private InstructionList getLast() {
        return this.forks.get(this.forks.size() - 1);
    }

    @Override
    public void add(Instruction ins) {
        this.getLast().add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.forks) {
            all.add(list.createFtile(factory));
        }
        return factory.createFork(this.getSwimlaneIn(), all);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void forkAgain() {
        this.forks.add(new InstructionList());
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position) {
        return this.getLast().addNote(note, position);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.forks);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getLast().getSwimlaneOut();
    }

    public void manageOutRendering(LinkRendering nextLinkRenderer) {
        if (nextLinkRenderer == null) {
            return;
        }
        this.getLast().setOutRendering(nextLinkRenderer);
    }
}

