/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class AtomImg
implements Atom {
    private final BufferedImage image;

    private AtomImg(BufferedImage image) {
        this.image = image;
    }

    public static Atom create(String src, ImgValign valign, int vspace) {
        UFont font = new UFont("Monospaced", 0, 14);
        FontConfiguration fc = new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true);
        try {
            File f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                if (src.startsWith("http:") || src.startsWith("https:")) {
                    byte[] image = AtomImg.getFile(src);
                    BufferedImage read = ImageIO.read(new ByteArrayInputStream(image));
                    if (read == null) {
                        return AtomText.create("(Cannot decode: " + src + ")", fc);
                    }
                    return new AtomImg(read);
                }
                return AtomText.create("(File not found: " + f + ")", fc);
            }
            if (f.getName().endsWith(".svg")) {
                throw new UnsupportedOperationException();
            }
            BufferedImage read = ImageIO.read(f);
            if (read == null) {
                return AtomText.create("(Cannot decode: " + f + ")", fc);
            }
            return new AtomImg(ImageIO.read(f));
        }
        catch (IOException e) {
            return AtomText.create("ERROR " + e.toString(), fc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFile(String host) throws IOException {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        InputStream input = null;
        try {
            int read;
            URL url = new URL(host);
            URLConnection connection = url.openConnection();
            input = connection.getInputStream();
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer)) > 0) {
                image.write(buffer, 0, read);
            }
            image.close();
            byte[] byArray = image.toByteArray();
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.draw(new UImage(this.image));
    }
}

