/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;

public class Code
implements Comparable<Code> {
    private final String fullName;
    private final String separator;

    private Code(String fullName, String separator) {
        if (fullName == null) {
            throw new IllegalArgumentException();
        }
        this.fullName = fullName;
        this.separator = separator;
    }

    public Code withSeparator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException();
        }
        if (this.separator != null && !this.separator.equals(separator)) {
            throw new IllegalStateException();
        }
        return new Code(this.fullName, separator);
    }

    public static Code of(String code) {
        return Code.of(code, null);
    }

    public static Code of(String code, String separator) {
        if (code == null) {
            return null;
        }
        return new Code(code, separator);
    }

    public final String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.fullName + "(" + this.separator + ")";
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        Code other = (Code)obj;
        return this.fullName.equals(other.fullName);
    }

    public Code addSuffix(String suffix) {
        return new Code(this.fullName + suffix, this.separator);
    }

    @Override
    public int compareTo(Code other) {
        return this.fullName.compareTo(other.fullName);
    }

    public Code eventuallyRemoveStartingAndEndingDoubleQuote(String format) {
        return Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.fullName, format), this.separator);
    }

    private final String getNamespace(Map<Code, ILeaf> leafs) {
        int x;
        String name = this.getFullName();
        if (this.separator == null) {
            throw new IllegalArgumentException(this.toString());
        }
        do {
            if ((x = name.lastIndexOf(this.separator)) != -1) continue;
            return null;
        } while (leafs.containsKey(Code.of(name = name.substring(0, x), this.separator)));
        return name;
    }

    public final Code getShortName(Map<Code, ILeaf> leafs) {
        if (this.separator == null) {
            throw new IllegalArgumentException();
        }
        String code = this.getFullName();
        String namespace = this.getNamespace(leafs);
        if (namespace == null) {
            return Code.of(code, this.separator);
        }
        return Code.of(code.substring(namespace.length() + this.separator.length()), this.separator);
    }

    public final Code getFullyQualifiedCode(IGroup g) {
        if (this.separator == null) {
            throw new IllegalArgumentException();
        }
        String full = this.getFullName();
        if (full.startsWith(this.separator)) {
            return Code.of(full.substring(this.separator.length()), this.separator);
        }
        if (full.contains(this.separator)) {
            return Code.of(full, this.separator);
        }
        if (EntityUtils.groupRoot(g)) {
            return Code.of(full, this.separator);
        }
        Code namespace2 = g.getNamespace2();
        if (namespace2 == null) {
            return Code.of(full, this.separator);
        }
        return Code.of(namespace2.fullName + this.separator + full, this.separator);
    }
}

