/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericNumber;
import net.sourceforge.plantuml.project.NumericType;

class Load
implements Numeric {
    private final long minuteMen;

    public Load(long minuteMen) {
        this.minuteMen = minuteMen;
    }

    public Load(NumericNumber value) {
        this((long)value.getIntValue() * 24L * 60L * 60L);
    }

    @Override
    public Numeric add(Numeric other) {
        return new Load(((Load)other).minuteMen + this.minuteMen);
    }

    @Override
    public NumericType getNumericType() {
        return NumericType.LOAD;
    }

    @Override
    public int compareTo(Numeric other) {
        Load this2 = (Load)other;
        if (this2.minuteMen > this.minuteMen) {
            return -1;
        }
        if (this2.minuteMen < this.minuteMen) {
            return 1;
        }
        return 0;
    }

    public final long getMinuteMen() {
        return this.minuteMen;
    }

    public String toString() {
        return "LOAD:" + this.minuteMen / 86400L;
    }
}

