/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.Day;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Month;
import net.sourceforge.plantuml.project.Project;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TimeScale {
    private final UFont font = new UFont("Serif", 0, 9);
    private final Project project;
    private final FontConfiguration fontConfig = new FontConfiguration(this.font, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true);

    public TimeScale(Project project) {
        this.project = project;
    }

    public void draw(UGraphic ug, double x, double y) {
        Dimension2D dim;
        TextBlock b;
        Day d;
        StringBounder stringBounder = ug.getStringBounder();
        double monthHeight = this.getMonthHeight(stringBounder);
        double caseWidth = this.getCaseWidth(stringBounder);
        double caseHeight = this.getCaseHeight(stringBounder);
        int nb = this.getNbCase();
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        ug.apply(new UTranslate(x, y)).draw(new URectangle((double)nb * caseWidth, monthHeight));
        Instant end = this.project.getEnd();
        Month printed = null;
        double curx = x;
        Instant cur = this.project.getStart();
        while (cur.compareTo(end) <= 0) {
            d = cur.getDay();
            if (printed == null || d.getMonth() != printed) {
                ug.apply(new UTranslate(curx, y)).draw(new ULine(0.0, monthHeight));
                printed = d.getMonth();
                b = Display.create(printed.name()).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                dim = b.calculateDimension(stringBounder);
                b.drawU(ug.apply(new UTranslate(curx, y + (monthHeight - dim.getHeight()) / 2.0)));
            }
            curx += caseWidth;
            cur = cur.next(this.project.getDayClose());
        }
        curx = x;
        ug.apply(new UTranslate(x, y += monthHeight)).draw(new URectangle((double)nb * caseWidth, caseHeight));
        cur = this.project.getStart();
        while (cur.compareTo(end) <= 0) {
            d = cur.getDay();
            b = Display.create("" + d.getNumDay()).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            dim = b.calculateDimension(stringBounder);
            b.drawU(ug.apply(new UTranslate(curx + (caseWidth - dim.getWidth()) / 2.0, y + (caseHeight - dim.getHeight()) / 2.0)));
            ug.apply(new UTranslate(curx += caseWidth, y)).draw(new ULine(0.0, caseHeight));
            cur = cur.next(this.project.getDayClose());
        }
    }

    public SortedMap<Instant, Double> getAbscisse(StringBounder stringBounder) {
        TreeMap<Instant, Double> pos = new TreeMap<Instant, Double>();
        double caseWidth = this.getCaseWidth(stringBounder);
        Instant end = this.project.getEnd();
        double x = 0.0;
        Instant cur = this.project.getStart();
        while (cur.compareTo(end) <= 0) {
            pos.put(cur, x);
            x += caseWidth;
            cur = cur.next(this.project.getDayClose());
        }
        return Collections.unmodifiableSortedMap(pos);
    }

    private int getNbCase() {
        int result = 0;
        Instant end = this.project.getEnd();
        Instant cur = this.project.getStart();
        while (cur.compareTo(end) <= 0) {
            ++result;
            cur = cur.next(this.project.getDayClose());
        }
        return result;
    }

    private double getCaseWidth(StringBounder stringBounder) {
        Dimension2D dim00 = stringBounder.calculateDimension(this.font, "00");
        return dim00.getWidth() + 3.0;
    }

    private double getCaseHeight(StringBounder stringBounder) {
        Dimension2D dim00 = stringBounder.calculateDimension(this.font, "00");
        return dim00.getHeight() + 3.0;
    }

    private double getMonthHeight(StringBounder stringBounder) {
        Dimension2D dimZZ = stringBounder.calculateDimension(this.font, "ZZ");
        return dimZZ.getHeight() + 3.0;
    }

    public double getWidth(StringBounder stringBounder) {
        return this.getCaseWidth(stringBounder) * (double)this.getNbCase();
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getCaseHeight(stringBounder) + this.getMonthHeight(stringBounder);
    }
}

