/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageDescription
extends AbstractEntityImage {
    private final Url url;
    private final TextBlock asSmall;

    public EntityImageDescription(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        USymbol symbol;
        Stereotype stereotype = entity.getStereotype();
        USymbol uSymbol = entity.getUSymbol() == null ? (skinParam.useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (symbol = entity.getUSymbol());
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        Display codeDisplay = Display.getWithNewlines(entity.getCode());
        TextBlock desc = entity.getDisplay().equals(codeDisplay) && symbol instanceof USymbolFolder || entity.getDisplay().isWhite() ? TextBlockUtils.empty(0.0, 0.0) : new BodyEnhanced(entity.getDisplay(), symbol.getFontParam(), skinParam, HorizontalAlignment.CENTER, stereotype, symbol.manageHorizontalLine(), false, false);
        this.url = entity.getUrl99();
        HtmlColor backcolor = this.getEntity().getSpecificBackColor();
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), symbol.getColorParamBack(), this.getStereo());
        }
        HtmlColor forecolor = SkinParamUtils.getColor(this.getSkinParam(), symbol.getColorParamBorder(), this.getStereo());
        SymbolContext ctx = new SymbolContext(backcolor, forecolor).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing2(symbol.getSkinParameter()));
        TextBlock stereo = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getLabel(false) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().useGuillemet())).create(new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), symbol.getFontParamStereotype(), stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), symbol.getFontParamStereotype(), null), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, skinParam);
        }
        BodyEnhanced name = new BodyEnhanced(codeDisplay, symbol.getFontParam(), skinParam, HorizontalAlignment.CENTER, stereotype, symbol.manageHorizontalLine(), false, false);
        this.asSmall = symbol.asSmall(name, desc, stereo, ctx);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asSmall.drawU(ug);
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

